/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Recyclable;
import io.opentelemetry.contrib.inferredspans.internal.util.ByteUtils;
import io.opentelemetry.contrib.inferredspans.internal.util.HexUtils;
import io.opentelemetry.sdk.trace.ReadableSpan;
import javax.annotation.Nullable;

public class TraceContext
implements Recyclable {
    public static final int SERIALIZED_LENGTH = 42;
    private long traceIdLow;
    private long traceIdHigh;
    private long id;
    private boolean hasParentId;
    private long parentId;
    private byte flags;
    private long clockAnchor;

    static TraceContext fromSpanContextWithZeroClockAnchor(SpanContext ctx, @Nullable String parentSpanId) {
        TraceContext result = new TraceContext();
        result.fillFromSpanContext(ctx, parentSpanId);
        result.clockAnchor = 0L;
        return result;
    }

    private void fillFromSpanContext(SpanContext ctx, @Nullable String parentSpanId) {
        this.id = HexUtils.hexToLong(ctx.getSpanId(), 0);
        this.traceIdHigh = HexUtils.hexToLong(ctx.getTraceId(), 0);
        this.traceIdLow = HexUtils.hexToLong(ctx.getTraceId(), 16);
        if (parentSpanId != null) {
            this.hasParentId = true;
            this.parentId = HexUtils.hexToLong(parentSpanId, 0);
        } else {
            this.hasParentId = false;
        }
        this.flags = ctx.getTraceFlags().asByte();
    }

    public SpanContext toOtelSpanContext(StringBuilder temporaryBuilder) {
        temporaryBuilder.setLength(0);
        HexUtils.appendLongAsHex(this.traceIdHigh, temporaryBuilder);
        HexUtils.appendLongAsHex(this.traceIdLow, temporaryBuilder);
        String traceIdStr = temporaryBuilder.toString();
        temporaryBuilder.setLength(0);
        HexUtils.appendLongAsHex(this.id, temporaryBuilder);
        String idStr = temporaryBuilder.toString();
        return SpanContext.create((String)traceIdStr, (String)idStr, (TraceFlags)TraceFlags.fromByte((byte)this.flags), (TraceState)TraceState.getDefault());
    }

    public long getSpanId() {
        return this.id;
    }

    public static long getSpanId(byte[] serialized) {
        return ByteUtils.getLong(serialized, 16);
    }

    public boolean idEquals(@Nullable TraceContext o) {
        if (o == null) {
            return false;
        }
        return this.id == o.id;
    }

    public void deserialize(byte[] serialized) {
        this.traceIdLow = ByteUtils.getLong(serialized, 0);
        this.traceIdHigh = ByteUtils.getLong(serialized, 8);
        this.id = ByteUtils.getLong(serialized, 16);
        this.flags = serialized[24];
        this.hasParentId = serialized[25] != 0;
        this.parentId = ByteUtils.getLong(serialized, 26);
        this.clockAnchor = ByteUtils.getLong(serialized, 34);
    }

    public static long getParentId(byte[] serializedTraceContext) {
        boolean hasParent;
        boolean bl = hasParent = serializedTraceContext[25] != 0;
        if (!hasParent) {
            return 0L;
        }
        return ByteUtils.getLong(serializedTraceContext, 26);
    }

    public boolean traceIdAndIdEquals(byte[] otherSerialized) {
        long otherTraceIdLow = ByteUtils.getLong(otherSerialized, 0);
        if (otherTraceIdLow != this.traceIdLow) {
            return false;
        }
        long otherTraceIdHigh = ByteUtils.getLong(otherSerialized, 8);
        if (otherTraceIdHigh != this.traceIdHigh) {
            return false;
        }
        long otherId = ByteUtils.getLong(otherSerialized, 16);
        return this.id == otherId;
    }

    public static void serialize(byte[] buffer, Span span, long clockAnchor) {
        SpanContext ctx = span.getSpanContext();
        SpanContext parentSpanCtx = SpanContext.getInvalid();
        if (span instanceof ReadableSpan) {
            parentSpanCtx = ((ReadableSpan)span).getParentSpanContext();
        }
        long id = HexUtils.hexToLong(ctx.getSpanId(), 0);
        long traceIdHigh = HexUtils.hexToLong(ctx.getTraceId(), 0);
        long traceIdLow = HexUtils.hexToLong(ctx.getTraceId(), 16);
        byte flags = ctx.getTraceFlags().asByte();
        ByteUtils.putLong(buffer, 0, traceIdLow);
        ByteUtils.putLong(buffer, 8, traceIdHigh);
        ByteUtils.putLong(buffer, 16, id);
        buffer[24] = flags;
        if (parentSpanCtx.isValid()) {
            buffer[25] = 1;
            ByteUtils.putLong(buffer, 26, HexUtils.hexToLong(parentSpanCtx.getSpanId(), 0));
        } else {
            buffer[25] = 0;
            ByteUtils.putLong(buffer, 26, 0L);
        }
        ByteUtils.putLong(buffer, 34, clockAnchor);
    }

    public void serialize(byte[] buffer) {
        ByteUtils.putLong(buffer, 0, this.traceIdLow);
        ByteUtils.putLong(buffer, 8, this.traceIdHigh);
        ByteUtils.putLong(buffer, 16, this.id);
        buffer[24] = this.flags;
        if (this.hasParentId) {
            buffer[25] = 1;
            ByteUtils.putLong(buffer, 26, this.parentId);
        } else {
            buffer[25] = 0;
            ByteUtils.putLong(buffer, 26, 0L);
        }
        ByteUtils.putLong(buffer, 34, this.clockAnchor);
    }

    public byte[] serialize() {
        byte[] result = new byte[42];
        this.serialize(result);
        return result;
    }

    @Override
    public void resetState() {
        this.traceIdLow = 0L;
        this.traceIdHigh = 0L;
        this.id = 0L;
        this.flags = 0;
        this.clockAnchor = 0L;
    }

    public long getClockAnchor() {
        return this.clockAnchor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        SpanContext otelSpanCtx = this.toOtelSpanContext(result);
        result.setLength(0);
        result.append(otelSpanCtx).append("(clock-anchor: ").append(this.clockAnchor).append(')');
        return result.toString();
    }
}

