/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.contrib.inferredspans.internal.ChildList;
import io.opentelemetry.contrib.inferredspans.internal.SpanAnchoredClock;
import io.opentelemetry.contrib.inferredspans.internal.StackFrame;
import io.opentelemetry.contrib.inferredspans.internal.TraceContext;
import io.opentelemetry.contrib.inferredspans.internal.pooling.ObjectPool;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Recyclable;
import io.opentelemetry.contrib.inferredspans.internal.semconv.Attributes;
import io.opentelemetry.contrib.inferredspans.internal.util.HexUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.agrona.collections.LongHashSet;

public class CallTree
implements Recyclable {
    private static final int INITIAL_CHILD_SIZE = 2;
    public static final io.opentelemetry.api.common.Attributes CHILD_LINK_ATTRIBUTES = io.opentelemetry.api.common.Attributes.builder().put(Attributes.LINK_IS_CHILD, (Object)true).build();
    public static final BiConsumer<SpanBuilder, SpanContext> DEFAULT_PARENT_OVERRIDE = (inferredSpan, child) -> inferredSpan.addLink(child, CHILD_LINK_ATTRIBUTES);
    @Nullable
    private CallTree parent;
    protected int count;
    private List<CallTree> children = new ArrayList<CallTree>(2);
    @Nullable
    private StackFrame frame;
    protected long start;
    private long lastSeen;
    private boolean ended;
    private long activationTimestamp = -1L;
    @Nullable
    private TraceContext activeContextOfDirectParent;
    private long deactivationTimestamp = -1L;
    private boolean isSpan;
    private int depth;
    @Nullable
    private ChildList childIds;
    @Nullable
    private ChildList maybeChildIds;

    public void set(@Nullable CallTree parent, StackFrame frame, long nanoTime) {
        this.parent = parent;
        this.frame = frame;
        this.start = nanoTime;
        if (parent != null) {
            this.depth = parent.depth + 1;
        }
    }

    public boolean isSuccessor(CallTree parent) {
        if (this.depth > parent.depth) {
            return this.getNthParent(this.depth - parent.depth) == parent;
        }
        return false;
    }

    @Nullable
    public CallTree getNthParent(int n) {
        CallTree parent = this;
        for (int i = 0; i < n; ++i) {
            if (parent == null) {
                return null;
            }
            parent = parent.parent;
        }
        return parent;
    }

    public void activation(@Nullable TraceContext traceContext, long activationTimestamp) {
        this.activeContextOfDirectParent = traceContext;
        this.activationTimestamp = activationTimestamp;
    }

    protected void handleDeactivation(TraceContext deactivatedSpan, long activationTimestamp, long deactivationTimestamp) {
        if (deactivatedSpan.idEquals(this.activeContextOfDirectParent)) {
            this.deactivationTimestamp = deactivationTimestamp;
        } else {
            CallTree lastChild = this.getLastChild();
            if (lastChild != null) {
                lastChild.handleDeactivation(deactivatedSpan, activationTimestamp, deactivationTimestamp);
            }
        }
        if (this.happenedDuring(activationTimestamp) && this.happenedAfter(deactivationTimestamp)) {
            this.lastSeen = deactivationTimestamp;
        }
    }

    private boolean happenedDuring(long timestamp) {
        return this.start <= timestamp && timestamp <= this.lastSeen;
    }

    private boolean happenedAfter(long timestamp) {
        return this.lastSeen < timestamp;
    }

    public static Root createRoot(ObjectPool<Root> rootPool, byte[] traceContext, long nanoTime) {
        Root root = rootPool.createInstance();
        root.set(traceContext, nanoTime);
        return root;
    }

    protected CallTree addFrame(List<StackFrame> stackFrames, int index, @Nullable TraceContext activeSpan, long activationTimestamp, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs, Root root) {
        ++this.count;
        this.lastSeen = nanoTime;
        if (activeSpan != null && this.activeContextOfDirectParent != null && this.activeContextOfDirectParent.idEquals(activeSpan)) {
            activeSpan = null;
        }
        CallTree lastChild = this.getLastChild();
        CallTree topOfStack = this;
        boolean endChild = true;
        if (index >= 1) {
            StackFrame frame = stackFrames.get(--index);
            if (lastChild != null) {
                if (!lastChild.isEnded() && frame.equals(lastChild.frame)) {
                    topOfStack = lastChild.addFrame(stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs, root);
                    endChild = false;
                } else {
                    topOfStack = this.addChild(frame, stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs, root);
                }
            } else {
                topOfStack = this.addChild(frame, stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs, root);
            }
        }
        if (lastChild != null && !lastChild.isEnded() && endChild) {
            lastChild.end(callTreePool, minDurationNs, root);
        }
        this.transferMaybeChildIdsToChildIds();
        return topOfStack;
    }

    private void transferMaybeChildIdsToChildIds() {
        if (this.maybeChildIds != null) {
            if (this.childIds == null) {
                this.childIds = this.maybeChildIds;
                this.maybeChildIds = null;
            } else {
                this.childIds.addAll(this.maybeChildIds);
                this.maybeChildIds.clear();
            }
        }
    }

    private CallTree addChild(StackFrame frame, List<StackFrame> stackFrames, int index, @Nullable TraceContext traceContext, long activationTimestamp, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs, Root root) {
        CallTree callTree = callTreePool.createInstance();
        callTree.set(this, frame, nanoTime);
        if (traceContext != null) {
            callTree.activation(traceContext, activationTimestamp);
        }
        this.children.add(callTree);
        return callTree.addFrame(stackFrames, index, null, activationTimestamp, nanoTime, callTreePool, minDurationNs, root);
    }

    long getDurationUs() {
        return this.getDurationNs() / 1000L;
    }

    private long getDurationNs() {
        return this.lastSeen - this.start;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public StackFrame getFrame() {
        return this.frame;
    }

    public List<CallTree> getChildren() {
        return this.children;
    }

    protected void end(ObjectPool<CallTree> pool, long minDurationNs, Root root) {
        this.ended = true;
        if (this.deactivationHappenedBeforeEnd()) {
            this.start = Math.min(this.activationTimestamp, this.start);
            if (this.parent != null) {
                this.parent.giveLastChildIdTo(this);
            }
            List<CallTree> callTrees = this.getChildren();
            int size = callTrees.size();
            for (int i = 0; i < size; ++i) {
                CallTree child = callTrees.get(i);
                child.activation(this.activeContextOfDirectParent, this.activationTimestamp);
                child.deactivationTimestamp = this.deactivationTimestamp;
                child.end(pool, minDurationNs, root);
            }
            this.activeContextOfDirectParent = null;
            this.activationTimestamp = -1L;
            this.deactivationTimestamp = -1L;
        }
        if (this.parent != null && this.isTooFast(minDurationNs)) {
            root.previousTopOfStack = this.parent;
            this.parent.removeChild(pool, this);
        } else {
            CallTree lastChild = this.getLastChild();
            if (lastChild != null && !lastChild.isEnded()) {
                lastChild.end(pool, minDurationNs, root);
            }
        }
    }

    private boolean isTooFast(long minDurationNs) {
        return this.count == 1 || this.isFasterThan(minDurationNs);
    }

    private void removeChild(ObjectPool<CallTree> pool, CallTree child) {
        this.children.remove(child);
        child.recursiveGiveChildIdsTo(this);
        child.recycle(pool);
    }

    private boolean isFasterThan(long minDurationNs) {
        return this.getDurationNs() < minDurationNs;
    }

    private boolean deactivationHappenedBeforeEnd() {
        return this.activeContextOfDirectParent != null && this.deactivationTimestamp > -1L && this.lastSeen > this.deactivationTimestamp;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    private boolean isPillar() {
        return this.children.size() == 1 && this.children.get((int)0).count == this.count;
    }

    @Nullable
    public CallTree getLastChild() {
        return this.children.size() > 0 ? this.children.get(this.children.size() - 1) : null;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.toString(sb);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sb.toString();
    }

    private void toString(Appendable out) throws IOException {
        this.toString(out, 0);
    }

    private void toString(Appendable out, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            out.append("  ");
        }
        out.append(this.frame != null ? this.frame.getClassName() : "null").append('.').append(this.frame != null ? this.frame.getMethodName() : "null").append(' ').append(Integer.toString(this.count)).append('\n');
        for (CallTree node : this.children) {
            node.toString(out, level + 1);
        }
    }

    int spanify(Root root, @Nullable Span parentSpan, TraceContext parentContext, SpanAnchoredClock clock, BiConsumer<SpanBuilder, SpanContext> spanParentOverride, StringBuilder tempBuilder, Tracer tracer) {
        int createdSpans = 0;
        if (this.activeContextOfDirectParent != null) {
            parentSpan = null;
            parentContext = this.activeContextOfDirectParent;
        }
        Span span = null;
        if (!this.isPillar() || this.isLeaf()) {
            ++createdSpans;
            span = this.asSpan(root, parentSpan, parentContext, tracer, clock, spanParentOverride, tempBuilder);
            this.isSpan = true;
        }
        List<CallTree> children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            createdSpans += children.get(i).spanify(root, span != null ? span : parentSpan, parentContext, clock, spanParentOverride, tempBuilder, tracer);
        }
        return createdSpans;
    }

    protected Span asSpan(Root root, @Nullable Span parentSpan, TraceContext parentContext, Tracer tracer, SpanAnchoredClock clock, BiConsumer<SpanBuilder, SpanContext> spanParentOverride, StringBuilder tempBuilder) {
        Context parentOtelCtx;
        if (parentSpan != null) {
            parentOtelCtx = Context.root().with((ImplicitContextKeyed)parentSpan);
        } else {
            tempBuilder.setLength(0);
            parentOtelCtx = Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentContext.toOtelSpanContext(tempBuilder)));
        }
        tempBuilder.setLength(0);
        assert (this.frame != null);
        String classFqn = this.frame.getClassName();
        if (classFqn != null) {
            tempBuilder.append(classFqn, this.frame.getSimpleClassNameOffset(), classFqn.length());
        } else {
            tempBuilder.append("null");
        }
        tempBuilder.append("#");
        tempBuilder.append(this.frame.getMethodName());
        this.transferMaybeChildIdsToChildIds();
        SpanBuilder spanBuilder = tracer.spanBuilder(tempBuilder.toString()).setParent(parentOtelCtx).setAttribute(Attributes.SPAN_IS_INFERRED, (Object)true).setStartTimestamp(clock.toEpochNanos(parentContext.getClockAnchor(), this.start), TimeUnit.NANOSECONDS);
        this.insertChildIdLinks(spanBuilder, Span.fromContext((Context)parentOtelCtx).getSpanContext(), parentContext, spanParentOverride, tempBuilder);
        if (parentSpan != null || !root.rootContext.idEquals(parentContext)) {
            assert (this.parent != null);
            tempBuilder.setLength(0);
            this.parent.fillStackTrace(tempBuilder);
            spanBuilder.setAttribute(Attributes.CODE_STACKTRACE, (Object)tempBuilder.toString());
        }
        Span span = spanBuilder.startSpan();
        span.end(clock.toEpochNanos(parentContext.getClockAnchor(), this.start + this.getDurationNs()), TimeUnit.NANOSECONDS);
        return span;
    }

    private void insertChildIdLinks(SpanBuilder span, SpanContext parentContext, TraceContext nonInferredParent, BiConsumer<SpanBuilder, SpanContext> spanParentOverride, StringBuilder tempBuilder) {
        if (this.childIds == null || this.childIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.childIds.getSize(); ++i) {
            if (nonInferredParent.getSpanId() != this.childIds.getParentId(i)) continue;
            tempBuilder.setLength(0);
            HexUtils.appendLongAsHex(this.childIds.getId(i), tempBuilder);
            SpanContext childSpanContext = SpanContext.create((String)parentContext.getTraceId(), (String)tempBuilder.toString(), (TraceFlags)parentContext.getTraceFlags(), (TraceState)parentContext.getTraceState());
            spanParentOverride.accept(span, childSpanContext);
        }
    }

    private void fillStackTrace(StringBuilder resultBuilder) {
        if (this.parent != null && !this.isSpan) {
            if (resultBuilder.length() > 0) {
                resultBuilder.append('\n');
            }
            assert (this.frame != null);
            resultBuilder.append("at ").append(this.frame.getClassName()).append('.').append(this.frame.getMethodName()).append('(');
            this.frame.appendFileName(resultBuilder);
            resultBuilder.append(')');
            this.parent.fillStackTrace(resultBuilder);
        }
    }

    public final void recycle(ObjectPool<CallTree> pool) {
        assert (!(this instanceof Root));
        List<CallTree> children = this.children;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            children.get(i).recycle(pool);
        }
        pool.recycle(this);
    }

    @Override
    public void resetState() {
        this.parent = null;
        this.count = 0;
        this.frame = null;
        this.start = 0L;
        this.lastSeen = 0L;
        this.ended = false;
        this.activationTimestamp = -1L;
        this.activeContextOfDirectParent = null;
        this.deactivationTimestamp = -1L;
        this.isSpan = false;
        this.childIds = null;
        this.maybeChildIds = null;
        this.depth = 0;
        if (this.children.size() > 2) {
            this.children = new ArrayList<CallTree>(2);
        } else {
            this.children.clear();
        }
    }

    public void addMaybeChildId(long id, long parentId) {
        if (this.maybeChildIds == null) {
            this.maybeChildIds = new ChildList();
        }
        this.maybeChildIds.add(id, parentId);
    }

    public void addChildId(long id, long parentId) {
        if (this.childIds == null) {
            this.childIds = new ChildList();
        }
        this.childIds.add(id, parentId);
    }

    public boolean hasChildIds() {
        return this.maybeChildIds != null && this.maybeChildIds.getSize() > 0 || this.childIds != null && this.childIds.getSize() > 0;
    }

    public void recursiveGiveChildIdsTo(CallTree giveTo) {
        int childrenSize = this.children.size();
        for (int i = 0; i < childrenSize; ++i) {
            this.children.get(i).recursiveGiveChildIdsTo(giveTo);
        }
        this.giveChildIdsTo(giveTo);
        this.giveMaybeChildIdsTo(giveTo);
    }

    void giveChildIdsTo(CallTree giveTo) {
        if (this.childIds == null) {
            return;
        }
        if (giveTo.childIds == null) {
            giveTo.childIds = this.childIds;
        } else {
            giveTo.childIds.addAll(this.childIds);
        }
        this.childIds = null;
    }

    void giveLastChildIdTo(CallTree giveTo) {
        if (this.childIds != null && !this.childIds.isEmpty()) {
            int size = this.childIds.getSize();
            long id = this.childIds.getId(size - 1);
            long parentId = this.childIds.getParentId(size - 1);
            giveTo.addChildId(id, parentId);
            this.childIds.removeLast();
        }
    }

    void giveMaybeChildIdsTo(CallTree giveTo) {
        if (this.maybeChildIds == null) {
            return;
        }
        if (giveTo.maybeChildIds == null) {
            giveTo.maybeChildIds = this.maybeChildIds;
        } else {
            giveTo.maybeChildIds.addAll(this.maybeChildIds);
        }
        this.maybeChildIds = null;
    }

    public int getDepth() {
        return this.depth;
    }

    public static class Root
    extends CallTree
    implements Recyclable {
        private static final Logger logger = Logger.getLogger(Root.class.getName());
        private static final StackFrame ROOT_FRAME = new StackFrame("root", "root");
        protected TraceContext rootContext;
        @Nullable
        private TraceContext activeSpan;
        private long activationTimestamp = -1L;
        private final byte[] activeSpanSerialized = new byte[42];
        @Nullable
        private CallTree previousTopOfStack;
        @Nullable
        private CallTree topOfStack;
        private final LongHashSet activeSet = new LongHashSet();

        public Root() {
            this.rootContext = new TraceContext();
        }

        private void set(byte[] traceContext, long nanoTime) {
            super.set(null, ROOT_FRAME, nanoTime);
            this.rootContext.deserialize(traceContext);
            this.setActiveSpan(traceContext, nanoTime);
        }

        public void setActiveSpan(byte[] activeSpanSerialized, long timestamp) {
            this.activationTimestamp = timestamp;
            System.arraycopy(activeSpanSerialized, 0, this.activeSpanSerialized, 0, activeSpanSerialized.length);
            this.activeSpan = null;
        }

        public void onActivation(byte[] active, long timestamp) {
            this.setActiveSpan(active, timestamp);
            if (this.topOfStack != null) {
                long spanId = TraceContext.getSpanId(active);
                this.activeSet.add(spanId);
                if (!this.isNestedActivation(this.topOfStack)) {
                    this.topOfStack.addMaybeChildId(spanId, TraceContext.getParentId(active));
                }
            }
        }

        private boolean isNestedActivation(CallTree topOfStack) {
            return this.isAnyActive(topOfStack.childIds) || this.isAnyActive(topOfStack.maybeChildIds);
        }

        private boolean isAnyActive(@Nullable ChildList spanIds) {
            if (spanIds == null) {
                return false;
            }
            int size = spanIds.getSize();
            for (int i = 0; i < size; ++i) {
                if (!this.activeSet.contains(spanIds.getId(i))) continue;
                return true;
            }
            return false;
        }

        public void onDeactivation(byte[] deactivated, byte[] active, long timestamp) {
            if (logger.isLoggable(Level.FINE) && !Arrays.equals(this.activeSpanSerialized, deactivated)) {
                logger.log(Level.WARNING, "Illegal state: deactivating span that is not active");
            }
            if (this.activeSpan != null) {
                this.handleDeactivation(this.activeSpan, this.activationTimestamp, timestamp);
            }
            this.setActiveSpan(active, timestamp);
            if (this.topOfStack != null) {
                long spanId = TraceContext.getSpanId(deactivated);
                this.activeSet.remove(spanId);
            }
        }

        public void addStackTrace(List<StackFrame> stackTrace, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs) {
            boolean firstFrameAfterActivation = false;
            if (this.activeSpan == null) {
                firstFrameAfterActivation = true;
                this.activeSpan = new TraceContext();
                this.activeSpan.deserialize(this.activeSpanSerialized);
            }
            this.previousTopOfStack = this.topOfStack;
            this.topOfStack = this.addFrame(stackTrace, stackTrace.size(), this.activeSpan, this.activationTimestamp, nanoTime, callTreePool, minDurationNs, this);
            if (firstFrameAfterActivation && this.previousTopOfStack != this.topOfStack && this.previousTopOfStack != null && this.previousTopOfStack.hasChildIds() && !this.topOfStack.isSuccessor(this.previousTopOfStack)) {
                CallTree newParent;
                CallTree commonAncestor = Root.findCommonAncestor(this.previousTopOfStack, this.topOfStack);
                CallTree callTree = newParent = commonAncestor != null ? commonAncestor : this.topOfStack;
                if (newParent.count > 1) {
                    this.previousTopOfStack.giveMaybeChildIdsTo(newParent);
                } else if (this.previousTopOfStack.maybeChildIds != null) {
                    this.previousTopOfStack.maybeChildIds.clear();
                }
            }
        }

        @Nullable
        private static CallTree findCommonAncestor(CallTree previousTopOfStack, CallTree topOfStack) {
            CallTree ancestor2;
            CallTree ancestor1;
            int maxDepthOfCommonAncestor = Math.min(previousTopOfStack.getDepth(), topOfStack.getDepth());
            CallTree commonAncestor = null;
            for (int i = 1; i <= maxDepthOfCommonAncestor && (ancestor1 = previousTopOfStack.getNthParent(previousTopOfStack.getDepth() - i)) == (ancestor2 = topOfStack.getNthParent(topOfStack.getDepth() - i)); ++i) {
                commonAncestor = ancestor1;
            }
            return commonAncestor;
        }

        public int spanify(SpanAnchoredClock clock, Tracer tracer, BiConsumer<SpanBuilder, SpanContext> normalSpanOverride) {
            StringBuilder tempBuilder = new StringBuilder();
            int createdSpans = 0;
            List<CallTree> callTrees = this.getChildren();
            int size = callTrees.size();
            for (int i = 0; i < size; ++i) {
                createdSpans += callTrees.get(i).spanify(this, null, this.rootContext, clock, normalSpanOverride, tempBuilder, tracer);
            }
            return createdSpans;
        }

        public TraceContext getRootContext() {
            return this.rootContext;
        }

        public void recycle(ObjectPool<CallTree> childrenPool, ObjectPool<Root> rootPool) {
            List<CallTree> children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                children.get(i).recycle(childrenPool);
            }
            rootPool.recycle(this);
        }

        public void end(ObjectPool<CallTree> pool, long minDurationNs) {
            this.end(pool, minDurationNs, this);
        }

        @Override
        public void resetState() {
            super.resetState();
            this.rootContext.resetState();
            this.activeSpan = null;
            this.activationTimestamp = -1L;
            Arrays.fill(this.activeSpanSerialized, (byte)0);
            this.previousTopOfStack = null;
            this.topOfStack = null;
            this.activeSet.clear();
        }
    }
}

