/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal.asyncprofiler;

import io.opentelemetry.contrib.inferredspans.internal.pooling.Recyclable;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class BufferedFile
implements Recyclable {
    private final Logger logger = Logger.getLogger(BufferedFile.class.getName());
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private static final int STRING_ENCODING_NULL = 0;
    private static final int STRING_ENCODING_EMPTY = 1;
    private static final int STRING_ENCODING_CONSTANTPOOL = 2;
    private static final int STRING_ENCODING_UTF8 = 3;
    private static final int STRING_ENCODING_CHARARRAY = 4;
    private static final int STRING_ENCODING_LATIN1 = 5;
    private ByteBuffer buffer;
    private final ByteBuffer bigBuffer;
    private final ByteBuffer smallBuffer;
    private long offset;
    private boolean wholeFileInBuffer;
    @Nullable
    private FileChannel fileChannel;

    public BufferedFile(ByteBuffer bigBuffer, ByteBuffer smallBuffer) {
        this.bigBuffer = bigBuffer;
        this.smallBuffer = smallBuffer;
    }

    public void setFile(File file) throws IOException {
        this.fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        if (this.fileChannel.size() <= (long)this.bigBuffer.capacity()) {
            this.buffer = this.bigBuffer;
            this.read(0L, this.bigBuffer.capacity());
            this.wholeFileInBuffer = true;
        } else {
            ByteBuffer buffer = this.buffer = this.smallBuffer;
            ((Buffer)buffer).flip();
        }
    }

    public void skip(int bytesToSkip) {
        this.position(this.position() + (long)bytesToSkip);
    }

    public void skipString() throws IOException {
        this.readOrSkipString(this.get(), null);
    }

    public boolean readString(StringBuilder output) throws IOException {
        byte encoding = this.get();
        if (encoding == 0) {
            return false;
        }
        this.readOrSkipString(encoding, output);
        return true;
    }

    @Nullable
    public String readString() throws IOException {
        byte encoding = this.get();
        if (encoding == 0) {
            return null;
        }
        if (encoding == 1) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        this.readOrSkipString(encoding, output);
        return output.toString();
    }

    private void readOrSkipString(byte encoding, @Nullable StringBuilder output) throws IOException {
        switch (encoding) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                if (output != null) {
                    throw new IllegalStateException("Reading constant pool string is not supported");
                }
                this.getVarLong();
                return;
            }
            case 3: {
                this.readOrSkipUtf8(output);
                return;
            }
            case 4: {
                throw new IllegalStateException("Char-array encoding is not supported by the parser yet");
            }
            case 5: {
                if (output != null) {
                    throw new IllegalStateException("Reading LATIN1 encoded string is not supported");
                }
                this.skip(this.getVarInt());
                return;
            }
        }
        throw new IllegalStateException("Unknown string encoding type: " + encoding);
    }

    private void readOrSkipUtf8(@Nullable StringBuilder output) throws IOException {
        int len = this.getVarInt();
        if (output == null) {
            this.skip(len);
            return;
        }
        this.ensureRemaining(len, len);
        for (int i = 0; i < len; ++i) {
            byte hopefullyAscii = this.getUnsafe();
            if (hopefullyAscii <= 0) {
                this.position(this.position() - 1L);
                byte[] utf8Data = new byte[len - i];
                this.buffer.get(utf8Data);
                output.append(new String(utf8Data, StandardCharsets.UTF_8));
                return;
            }
            output.append((char)hopefullyAscii);
        }
    }

    public long position() {
        return this.offset + (long)this.buffer.position();
    }

    public void position(long pos) {
        ByteBuffer buffer = this.buffer;
        long positionDelta = pos - this.position();
        long newBufferPos = (long)buffer.position() + positionDelta;
        if (0L <= newBufferPos && newBufferPos <= (long)buffer.limit()) {
            ((Buffer)buffer).position((int)newBufferPos);
        } else {
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(0);
            this.offset = pos;
        }
    }

    public void ensureRemaining(int minRemaining) throws IOException {
        this.ensureRemaining(minRemaining, this.buffer.capacity());
    }

    public void ensureRemaining(int minRemaining, int maxRead) throws IOException {
        if (this.wholeFileInBuffer) {
            return;
        }
        if (minRemaining > this.buffer.capacity()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Length (%d) greater than buffer capacity (%d)", minRemaining, this.buffer.capacity()));
        }
        if (this.buffer.remaining() < minRemaining) {
            this.read(this.position(), maxRead);
        }
    }

    public byte get() throws IOException {
        this.ensureRemaining(1);
        return this.buffer.get();
    }

    public short getShort() throws IOException {
        this.ensureRemaining(2);
        return this.buffer.getShort();
    }

    public int getUnsignedShort() throws IOException {
        return this.getShort() & 0xFFFF;
    }

    public int getInt() throws IOException {
        this.ensureRemaining(4);
        return this.buffer.getInt();
    }

    public long getLong() throws IOException {
        this.ensureRemaining(8);
        return this.buffer.getLong();
    }

    public long getVarLong() throws IOException {
        long value = 0L;
        boolean hasNext = true;
        int shift = 0;
        while (hasNext) {
            long byteVal = this.get();
            hasNext = (byteVal & 0x80L) != 0L;
            value |= (byteVal & 0x7FL) << shift;
            shift += 7;
        }
        return value;
    }

    public int getVarInt() throws IOException {
        long val = this.getVarLong();
        if ((long)((int)val) != val) {
            throw new IllegalArgumentException("The LEB128 encoded value does not fit in an int");
        }
        return (int)val;
    }

    public byte getUnsafe() {
        return this.buffer.get();
    }

    public short getUnsafeShort() {
        return this.buffer.getShort();
    }

    public int getUnsafeInt() {
        return this.buffer.getInt();
    }

    public long getUnsafeLong() {
        return this.buffer.getLong();
    }

    public long size() throws IOException {
        if (this.fileChannel == null) {
            throw new IllegalStateException("setFile has not been called yet");
        }
        return this.fileChannel.size();
    }

    public boolean isSet() {
        return this.fileChannel != null;
    }

    @Override
    public void resetState() {
        if (this.fileChannel == null) {
            throw new IllegalStateException("setFile has not been called yet");
        }
        ByteBuffer buffer = this.buffer;
        ((Buffer)buffer).clear();
        this.offset = 0L;
        this.wholeFileInBuffer = false;
        try {
            this.fileChannel.close();
        }
        catch (IOException ignore) {
            this.logger.log(Level.FINE, "Ignored exception on file close", ignore);
        }
        this.fileChannel = null;
        this.buffer = null;
    }

    private void read(long offset, int limit) throws IOException {
        if (limit > this.buffer.capacity()) {
            limit = this.buffer.capacity();
        }
        ByteBuffer buffer = this.buffer;
        ((Buffer)buffer).clear();
        assert (this.fileChannel != null);
        this.fileChannel.position(offset);
        ((Buffer)buffer).limit(limit);
        this.fileChannel.read(this.buffer);
        ((Buffer)buffer).flip();
        this.offset = offset;
    }
}

