/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventPoller;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.contrib.inferredspans.WildcardMatcher;
import io.opentelemetry.contrib.inferredspans.internal.CallTree;
import io.opentelemetry.contrib.inferredspans.internal.InferredSpansConfiguration;
import io.opentelemetry.contrib.inferredspans.internal.ProfilingActivationListener;
import io.opentelemetry.contrib.inferredspans.internal.SpanAnchoredClock;
import io.opentelemetry.contrib.inferredspans.internal.StackFrame;
import io.opentelemetry.contrib.inferredspans.internal.ThreadMatcher;
import io.opentelemetry.contrib.inferredspans.internal.TraceContext;
import io.opentelemetry.contrib.inferredspans.internal.asyncprofiler.JfrParser;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Allocator;
import io.opentelemetry.contrib.inferredspans.internal.pooling.ObjectPool;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import one.profiler.AsyncProfiler;
import org.agrona.collections.Long2ObjectHashMap;

public class SamplingProfiler
implements Runnable {
    private static final String LIB_DIR_PROPERTY_NAME = "one.profiler.extractPath";
    private static final Logger logger = Logger.getLogger(SamplingProfiler.class.getName());
    private static final int ACTIVATION_EVENTS_IN_FILE = 1000000;
    private static final int MAX_STACK_DEPTH = 256;
    private static final int PRE_ALLOCATE_ACTIVATION_EVENTS_FILE_MB = 10;
    private static final int MAX_ACTIVATION_EVENTS_FILE_SIZE = 102000000;
    private static final int ACTIVATION_EVENTS_BUFFER_SIZE = 417792;
    private final SpanAnchoredClock clock;
    private final EventTranslatorTwoArg<ActivationEvent, Span, Span> activationEventTranslator;
    private final EventTranslatorTwoArg<ActivationEvent, Span, Span> deactivationEventTranslator;
    static final int RING_BUFFER_SIZE = 4096;
    private final InferredSpansConfiguration config;
    private final ScheduledExecutorService scheduler;
    private final Long2ObjectHashMap<CallTree.Root> profiledThreads = new Long2ObjectHashMap();
    private final RingBuffer<ActivationEvent> eventBuffer;
    private volatile boolean profilingSessionOngoing = false;
    private final Sequence sequence;
    private final ObjectPool<CallTree.Root> rootPool;
    private final ThreadMatcher threadMatcher = new ThreadMatcher();
    private final EventPoller<ActivationEvent> poller;
    @Nullable
    private File jfrFile;
    private boolean canDeleteJfrFile;
    private final WriteActivationEventToFileHandler writeActivationEventToFileHandler = new WriteActivationEventToFileHandler();
    @Nullable
    private JfrParser jfrParser;
    private volatile int profilingSessions;
    private final ByteBuffer activationEventsBuffer;
    @Nullable
    private File activationEventsFile;
    private boolean canDeleteActivationEventsFile;
    @Nullable
    private FileChannel activationEventsFileChannel;
    private final ObjectPool<CallTree> callTreePool;
    private final TraceContext contextForLogging;
    private final ProfilingActivationListener activationListener;
    private final Supplier<Tracer> tracerProvider;
    private final AsyncProfiler profiler;

    public SamplingProfiler(InferredSpansConfiguration config, SpanAnchoredClock nanoClock, Supplier<Tracer> tracerProvider, @Nullable File activationEventsFile, @Nullable File jfrFile) {
        this.config = config;
        this.tracerProvider = tracerProvider;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("otel-inferred-spans");
            return thread;
        });
        this.clock = nanoClock;
        this.activationEventTranslator = (event, sequence, active, previouslyActive) -> event.activation((Span)active, Thread.currentThread().getId(), (Span)previouslyActive, this.clock.nanoTime(), this.clock);
        this.deactivationEventTranslator = (event, sequence, active, previouslyActive) -> event.deactivation((Span)active, Thread.currentThread().getId(), (Span)previouslyActive, this.clock.nanoTime(), this.clock);
        this.eventBuffer = SamplingProfiler.createRingBuffer();
        this.sequence = new Sequence();
        this.eventBuffer.addGatingSequences(new Sequence[]{this.sequence});
        this.poller = this.eventBuffer.newPoller(new Sequence[0]);
        this.contextForLogging = new TraceContext();
        this.callTreePool = ObjectPool.createRecyclable(2048, new Allocator<CallTree>(){

            @Override
            public CallTree createInstance() {
                return new CallTree();
            }
        });
        this.rootPool = ObjectPool.createRecyclable(512, new Allocator<CallTree.Root>(){

            @Override
            public CallTree.Root createInstance() {
                return new CallTree.Root();
            }
        });
        this.jfrFile = jfrFile;
        this.activationEventsBuffer = ByteBuffer.allocateDirect(417792);
        this.activationEventsFile = activationEventsFile;
        this.profiler = this.loadProfiler();
        this.activationListener = ProfilingActivationListener.register(this);
    }

    public InferredSpansConfiguration getConfig() {
        return this.config;
    }

    private AsyncProfiler loadProfiler() {
        String libDir = this.config.getProfilerLibDirectory();
        try {
            Files.createDirectories(Paths.get(libDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory to extract lib to", e);
        }
        System.setProperty(LIB_DIR_PROPERTY_NAME, libDir);
        return AsyncProfiler.getInstance();
    }

    boolean isProfilingActiveOnThread(Thread thread) {
        return this.profiledThreads.containsKey(thread.getId());
    }

    private synchronized void createFilesIfRequired() throws IOException {
        if (this.jfrFile == null || !this.jfrFile.exists()) {
            this.jfrFile = File.createTempFile("otel-inferred-traces-", ".jfr");
            this.jfrFile.deleteOnExit();
            this.canDeleteJfrFile = true;
        }
        if (this.activationEventsFile == null || !this.activationEventsFile.exists()) {
            this.activationEventsFile = File.createTempFile("otel-inferred-activation-events-", ".bin");
            this.activationEventsFile.deleteOnExit();
            this.canDeleteActivationEventsFile = true;
        }
        if (this.activationEventsFileChannel == null || !this.activationEventsFileChannel.isOpen()) {
            this.activationEventsFileChannel = FileChannel.open(this.activationEventsFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        if (this.activationEventsFileChannel.size() == 0L) {
            SamplingProfiler.preAllocate(this.activationEventsFileChannel, 10);
        }
    }

    private static void preAllocate(FileChannel channel, int mb) throws IOException {
        long initialPos = channel.position();
        ByteBuffer oneKb = ByteBuffer.allocate(1024);
        for (int i = 0; i < mb * 1024; ++i) {
            channel.write(oneKb);
            ((Buffer)oneKb).clear();
        }
        channel.position(initialPos);
    }

    private static RingBuffer<ActivationEvent> createRingBuffer() {
        return RingBuffer.createMultiProducer((EventFactory)new EventFactory<ActivationEvent>(){

            public ActivationEvent newInstance() {
                return new ActivationEvent();
            }
        }, (int)4096, (WaitStrategy)new NoWaitStrategy());
    }

    public boolean onActivation(Span activeSpan, @Nullable Span previouslyActive) {
        if (this.profilingSessionOngoing) {
            boolean success;
            if (previouslyActive == null) {
                this.profiler.addThread(Thread.currentThread());
            }
            if (!(success = this.eventBuffer.tryPublishEvent(this.activationEventTranslator, (Object)activeSpan, (Object)previouslyActive))) {
                logger.fine("Could not add activation event to ring buffer as no slots are available");
            }
            return success;
        }
        return false;
    }

    public boolean onDeactivation(Span activeSpan, @Nullable Span previouslyActive) {
        if (this.profilingSessionOngoing) {
            boolean success;
            if (previouslyActive == null) {
                this.profiler.removeThread(Thread.currentThread());
            }
            if (!(success = this.eventBuffer.tryPublishEvent(this.deactivationEventTranslator, (Object)activeSpan, (Object)previouslyActive))) {
                logger.fine("Could not add deactivation event to ring buffer as no slots are available");
            }
            return success;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.createFilesIfRequired();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "unable to initialize profiling files", e);
            return;
        }
        Duration profilingDuration = this.config.getProfilingDuration();
        boolean postProcessingEnabled = this.config.isPostProcessingEnabled();
        this.setProfilingSessionOngoing(postProcessingEnabled);
        if (postProcessingEnabled) {
            logger.fine("Start full profiling session (async-profiler and agent processing)");
        } else {
            logger.fine("Start async-profiler profiling session");
        }
        try {
            this.profile(profilingDuration);
        }
        catch (Throwable t) {
            this.setProfilingSessionOngoing(false);
            logger.log(Level.SEVERE, "Stopping profiler", t);
            return;
        }
        logger.fine("End profiling session");
        boolean interrupted = Thread.currentThread().isInterrupted();
        boolean continueProfilingSession = this.config.isNonStopProfiling() && !interrupted && postProcessingEnabled;
        this.setProfilingSessionOngoing(continueProfilingSession);
        if (!interrupted && !this.scheduler.isShutdown()) {
            long delay = this.config.getProfilingInterval().toMillis() - profilingDuration.toMillis();
            this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }

    private void profile(Duration profilingDuration) throws Exception {
        try {
            String startCommand = this.createStartCommand();
            String startMessage = this.profiler.execute(startCommand);
            logger.fine(startMessage);
            if (!this.profiledThreads.isEmpty()) {
                this.restoreFilterState(this.profiler);
            }
            ++this.profilingSessions;
            this.consumeActivationEventsFromRingBufferAndWriteToFile(profilingDuration);
            String stopMessage = this.profiler.execute("stop");
            logger.fine(stopMessage);
            this.processTraces();
        }
        catch (InterruptedException | ClosedByInterruptException e) {
            try {
                this.profiler.stop();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Thread.currentThread().interrupt();
        }
    }

    String createStartCommand() {
        StringBuilder startCommand = new StringBuilder("start,jfr,clock=m,event=wall,cstack=n,interval=").append(this.config.getSamplingInterval().toMillis()).append("ms,filter,file=").append(this.jfrFile).append(",safemode=").append(this.config.getAsyncProfilerSafeMode());
        if (!this.config.isProfilingLoggingEnabled()) {
            startCommand.append(",loglevel=none");
        }
        return startCommand.toString();
    }

    private void restoreFilterState(AsyncProfiler asyncProfiler) {
        this.threadMatcher.forEachThread(new ThreadMatcher.NonCapturingPredicate<Thread, Long2ObjectHashMap.KeySet>(){

            @Override
            public boolean test(Thread thread, Long2ObjectHashMap.KeySet profiledThreads) {
                return profiledThreads.contains(thread.getId());
            }
        }, this.profiledThreads.keySet(), new ThreadMatcher.NonCapturingConsumer<Thread, AsyncProfiler>(){

            @Override
            public void accept(Thread thread, AsyncProfiler asyncProfiler) {
                asyncProfiler.addThread(thread);
            }
        }, asyncProfiler);
    }

    private void consumeActivationEventsFromRingBufferAndWriteToFile(Duration profilingDuration) throws Exception {
        this.resetActivationEventBuffer();
        long threshold = System.currentTimeMillis() + profilingDuration.toMillis();
        long initialSleep = 100000L;
        long maxSleep = 10000000L;
        long sleep = initialSleep;
        while (System.currentTimeMillis() < threshold && !Thread.currentThread().isInterrupted()) {
            assert (this.activationEventsFileChannel != null);
            if (this.activationEventsFileChannel.position() < 102000000L) {
                EventPoller.PollState poll = this.consumeActivationEventsFromRingBufferAndWriteToFile();
                if (poll == EventPoller.PollState.PROCESSING) {
                    sleep = initialSleep;
                    continue;
                }
                if (sleep < maxSleep) {
                    sleep *= 2L;
                }
                LockSupport.parkNanos(sleep);
                continue;
            }
            logger.warning("The activation events file is full. Try lowering the profiling_duration.");
            Thread.sleep(Math.max(0L, threshold - System.currentTimeMillis()));
        }
    }

    EventPoller.PollState consumeActivationEventsFromRingBufferAndWriteToFile() throws Exception {
        this.createFilesIfRequired();
        return this.poller.poll((EventPoller.Handler)this.writeActivationEventToFileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTraces() throws IOException {
        if (this.jfrParser == null) {
            this.jfrParser = new JfrParser();
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.createFilesIfRequired();
        long eof = this.startProcessingActivationEventsFile();
        if (eof == 0L && this.activationEventsBuffer.limit() == 0 && this.profiledThreads.isEmpty()) {
            logger.fine("No activation events during this period. Skip processing stack traces.");
            return;
        }
        long start = System.nanoTime();
        List<WildcardMatcher> excludedClasses = this.config.getExcludedClasses();
        List<WildcardMatcher> includedClasses = this.config.getIncludedClasses();
        if (this.config.isBackupDiagnosticFiles()) {
            this.backupDiagnosticFiles(eof);
        }
        try {
            Objects.requireNonNull(this.jfrFile);
            this.jfrParser.parse(this.jfrFile, excludedClasses, includedClasses);
            List<StackTraceEvent> stackTraceEvents = SamplingProfiler.getSortedStackTraceEvents(this.jfrParser);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Processing {0} stack traces", stackTraceEvents.size());
            }
            ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
            ActivationEvent event = new ActivationEvent();
            long inferredSpansMinDuration = this.getInferredSpansMinDurationNs();
            for (StackTraceEvent stackTrace : stackTraceEvents) {
                this.processActivationEventsUpTo(stackTrace.nanoTime, eof, event);
                CallTree.Root root = (CallTree.Root)this.profiledThreads.get(stackTrace.threadId);
                if (root != null) {
                    this.jfrParser.resolveStackTrace(stackTrace.stackTraceId, stackFrames, 256);
                    if (stackFrames.size() == 256) {
                        logger.fine("Max stack depth reached. Set profiling_included_classes or profiling_excluded_classes.");
                    }
                    if (!stackFrames.isEmpty()) {
                        try {
                            root.addStackTrace(stackFrames, stackTrace.nanoTime, this.callTreePool, inferredSpansMinDuration);
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, "Removing call tree for thread {0} because of exception while adding a stack trace: {1} {2}", new Object[]{stackTrace.threadId, e.getClass(), e.getMessage()});
                            logger.log(Level.FINE, e.getMessage(), e);
                            this.profiledThreads.remove(stackTrace.threadId);
                        }
                    }
                }
                stackFrames.clear();
            }
            this.processActivationEventsUpTo(System.nanoTime(), eof, event);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Processing traces took {0}us", (System.nanoTime() - start) / 1000L);
            }
            this.jfrParser.resetState();
            this.resetActivationEventBuffer();
        }
    }

    private void backupDiagnosticFiles(long eof) throws IOException {
        String now = String.format(Locale.ROOT, "%tFT%<tT.%<tL", new Date());
        Path profilerDir = Paths.get(System.getProperty("java.io.tmpdir"), "profiler");
        profilerDir.toFile().mkdir();
        logger.log(Level.FINE, "Backing up profiler diagnostic files to {0}", profilerDir);
        try (FileChannel activationsFile = FileChannel.open(profilerDir.resolve(now + "-activations.dat"), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            if (eof > 0L) {
                assert (this.activationEventsFileChannel != null);
                this.activationEventsFileChannel.transferTo(0L, eof, activationsFile);
            } else {
                int position = this.activationEventsBuffer.position();
                activationsFile.write(this.activationEventsBuffer);
                this.activationEventsBuffer.position(position);
            }
        }
        assert (this.jfrFile != null);
        Files.copy(this.jfrFile.toPath(), profilerDir.resolve(now + "-traces.jfr"), new CopyOption[0]);
    }

    private long getInferredSpansMinDurationNs() {
        return this.config.getInferredSpansMinDuration().toNanos();
    }

    private static List<StackTraceEvent> getSortedStackTraceEvents(JfrParser jfrParser) throws IOException {
        final ArrayList<StackTraceEvent> stackTraceEvents = new ArrayList<StackTraceEvent>();
        jfrParser.consumeStackTraces(new JfrParser.StackTraceConsumer(){

            @Override
            public void onCallTree(long threadId, long stackTraceId, long nanoTime) {
                stackTraceEvents.add(new StackTraceEvent(nanoTime, stackTraceId, threadId));
            }
        });
        Collections.sort(stackTraceEvents);
        return stackTraceEvents;
    }

    void processActivationEventsUpTo(long timestamp, long eof) throws IOException {
        this.processActivationEventsUpTo(timestamp, eof, new ActivationEvent());
    }

    private void processActivationEventsUpTo(long timestamp, long eof, ActivationEvent event) throws IOException {
        FileChannel activationEventsFileChannel = this.activationEventsFileChannel;
        assert (activationEventsFileChannel != null);
        ByteBuffer buf = this.activationEventsBuffer;
        long previousTimestamp = 0L;
        while (buf.hasRemaining() || activationEventsFileChannel.position() < eof) {
            long eventTimestamp;
            if (!buf.hasRemaining()) {
                SamplingProfiler.readActivationEventsToBuffer(activationEventsFileChannel, eof, buf);
            }
            if ((eventTimestamp = SamplingProfiler.peekLong(buf)) < previousTimestamp && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Timestamp of current activation event ({0}) is lower than the one from the previous event ({1})", new Object[]{eventTimestamp, previousTimestamp});
            }
            previousTimestamp = eventTimestamp;
            if (eventTimestamp <= timestamp) {
                event.deserialize(buf);
                try {
                    event.handle(this);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Removing call tree for thread {0} because of exception while handling activation event: {1} {2}", new Object[]{event.threadId, e.getClass(), e.getMessage()});
                    logger.log(Level.FINE, e.getMessage(), e);
                    this.profiledThreads.remove(event.threadId);
                }
                continue;
            }
            return;
        }
    }

    private static void readActivationEventsToBuffer(FileChannel activationEventsFileChannel, long eof, ByteBuffer byteBuffer) throws IOException {
        ByteBuffer buf = byteBuffer;
        ((Buffer)buf).clear();
        long remaining = eof - activationEventsFileChannel.position();
        activationEventsFileChannel.read(byteBuffer);
        ((Buffer)buf).flip();
        if (remaining < (long)buf.capacity()) {
            ((Buffer)buf).limit((int)remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long peekLong(ByteBuffer buf) {
        int pos = buf.position();
        try {
            long l = buf.getLong();
            return l;
        }
        finally {
            ((Buffer)buf).position(pos);
        }
    }

    public void resetActivationEventBuffer() throws IOException {
        ((Buffer)this.activationEventsBuffer).clear();
        if (this.activationEventsFileChannel != null && this.activationEventsFileChannel.isOpen()) {
            this.activationEventsFileChannel.position(0L);
        }
    }

    private void flushActivationEvents() throws IOException {
        if (this.activationEventsBuffer.position() > 0) {
            ((Buffer)this.activationEventsBuffer).flip();
            assert (this.activationEventsFileChannel != null);
            this.activationEventsFileChannel.write(this.activationEventsBuffer);
            ((Buffer)this.activationEventsBuffer).clear();
        }
    }

    long startProcessingActivationEventsFile() throws IOException {
        ByteBuffer activationEventsBuffer = this.activationEventsBuffer;
        assert (this.activationEventsFileChannel != null);
        if (this.activationEventsFileChannel.position() > 0L) {
            this.flushActivationEvents();
            ((Buffer)activationEventsBuffer).limit(0);
        } else {
            ((Buffer)activationEventsBuffer).flip();
        }
        long eof = this.activationEventsFileChannel.position();
        this.activationEventsFileChannel.position(0L);
        return eof;
    }

    public void copyFromFiles(Path activationEvents, Path traces) throws IOException {
        this.createFilesIfRequired();
        assert (this.activationEventsFileChannel != null);
        assert (this.jfrFile != null);
        FileChannel otherActivationsChannel = FileChannel.open(activationEvents, StandardOpenOption.READ);
        this.activationEventsFileChannel.transferFrom(otherActivationsChannel, 0L, otherActivationsChannel.size());
        this.activationEventsFileChannel.position(otherActivationsChannel.size());
        FileChannel otherTracesChannel = FileChannel.open(traces, StandardOpenOption.READ);
        FileChannel.open(this.jfrFile.toPath(), StandardOpenOption.WRITE).transferFrom(otherTracesChannel, 0L, otherTracesChannel.size());
    }

    public void start() {
        this.scheduler.submit(this);
    }

    public void stop() throws InterruptedException, IOException {
        this.scheduler.shutdown();
        this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
        this.activationListener.close();
        if (this.activationEventsFileChannel != null) {
            this.activationEventsFileChannel.close();
        }
        if (this.jfrFile != null && this.canDeleteJfrFile) {
            this.jfrFile.delete();
        }
        if (this.activationEventsFile != null && this.canDeleteActivationEventsFile) {
            this.activationEventsFile.delete();
        }
    }

    void setProfilingSessionOngoing(boolean profilingSessionOngoing) {
        this.profilingSessionOngoing = profilingSessionOngoing;
        if (!profilingSessionOngoing) {
            this.clearProfiledThreads();
        } else if (!this.profiledThreads.isEmpty() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Retaining {0} call tree roots", this.profiledThreads.size());
        }
    }

    public void clearProfiledThreads() {
        for (CallTree.Root root : this.profiledThreads.values()) {
            root.recycle(this.callTreePool, this.rootPool);
        }
        this.profiledThreads.clear();
    }

    CallTree.Root getRoot() {
        return (CallTree.Root)this.profiledThreads.get(Thread.currentThread().getId());
    }

    public int getProfilingSessions() {
        return this.profilingSessions;
    }

    public SpanAnchoredClock getClock() {
        return this.clock;
    }

    private static class ActivationEvent {
        public static final int SERIALIZED_SIZE = 102;
        private long timestamp;
        private final byte[] traceContextBuffer = new byte[42];
        private final byte[] previousContextBuffer = new byte[42];
        private boolean rootContext;
        private long threadId;
        private boolean activation;

        private ActivationEvent() {
        }

        public void activation(Span context, long threadId, @Nullable Span previousContext, long nanoTime, SpanAnchoredClock clock) {
            this.set(context, threadId, true, previousContext, nanoTime, clock);
        }

        public void deactivation(Span context, long threadId, @Nullable Span previousContext, long nanoTime, SpanAnchoredClock clock) {
            this.set(context, threadId, false, previousContext, nanoTime, clock);
        }

        private void set(Span traceContext, long threadId, boolean activation, @Nullable Span previousContext, long nanoTime, SpanAnchoredClock clock) {
            TraceContext.serialize(this.traceContextBuffer, traceContext, clock.getAnchor(traceContext));
            this.threadId = threadId;
            this.activation = activation;
            if (previousContext != null) {
                TraceContext.serialize(this.previousContextBuffer, previousContext, clock.getAnchor(previousContext));
                this.rootContext = false;
            } else {
                this.rootContext = true;
            }
            this.timestamp = nanoTime;
        }

        public void handle(SamplingProfiler samplingProfiler) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Handling event timestamp={0} root={1} threadId={2} activation={3}", new Object[]{this.timestamp, this.rootContext, this.threadId, this.activation});
            }
            if (this.activation) {
                this.handleActivationEvent(samplingProfiler);
            } else {
                this.handleDeactivationEvent(samplingProfiler);
            }
        }

        private void handleActivationEvent(SamplingProfiler samplingProfiler) {
            if (this.rootContext) {
                this.startProfiling(samplingProfiler);
            } else {
                CallTree.Root root = (CallTree.Root)samplingProfiler.profiledThreads.get(this.threadId);
                if (root != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Handling activation for thread {0}", this.threadId);
                    }
                    root.onActivation(this.traceContextBuffer, this.timestamp);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Illegal state when handling activation event for thread {0}: no root found for this thread", this.threadId);
                }
            }
        }

        private void startProfiling(SamplingProfiler samplingProfiler) {
            CallTree.Root orphaned;
            CallTree.Root root = CallTree.createRoot(samplingProfiler.rootPool, this.traceContextBuffer, this.timestamp);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Create call tree ({0}) for thread {1}", new Object[]{ActivationEvent.deserialize(samplingProfiler, this.traceContextBuffer), this.threadId});
            }
            if ((orphaned = (CallTree.Root)samplingProfiler.profiledThreads.put(this.threadId, (Object)root)) != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Illegal state when stopping profiling for thread {0}: orphaned root", this.threadId);
                }
                orphaned.recycle(samplingProfiler.callTreePool, samplingProfiler.rootPool);
            }
        }

        private void handleDeactivationEvent(SamplingProfiler samplingProfiler) {
            if (this.rootContext) {
                this.stopProfiling(samplingProfiler);
            } else {
                CallTree.Root root = (CallTree.Root)samplingProfiler.profiledThreads.get(this.threadId);
                if (root != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Handling deactivation for thread {0}", this.threadId);
                    }
                    root.onDeactivation(this.traceContextBuffer, this.previousContextBuffer, this.timestamp);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Illegal state when handling deactivation event for thread {0}: no root found for this thread", this.threadId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopProfiling(SamplingProfiler samplingProfiler) {
            CallTree.Root callTree = (CallTree.Root)samplingProfiler.profiledThreads.get(this.threadId);
            if (callTree != null && callTree.getRootContext().traceIdAndIdEquals(this.traceContextBuffer)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "End call tree ({0}) for thread {1}", new Object[]{ActivationEvent.deserialize(samplingProfiler, this.traceContextBuffer), this.threadId});
                }
                samplingProfiler.profiledThreads.remove(this.threadId);
                try {
                    callTree.end(samplingProfiler.callTreePool, samplingProfiler.getInferredSpansMinDurationNs());
                    int createdSpans = callTree.spanify(samplingProfiler.getClock(), (Tracer)samplingProfiler.tracerProvider.get());
                    if (logger.isLoggable(Level.FINE)) {
                        if (createdSpans > 0) {
                            logger.log(Level.FINE, "Created spans ({0}) for thread {1}", new Object[]{createdSpans, this.threadId});
                        } else {
                            logger.log(Level.FINE, "Created no spans for thread {0} (count={1})", new Object[]{this.threadId, callTree.getCount()});
                        }
                    }
                }
                finally {
                    callTree.recycle(samplingProfiler.callTreePool, samplingProfiler.rootPool);
                }
            }
        }

        public void serialize(ByteBuffer buf) {
            buf.putLong(this.timestamp);
            buf.put(this.traceContextBuffer);
            buf.put(this.previousContextBuffer);
            buf.put(this.rootContext ? (byte)1 : 0);
            buf.putLong(this.threadId);
            buf.put(this.activation ? (byte)1 : 0);
        }

        public void deserialize(ByteBuffer buf) {
            this.timestamp = buf.getLong();
            buf.get(this.traceContextBuffer);
            buf.get(this.previousContextBuffer);
            this.rootContext = buf.get() == 1;
            this.threadId = buf.getLong();
            this.activation = buf.get() == 1;
        }

        private static TraceContext deserialize(SamplingProfiler samplingProfiler, byte[] traceContextBuffer) {
            samplingProfiler.contextForLogging.deserialize(traceContextBuffer);
            return samplingProfiler.contextForLogging;
        }
    }

    private class WriteActivationEventToFileHandler
    implements EventPoller.Handler<ActivationEvent> {
        private WriteActivationEventToFileHandler() {
        }

        public boolean onEvent(ActivationEvent event, long sequence, boolean endOfBatch) throws IOException {
            if (endOfBatch) {
                SamplingProfiler.this.sequence.set(sequence);
            }
            assert (SamplingProfiler.this.activationEventsFileChannel != null);
            if (SamplingProfiler.this.activationEventsFileChannel.size() < 102000000L) {
                event.serialize(SamplingProfiler.this.activationEventsBuffer);
                if (!SamplingProfiler.this.activationEventsBuffer.hasRemaining()) {
                    SamplingProfiler.this.flushActivationEvents();
                }
                return true;
            }
            return false;
        }
    }

    private static class NoWaitStrategy
    implements WaitStrategy {
        private NoWaitStrategy() {
        }

        public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) {
            return dependentSequence.get();
        }

        public void signalAllWhenBlocking() {
        }
    }

    public static class StackTraceEvent
    implements Comparable<StackTraceEvent> {
        private final long nanoTime;
        private final long stackTraceId;
        private final long threadId;

        private StackTraceEvent(long nanoTime, long stackTraceId, long threadId) {
            this.nanoTime = nanoTime;
            this.stackTraceId = stackTraceId;
            this.threadId = threadId;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public long getNanoTime() {
            return this.nanoTime;
        }

        public long getStackTraceId() {
            return this.stackTraceId;
        }

        @Override
        public int compareTo(StackTraceEvent o) {
            return Long.compare(this.nanoTime, o.nanoTime);
        }
    }
}

