/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.opentelemetry.contrib.inferredspans.internal.SamplingProfiler;
import io.opentelemetry.contrib.inferredspans.internal.util.ThreadUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ProfilingActivationListener
implements Closeable {
    private static volatile List<ProfilingActivationListener> activeListeners;
    private final SamplingProfiler profiler;

    public static void ensureInitialized() {
    }

    private ProfilingActivationListener(SamplingProfiler profiler) {
        this.profiler = profiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilingActivationListener register(SamplingProfiler profiler) {
        ProfilingActivationListener result = new ProfilingActivationListener(profiler);
        Class<ProfilingActivationListener> clazz = ProfilingActivationListener.class;
        synchronized (ProfilingActivationListener.class) {
            ArrayList<ProfilingActivationListener> listenersList = new ArrayList<ProfilingActivationListener>(activeListeners);
            listenersList.add(result);
            activeListeners = Collections.unmodifiableList(listenersList);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<ProfilingActivationListener> clazz = ProfilingActivationListener.class;
        synchronized (ProfilingActivationListener.class) {
            ArrayList<ProfilingActivationListener> listenersList = new ArrayList<ProfilingActivationListener>(activeListeners);
            listenersList.remove(this);
            activeListeners = Collections.unmodifiableList(listenersList);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void beforeActivate(Span oldContext, Span newContext) {
        if (newContext.getSpanContext().isValid() && newContext.getSpanContext().isSampled() && !ThreadUtils.isVirtual(Thread.currentThread())) {
            this.profiler.onActivation(newContext, (Span)(oldContext.getSpanContext().isValid() ? oldContext : null));
        }
    }

    public void afterDeactivate(Span deactivatedContext, Span newContext) {
        if (deactivatedContext.getSpanContext().isValid() && deactivatedContext.getSpanContext().isSampled() && !ThreadUtils.isVirtual(Thread.currentThread())) {
            this.profiler.onDeactivation(deactivatedContext, (Span)(newContext.getSpanContext().isValid() ? newContext : null));
        }
    }

    static {
        ContextStorage.addWrapper(x$0 -> new ContextStorageWrapper((ContextStorage)x$0));
        activeListeners = Collections.emptyList();
    }

    private static class ContextStorageWrapper
    implements ContextStorage {
        private final ContextStorage delegate;

        private ContextStorageWrapper(ContextStorage delegate) {
            this.delegate = delegate;
        }

        public Scope attach(Context toAttach) {
            List listeners = activeListeners;
            if (listeners.isEmpty()) {
                return this.delegate.attach(toAttach);
            }
            Span attached = ContextStorageWrapper.spanFromContextNullSafe(toAttach);
            Span oldCtx = ContextStorageWrapper.spanFromContextNullSafe(this.delegate.current());
            for (ProfilingActivationListener listener : listeners) {
                listener.beforeActivate(oldCtx, attached);
            }
            Scope delegateScope = this.delegate.attach(toAttach);
            return () -> {
                delegateScope.close();
                Span newCtx = ContextStorageWrapper.spanFromContextNullSafe(this.delegate.current());
                for (ProfilingActivationListener listener : listeners) {
                    listener.afterDeactivate(attached, newCtx);
                }
            };
        }

        private static Span spanFromContextNullSafe(@Nullable Context context) {
            if (context == null) {
                return Span.getInvalid();
            }
            return Span.fromContext((Context)context);
        }

        @Nullable
        public Context current() {
            return this.delegate.current();
        }

        public Context root() {
            return this.delegate.root();
        }
    }
}

