/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.gcp.auth;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;

enum ConfigurableOption {
    GOOGLE_CLOUD_PROJECT("Google Cloud Project ID"),
    GOOGLE_CLOUD_QUOTA_PROJECT("Google Cloud Quota Project ID"),
    GOOGLE_OTEL_AUTH_TARGET_SIGNALS("Target Signals for Google Authentication Extension");

    private final String userReadableName;
    private final String environmentVariableName;
    private final String systemPropertyName;

    private ConfigurableOption(String userReadableName) {
        this.userReadableName = userReadableName;
        this.environmentVariableName = this.name();
        this.systemPropertyName = this.environmentVariableName.toLowerCase(Locale.ROOT).replace('_', '.');
    }

    String getEnvironmentVariable() {
        return this.environmentVariableName;
    }

    String getSystemProperty() {
        return this.systemPropertyName;
    }

    String getUserReadableName() {
        return this.userReadableName;
    }

    String getConfiguredValue(ConfigProperties configProperties) {
        String configuredValue = configProperties.getString(this.getSystemProperty());
        if (configuredValue != null && !configuredValue.isEmpty()) {
            return configuredValue;
        }
        throw new ConfigurationException(String.format("GCP Authentication Extension not configured properly: %s not configured. Configure it by exporting environment variable %s or system property %s", this.userReadableName, this.getEnvironmentVariable(), this.getSystemProperty()));
    }

    String getConfiguredValueWithFallback(ConfigProperties configProperties, Supplier<String> fallback) {
        try {
            return this.getConfiguredValue(configProperties);
        }
        catch (ConfigurationException e) {
            return fallback.get();
        }
    }

    Optional<String> getConfiguredValueAsOptional(ConfigProperties configProperties) {
        try {
            return Optional.of(this.getConfiguredValue(configProperties));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }
}

