/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.gcp.auth;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.gcp.auth.ConfigurableOption;
import io.opentelemetry.contrib.gcp.auth.GoogleAuthException;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@AutoService(value={AutoConfigurationCustomizerProvider.class})
public class GcpAuthAutoConfigurationCustomizerProvider
implements AutoConfigurationCustomizerProvider {
    private static final Logger logger = Logger.getLogger(GcpAuthAutoConfigurationCustomizerProvider.class.getName());
    private static final String SIGNAL_TARGET_WARNING_FIX_SUGGESTION = String.format("You may safely ignore this warning if it is intentional, otherwise please configure the '%s' by exporting valid values to environment variable: %s or by setting valid values in system property: %s.", ConfigurableOption.GOOGLE_OTEL_AUTH_TARGET_SIGNALS.getUserReadableName(), ConfigurableOption.GOOGLE_OTEL_AUTH_TARGET_SIGNALS.getEnvironmentVariable(), ConfigurableOption.GOOGLE_OTEL_AUTH_TARGET_SIGNALS.getSystemProperty());
    static final String QUOTA_USER_PROJECT_HEADER = "x-goog-user-project";
    static final String GCP_USER_PROJECT_ID_KEY = "gcp.project_id";
    static final String SIGNAL_TYPE_TRACES = "traces";
    static final String SIGNAL_TYPE_METRICS = "metrics";
    static final String SIGNAL_TYPE_ALL = "all";

    public void customize(@Nonnull AutoConfigurationCustomizer autoConfiguration) {
        GoogleCredentials credentials;
        try {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new GoogleAuthException(GoogleAuthException.Reason.FAILED_ADC_RETRIEVAL, (Throwable)e);
        }
        autoConfiguration.addSpanExporterCustomizer((spanExporter, configProperties) -> GcpAuthAutoConfigurationCustomizerProvider.customizeSpanExporter(spanExporter, credentials, configProperties)).addMetricExporterCustomizer((metricExporter, configProperties) -> GcpAuthAutoConfigurationCustomizerProvider.customizeMetricExporter(metricExporter, credentials, configProperties)).addResourceCustomizer(GcpAuthAutoConfigurationCustomizerProvider::customizeResource);
    }

    public int order() {
        return 0x7FFFFFFE;
    }

    private static SpanExporter customizeSpanExporter(SpanExporter exporter, GoogleCredentials credentials, ConfigProperties configProperties) {
        if (GcpAuthAutoConfigurationCustomizerProvider.isSignalTargeted(SIGNAL_TYPE_TRACES, configProperties)) {
            return GcpAuthAutoConfigurationCustomizerProvider.addAuthorizationHeaders(exporter, credentials, configProperties);
        }
        Object[] params = new String[]{SIGNAL_TYPE_TRACES, SIGNAL_TARGET_WARNING_FIX_SUGGESTION};
        logger.log(Level.WARNING, "GCP Authentication Extension is not configured for signal type: {0}. {1}", params);
        return exporter;
    }

    private static MetricExporter customizeMetricExporter(MetricExporter exporter, GoogleCredentials credentials, ConfigProperties configProperties) {
        if (GcpAuthAutoConfigurationCustomizerProvider.isSignalTargeted(SIGNAL_TYPE_METRICS, configProperties)) {
            return GcpAuthAutoConfigurationCustomizerProvider.addAuthorizationHeaders(exporter, credentials, configProperties);
        }
        Object[] params = new String[]{SIGNAL_TYPE_METRICS, SIGNAL_TARGET_WARNING_FIX_SUGGESTION};
        logger.log(Level.WARNING, "GCP Authentication Extension is not configured for signal type: {0}. {1}", params);
        return exporter;
    }

    private static boolean isSignalTargeted(String checkSignal, ConfigProperties configProperties) {
        String userSpecifiedTargetedSignals = ConfigurableOption.GOOGLE_OTEL_AUTH_TARGET_SIGNALS.getConfiguredValueWithFallback(configProperties, () -> SIGNAL_TYPE_ALL);
        return Arrays.stream(userSpecifiedTargetedSignals.split(",")).map(String::trim).anyMatch(targetedSignal -> targetedSignal.equals(checkSignal) || targetedSignal.equals(SIGNAL_TYPE_ALL));
    }

    private static SpanExporter addAuthorizationHeaders(SpanExporter exporter, GoogleCredentials credentials, ConfigProperties configProperties) {
        if (exporter instanceof OtlpHttpSpanExporter) {
            OtlpHttpSpanExporterBuilder builder = ((OtlpHttpSpanExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials, configProperties));
            return builder.build();
        }
        if (exporter instanceof OtlpGrpcSpanExporter) {
            OtlpGrpcSpanExporterBuilder builder = ((OtlpGrpcSpanExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials, configProperties));
            return builder.build();
        }
        return exporter;
    }

    private static MetricExporter addAuthorizationHeaders(MetricExporter exporter, GoogleCredentials credentials, ConfigProperties configProperties) {
        if (exporter instanceof OtlpHttpMetricExporter) {
            OtlpHttpMetricExporterBuilder builder = ((OtlpHttpMetricExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials, configProperties));
            return builder.build();
        }
        if (exporter instanceof OtlpGrpcMetricExporter) {
            OtlpGrpcMetricExporterBuilder builder = ((OtlpGrpcMetricExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials, configProperties));
            return builder.build();
        }
        return exporter;
    }

    private static Map<String, String> getRequiredHeaderMap(GoogleCredentials credentials, ConfigProperties configProperties) {
        Map gcpHeaders;
        try {
            gcpHeaders = credentials.getRequestMetadata();
        }
        catch (IOException e) {
            throw new GoogleAuthException(GoogleAuthException.Reason.FAILED_ADC_REFRESH, (Throwable)e);
        }
        Map<String, String> flattenedHeaders = gcpHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining(","))));
        if (!flattenedHeaders.containsKey(QUOTA_USER_PROJECT_HEADER)) {
            Optional<String> maybeConfiguredQuotaProjectId = ConfigurableOption.GOOGLE_CLOUD_QUOTA_PROJECT.getConfiguredValueAsOptional(configProperties);
            maybeConfiguredQuotaProjectId.ifPresent(configuredQuotaProjectId -> flattenedHeaders.put(QUOTA_USER_PROJECT_HEADER, (String)configuredQuotaProjectId));
        }
        return flattenedHeaders;
    }

    private static Resource customizeResource(Resource resource, ConfigProperties configProperties) {
        String gcpProjectId = ConfigurableOption.GOOGLE_CLOUD_PROJECT.getConfiguredValue(configProperties);
        Resource res = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)GCP_USER_PROJECT_ID_KEY), (Object)gcpProjectId));
        return resource.merge(res);
    }
}

