/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.gcp.auth;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.gcp.auth.ConfigurableOption;
import io.opentelemetry.contrib.gcp.auth.GoogleAuthException;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@AutoService(value={AutoConfigurationCustomizerProvider.class})
public class GcpAuthAutoConfigurationCustomizerProvider
implements AutoConfigurationCustomizerProvider {
    static final String QUOTA_USER_PROJECT_HEADER = "X-Goog-User-Project";
    static final String GCP_USER_PROJECT_ID_KEY = "gcp.project_id";

    public void customize(AutoConfigurationCustomizer autoConfiguration) {
        GoogleCredentials credentials;
        try {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new GoogleAuthException(GoogleAuthException.Reason.FAILED_ADC_RETRIEVAL, (Throwable)e);
        }
        autoConfiguration.addSpanExporterCustomizer((exporter, configProperties) -> GcpAuthAutoConfigurationCustomizerProvider.addAuthorizationHeaders(exporter, credentials)).addResourceCustomizer(GcpAuthAutoConfigurationCustomizerProvider::customizeResource);
    }

    public int order() {
        return 0x7FFFFFFE;
    }

    private static SpanExporter addAuthorizationHeaders(SpanExporter exporter, GoogleCredentials credentials) {
        if (exporter instanceof OtlpHttpSpanExporter) {
            OtlpHttpSpanExporterBuilder builder = ((OtlpHttpSpanExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials));
            return builder.build();
        }
        if (exporter instanceof OtlpGrpcSpanExporter) {
            OtlpGrpcSpanExporterBuilder builder = ((OtlpGrpcSpanExporter)exporter).toBuilder().setHeaders(() -> GcpAuthAutoConfigurationCustomizerProvider.getRequiredHeaderMap(credentials));
            return builder.build();
        }
        return exporter;
    }

    private static Map<String, String> getRequiredHeaderMap(GoogleCredentials credentials) {
        HashMap<String, String> gcpHeaders = new HashMap<String, String>();
        try {
            credentials.refreshIfExpired();
        }
        catch (IOException e) {
            throw new GoogleAuthException(GoogleAuthException.Reason.FAILED_ADC_REFRESH, (Throwable)e);
        }
        gcpHeaders.put("Authorization", "Bearer " + credentials.getAccessToken().getTokenValue());
        String configuredQuotaProjectId = ConfigurableOption.GOOGLE_CLOUD_QUOTA_PROJECT.getConfiguredValueWithFallback(() -> ((GoogleCredentials)credentials).getQuotaProjectId());
        if (configuredQuotaProjectId != null && !configuredQuotaProjectId.isEmpty()) {
            gcpHeaders.put(QUOTA_USER_PROJECT_HEADER, configuredQuotaProjectId);
        }
        return gcpHeaders;
    }

    private static Resource customizeResource(Resource resource, ConfigProperties configProperties) {
        String gcpProjectId = ConfigurableOption.GOOGLE_CLOUD_PROJECT.getConfiguredValue();
        Resource res = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)GCP_USER_PROJECT_ID_KEY), (Object)gcpProjectId));
        return resource.merge(res);
    }
}

