/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.storage.StorageIterator;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.contrib.disk.buffering.storage.result.WriteResult;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class FileSignalStorage<T>
implements SignalStorage<T> {
    private final Storage<T> storage;
    private final SignalSerializer<T> serializer;
    private final SignalDeserializer<T> deserializer;
    private final Logger logger = Logger.getLogger(FileSignalStorage.class.getName());
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Object iteratorLock = new Object();
    @Nullable
    @GuardedBy(value="iteratorLock")
    private Iterator<Collection<T>> iterator;

    public FileSignalStorage(Storage<T> storage, SignalSerializer<T> serializer, SignalDeserializer<T> deserializer) {
        this.storage = storage;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<WriteResult> write(Collection<T> items) {
        this.logger.finer("Intercepting batch.");
        try {
            this.serializer.initialize(items);
            if (this.storage.write(this.serializer)) {
                CompletableFuture<WriteResult> completableFuture = CompletableFuture.completedFuture(WriteResult.successful());
                return completableFuture;
            }
            this.logger.fine("Could not store batch in disk.");
            CompletableFuture<WriteResult> completableFuture = CompletableFuture.completedFuture(WriteResult.error(new Exception("Could not store batch in disk for an unknown reason.")));
            return completableFuture;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "An unexpected error happened while attempting to write the data in disk.", e);
            CompletableFuture<WriteResult> completableFuture = CompletableFuture.completedFuture(WriteResult.error(e));
            return completableFuture;
        }
        finally {
            this.serializer.reset();
        }
    }

    @Override
    public CompletableFuture<WriteResult> clear() {
        try {
            this.storage.clear();
            return CompletableFuture.completedFuture(WriteResult.successful());
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(WriteResult.error(e));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.storage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Iterator<Collection<T>> iterator() {
        Object object = this.iteratorLock;
        synchronized (object) {
            if (this.iterator == null) {
                this.iterator = new StorageIterator<T>(this.storage, this.deserializer);
            }
            return this.iterator;
        }
    }
}

