/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.BaseProtoSignalsDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs.LogRecordDataMapper;
import io.opentelemetry.diskbuffering.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.diskbuffering.proto.logs.v1.LogRecord;
import io.opentelemetry.diskbuffering.proto.logs.v1.ResourceLogs;
import io.opentelemetry.diskbuffering.proto.logs.v1.ScopeLogs;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ProtoLogsDataMapper
extends BaseProtoSignalsDataMapper<LogRecordData, LogRecord, ExportLogsServiceRequest, ResourceLogs, ScopeLogs> {
    private static final ProtoLogsDataMapper INSTANCE = new ProtoLogsDataMapper();

    public static ProtoLogsDataMapper getInstance() {
        return INSTANCE;
    }

    @Override
    protected LogRecord signalItemToProto(LogRecordData sourceData) {
        return LogRecordDataMapper.getInstance().mapToProto(sourceData);
    }

    @Override
    protected LogRecordData protoToSignalItem(LogRecord logRecord, Resource resource, InstrumentationScopeInfo scopeInfo) {
        return LogRecordDataMapper.getInstance().mapToSdk(logRecord, resource, scopeInfo);
    }

    @Override
    protected List<ResourceLogs> getProtoResources(ExportLogsServiceRequest logsData) {
        return logsData.resource_logs;
    }

    @Override
    protected ExportLogsServiceRequest createProtoData(Map<Resource, Map<InstrumentationScopeInfo, List<LogRecord>>> itemsByResource) {
        ArrayList<ResourceLogs> items = new ArrayList<ResourceLogs>();
        itemsByResource.forEach((resource, instrumentationScopeInfoScopedLogsMap) -> {
            ResourceLogs.Builder resourceLogsBuilder = this.createProtoResourceBuilder((Resource)resource);
            for (Map.Entry logsByScope : instrumentationScopeInfoScopedLogsMap.entrySet()) {
                ScopeLogs.Builder scopeBuilder = this.createProtoScopeBuilder((InstrumentationScopeInfo)logsByScope.getKey());
                scopeBuilder.log_records.addAll((Collection)logsByScope.getValue());
                resourceLogsBuilder.scope_logs.add(scopeBuilder.build());
            }
            items.add(resourceLogsBuilder.build());
        });
        return new ExportLogsServiceRequest.Builder().resource_logs(items).build();
    }

    private ScopeLogs.Builder createProtoScopeBuilder(InstrumentationScopeInfo scopeInfo) {
        ScopeLogs.Builder builder = new ScopeLogs.Builder().scope(this.instrumentationScopeToProto(scopeInfo));
        if (scopeInfo.getSchemaUrl() != null) {
            builder.schema_url(scopeInfo.getSchemaUrl());
        }
        return builder;
    }

    private ResourceLogs.Builder createProtoResourceBuilder(Resource resource) {
        ResourceLogs.Builder builder = new ResourceLogs.Builder().resource(this.resourceToProto(resource));
        if (resource.getSchemaUrl() != null) {
            builder.schema_url(resource.getSchemaUrl());
        }
        return builder;
    }

    @Override
    protected List<LogRecord> getSignalsFromProto(ScopeLogs scopeSignals) {
        return scopeSignals.log_records;
    }

    @Override
    protected InstrumentationScopeInfo getInstrumentationScopeFromProto(ScopeLogs scopeSignals) {
        return this.protoToInstrumentationScopeInfo(scopeSignals.scope, scopeSignals.schema_url);
    }

    @Override
    protected List<ScopeLogs> getScopes(ResourceLogs resourceSignal) {
        return resourceSignal.scope_logs;
    }

    @Override
    protected Resource getResourceFromProto(ResourceLogs resourceSignal) {
        return this.protoToResource(resourceSignal.resource, resourceSignal.schema_url);
    }

    @Override
    protected Resource getResourceFromSignal(LogRecordData source) {
        return source.getResource();
    }

    @Override
    protected InstrumentationScopeInfo getInstrumentationScopeInfo(LogRecordData source) {
        return source.getInstrumentationScopeInfo();
    }
}

