/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.exporters;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.ExporterCallback;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.NoopExporterCallback;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.SignalStorageExporter;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.time.Duration;
import java.util.Collection;

public final class MetricToDiskExporter
implements MetricExporter {
    private final SignalStorageExporter<MetricData> storageExporter;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final ExporterCallback<MetricData> callback;
    private static final ExporterCallback<MetricData> DEFAULT_CALLBACK = new NoopExporterCallback<MetricData>();
    private static final Duration DEFAULT_EXPORT_TIMEOUT = Duration.ofSeconds(10L);

    private MetricToDiskExporter(SignalStorageExporter<MetricData> storageExporter, AggregationTemporalitySelector aggregationTemporalitySelector, ExporterCallback<MetricData> callback) {
        this.storageExporter = storageExporter;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.callback = callback;
    }

    public static Builder builder(SignalStorage.Metric storage) {
        return new Builder(storage);
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.storageExporter.exportToStorage(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.callback.onShutdown();
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    static /* synthetic */ ExporterCallback access$100() {
        return DEFAULT_CALLBACK;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_EXPORT_TIMEOUT;
    }

    public static final class Builder {
        private final SignalStorage.Metric storage;
        private AggregationTemporalitySelector aggregationTemporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
        private ExporterCallback<MetricData> callback = MetricToDiskExporter.access$100();
        private Duration writeTimeout = MetricToDiskExporter.access$200();

        @CanIgnoreReturnValue
        public Builder setExporterCallback(ExporterCallback<MetricData> value) {
            this.callback = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriteTimeout(Duration value) {
            this.writeTimeout = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAggregationTemporalitySelector(AggregationTemporalitySelector value) {
            this.aggregationTemporalitySelector = value;
            return this;
        }

        public MetricToDiskExporter build() {
            SignalStorageExporter<MetricData> storageExporter = new SignalStorageExporter<MetricData>(this.storage, this.callback, this.writeTimeout);
            return new MetricToDiskExporter(storageExporter, this.aggregationTemporalitySelector, this.callback);
        }

        private Builder(SignalStorage.Metric storage) {
            this.storage = storage;
        }
    }
}

