/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public final class SpanDataSerializer
implements SignalSerializer<SpanData> {
    private final LowAllocationTraceRequestMarshaler marshaler = new LowAllocationTraceRequestMarshaler();

    SpanDataSerializer() {
    }

    @CanIgnoreReturnValue
    public SpanDataSerializer initialize(Collection<SpanData> data) {
        this.marshaler.initialize(data);
        return this;
    }

    @Override
    public void writeBinaryTo(OutputStream output) throws IOException {
        ProtobufTools.writeRawVarint32(this.marshaler.getBinarySerializedSize(), output);
        this.marshaler.writeBinaryTo(output);
    }

    @Override
    public int getBinarySerializedSize() {
        return this.marshaler.getBinarySerializedSize();
    }

    @Override
    public void reset() {
        this.marshaler.reset();
    }
}

