/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.exporter;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporterBuilder;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.DeserializationException;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.ProcessResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.contrib.disk.buffering.internal.utils.DebugLogger;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;

public final class FromDiskExporterImpl<EXPORT_DATA>
implements FromDiskExporter {
    private final DebugLogger logger;
    private final Storage storage;
    private final SignalDeserializer<EXPORT_DATA> deserializer;
    private final Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction;

    FromDiskExporterImpl(SignalDeserializer<EXPORT_DATA> deserializer, Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction, Storage storage) {
        this.deserializer = deserializer;
        this.exportFunction = exportFunction;
        this.storage = storage;
        this.logger = DebugLogger.wrap(Logger.getLogger(FromDiskExporterImpl.class.getName()), storage.isDebugEnabled());
    }

    public static <T> FromDiskExporterBuilder<T> builder(Storage storage) {
        return new FromDiskExporterBuilder(storage);
    }

    @Override
    public boolean exportStoredBatch(long timeout, TimeUnit unit) throws IOException {
        this.logger.log("Attempting to export " + this.deserializer.signalType() + " batch from disk.");
        ReadableResult result = this.storage.readAndProcess(bytes -> {
            this.logger.log("Read " + ((byte[])bytes).length + " " + this.deserializer.signalType() + " bytes from storage.");
            try {
                List<EXPORT_DATA> telemetry = this.deserializer.deserialize((byte[])bytes);
                this.logger.log("Now exporting batch of " + telemetry.size() + " " + this.deserializer.signalType());
                CompletableResultCode join = this.exportFunction.apply(telemetry).join(timeout, unit);
                return join.isSuccess() ? ProcessResult.SUCCEEDED : ProcessResult.TRY_LATER;
            }
            catch (DeserializationException e) {
                return ProcessResult.CONTENT_INVALID;
            }
        });
        return result == ReadableResult.SUCCEEDED;
    }

    @Override
    public void shutdown() throws IOException {
        this.storage.close();
    }
}

