/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.exporters;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.SignalType;
import io.opentelemetry.contrib.disk.buffering.exporters.ExporterCallback;
import io.opentelemetry.contrib.disk.buffering.exporters.SignalStorageExporter;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Collection;

public final class SpanToDiskExporter
implements SpanExporter {
    private static final SignalType TYPE = SignalType.SPAN;
    private final SignalStorageExporter<SpanData> storageExporter;
    private final ExporterCallback callback;

    private SpanToDiskExporter(SignalStorageExporter<SpanData> storageExporter, ExporterCallback callback) {
        this.storageExporter = storageExporter;
        this.callback = callback;
    }

    public static Builder builder(SignalStorage.Span storage) {
        return new Builder(storage);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.storageExporter.exportToStorage(spans);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.callback.onShutdown(TYPE);
        return CompletableResultCode.ofSuccess();
    }

    public static final class Builder {
        private final SignalStorage.Span storage;
        private ExporterCallback callback = ExporterCallback.noop();
        private Duration writeTimeout = Duration.ofSeconds(10L);

        private Builder(SignalStorage.Span storage) {
            this.storage = storage;
        }

        @CanIgnoreReturnValue
        public Builder setExporterCallback(ExporterCallback value) {
            this.callback = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriteTimeout(Duration value) {
            this.writeTimeout = value;
            return this;
        }

        public SpanToDiskExporter build() {
            SignalStorageExporter<SpanData> storageExporter = new SignalStorageExporter<SpanData>(this.storage, this.callback, this.writeTimeout, TYPE);
            return new SpanToDiskExporter(storageExporter, this.callback);
        }
    }
}

