/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;

public final class MetricToDiskExporter
implements MetricExporter {
    private final ToDiskExporter<MetricData> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;

    public static MetricToDiskExporter create(MetricExporter delegate, Storage storage) {
        ToDiskExporter<MetricData> toDisk = ToDiskExporter.builder(storage).setSerializer(SignalSerializer.ofMetrics()).setExportFunction(arg_0 -> ((MetricExporter)delegate).export(arg_0)).build();
        return new MetricToDiskExporter(toDisk, (AggregationTemporalitySelector)delegate);
    }

    MetricToDiskExporter(ToDiskExporter<MetricData> delegate, AggregationTemporalitySelector selector) {
        this.delegate = delegate;
        this.aggregationTemporalitySelector = selector;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.delegate.export(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.delegate.shutdown();
        }
        catch (IOException e) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }
}

