/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.exporters;

import io.opentelemetry.contrib.disk.buffering.SignalType;
import io.opentelemetry.contrib.disk.buffering.exporters.ExporterCallback;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.contrib.disk.buffering.storage.result.WriteResult;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class SignalStorageExporter<T> {
    private final SignalStorage<T> storage;
    private final ExporterCallback callback;
    private final Duration writeTimeout;
    private final SignalType type;

    public SignalStorageExporter(SignalStorage<T> storage, ExporterCallback callback, Duration writeTimeout, SignalType type) {
        this.storage = storage;
        this.callback = callback;
        this.writeTimeout = writeTimeout;
        this.type = type;
    }

    public CompletableResultCode exportToStorage(Collection<T> items) {
        CompletableFuture<WriteResult> future = this.storage.write(items);
        try {
            WriteResult operation = future.get(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (operation.isSuccessful()) {
                this.callback.onExportSuccess(this.type);
                return CompletableResultCode.ofSuccess();
            }
            Throwable error = operation.getError();
            this.callback.onExportError(this.type, error);
            if (error != null) {
                return CompletableResultCode.ofExceptionalFailure((Throwable)error);
            }
            return CompletableResultCode.ofFailure();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.callback.onExportError(this.type, e);
            return CompletableResultCode.ofExceptionalFailure((Throwable)e);
        }
    }
}

