/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.contrib.disk.buffering.config.AutoValue_StorageConfiguration;
import java.io.File;
import java.util.concurrent.TimeUnit;

@AutoValue
public abstract class StorageConfiguration {
    public abstract File getRootDir();

    public abstract boolean isDebugEnabled();

    public abstract long getMaxFileAgeForWriteMillis();

    public abstract long getMinFileAgeForReadMillis();

    public abstract long getMaxFileAgeForReadMillis();

    public abstract int getMaxFileSize();

    public abstract int getMaxFolderSize();

    public static StorageConfiguration getDefault(File rootDir) {
        return StorageConfiguration.builder().setRootDir(rootDir).build();
    }

    public static Builder builder() {
        return new AutoValue_StorageConfiguration.Builder().setMaxFileSize(0x100000).setMaxFolderSize(0xA00000).setMaxFileAgeForWriteMillis(TimeUnit.SECONDS.toMillis(30L)).setMinFileAgeForReadMillis(TimeUnit.SECONDS.toMillis(33L)).setMaxFileAgeForReadMillis(TimeUnit.HOURS.toMillis(18L)).setDebugEnabled(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMaxFileAgeForWriteMillis(long var1);

        public abstract Builder setMinFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileSize(int var1);

        public abstract Builder setMaxFolderSize(int var1);

        public abstract Builder setRootDir(File var1);

        public abstract Builder setDebugEnabled(boolean var1);

        public abstract StorageConfiguration build();
    }
}

