/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans.ProtoSpansDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.diskbuffering.proto.trace.v1.TracesData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;

public final class SpanDataSerializer
implements SignalSerializer<SpanData> {
    private static final SpanDataSerializer INSTANCE = new SpanDataSerializer();

    private SpanDataSerializer() {
    }

    static SpanDataSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Collection<SpanData> spanData) {
        byte[] byArray;
        TracesData proto = (TracesData)((Object)ProtoSpansDataMapper.getInstance().toProto(spanData));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int size = TracesData.ADAPTER.encodedSize((Object)proto);
            ProtobufTools.writeRawVarint32(size, out);
            proto.encode(out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return byArray;
    }
}

