/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.SignalTypes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.Collection;

public class SpanToDiskExporter
implements SpanExporter {
    private final ToDiskExporter<SpanData> delegate;

    public static SpanToDiskExporter create(SpanExporter delegate, StorageConfiguration config) throws IOException {
        ToDiskExporter<SpanData> toDisk = ToDiskExporter.builder().setFolderName(SignalTypes.spans.name()).setStorageConfiguration(config).setSerializer(SignalSerializer.ofSpans()).setExportFunction(arg_0 -> ((SpanExporter)delegate).export(arg_0)).build();
        return new SpanToDiskExporter(toDisk);
    }

    SpanToDiskExporter(ToDiskExporter<SpanData> delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.delegate.export(spans);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.delegate.shutdown();
        }
        catch (IOException e) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }
}

