/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporterImpl;
import io.opentelemetry.contrib.disk.buffering.internal.storage.FolderManager;
import io.opentelemetry.contrib.disk.buffering.internal.storage.StorageBuilder;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.ReadableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.WritableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.WritableResult;
import io.opentelemetry.contrib.disk.buffering.internal.utils.DebugLogger;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Storage
implements Closeable {
    private static final int MAX_ATTEMPTS = 3;
    private final DebugLogger logger;
    private final FolderManager folderManager;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    @Nullable
    private WritableFile writableFile;
    @Nullable
    private ReadableFile readableFile;

    public Storage(FolderManager folderManager, boolean debugEnabled) {
        this.folderManager = folderManager;
        this.logger = DebugLogger.wrap(Logger.getLogger(FromDiskExporterImpl.class.getName()), debugEnabled);
    }

    public static StorageBuilder builder() {
        return new StorageBuilder();
    }

    public boolean write(byte[] item) throws IOException {
        return this.write(item, 1);
    }

    private boolean write(byte[] item, int attemptNumber) throws IOException {
        WritableResult result;
        if (this.isClosed.get()) {
            this.logger.log("Refusing to write to storage after being closed.");
            return false;
        }
        if (attemptNumber > 3) {
            this.logger.log("Max number of attempts to write buffered data exceeded.", Level.WARNING);
            return false;
        }
        if (this.writableFile == null) {
            this.writableFile = this.folderManager.createWritableFile();
            this.logger.log("Created new writableFile: " + this.writableFile);
        }
        if ((result = this.writableFile.append(item)) != WritableResult.SUCCEEDED) {
            this.writableFile = null;
            return this.write(item, ++attemptNumber);
        }
        return true;
    }

    public ReadableResult readAndProcess(Function<byte[], Boolean> processing) throws IOException {
        return this.readAndProcess(processing, 1);
    }

    private ReadableResult readAndProcess(Function<byte[], Boolean> processing, int attemptNumber) throws IOException {
        if (this.isClosed.get()) {
            this.logger.log("Refusing to read from storage after being closed.");
            return ReadableResult.FAILED;
        }
        if (attemptNumber > 3) {
            this.logger.log("Maximum number of attempts to read and process buffered data exceeded.", Level.WARNING);
            return ReadableResult.FAILED;
        }
        if (this.readableFile == null) {
            this.logger.log("Obtaining a new readableFile from the folderManager.");
            this.readableFile = this.folderManager.getReadableFile();
            if (this.readableFile == null) {
                this.logger.log("Unable to get or create readable file.");
                return ReadableResult.FAILED;
            }
        }
        this.logger.log("Attempting to read data from " + this.readableFile);
        ReadableResult result = this.readableFile.readAndProcess(processing);
        switch (result) {
            case SUCCEEDED: 
            case PROCESSING_FAILED: {
                return result;
            }
        }
        this.readableFile = null;
        return this.readAndProcess(processing, ++attemptNumber);
    }

    @Override
    public void close() throws IOException {
        this.logger.log("Closing disk buffering storage.");
        if (this.isClosed.compareAndSet(false, true)) {
            if (this.writableFile != null) {
                this.writableFile.close();
            }
            if (this.readableFile != null) {
                this.readableFile.close();
            }
        }
    }
}

