/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.utils;

import com.squareup.wire.ProtoAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtobufTools {
    private ProtobufTools() {
    }

    public static void writeRawVarint32(int value, OutputStream out) throws IOException {
        ProtoAdapter.INT32.encode(out, (Object)value);
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int b;
        int offset;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.read();
            if (b == -1) {
                throw new IllegalStateException();
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = input.read();
            if (b == -1) {
                throw new IllegalStateException();
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw new IllegalStateException();
    }

    public static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }
}

