/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import com.google.auto.value.AutoValue;
import io.opentelemetry.contrib.disk.buffering.AutoValue_StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.files.DefaultTemporaryFileProvider;
import io.opentelemetry.contrib.disk.buffering.internal.files.TemporaryFileProvider;
import java.io.File;
import java.util.concurrent.TimeUnit;

@AutoValue
public abstract class StorageConfiguration {
    public abstract File getRootDir();

    public abstract long getMaxFileAgeForWriteMillis();

    public abstract long getMinFileAgeForReadMillis();

    public abstract long getMaxFileAgeForReadMillis();

    public abstract int getMaxFileSize();

    public abstract int getMaxFolderSize();

    public abstract TemporaryFileProvider getTemporaryFileProvider();

    public static StorageConfiguration getDefault(File rootDir) {
        return StorageConfiguration.builder().setRootDir(rootDir).build();
    }

    public static Builder builder() {
        TemporaryFileProvider fileProvider = DefaultTemporaryFileProvider.getInstance();
        return new AutoValue_StorageConfiguration.Builder().setMaxFileSize(0x100000).setMaxFolderSize(0xA00000).setMaxFileAgeForWriteMillis(TimeUnit.SECONDS.toMillis(30L)).setMinFileAgeForReadMillis(TimeUnit.SECONDS.toMillis(33L)).setMaxFileAgeForReadMillis(TimeUnit.HOURS.toMillis(18L)).setTemporaryFileProvider(fileProvider);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMaxFileAgeForWriteMillis(long var1);

        public abstract Builder setMinFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileSize(int var1);

        public abstract Builder setMaxFolderSize(int var1);

        public abstract Builder setTemporaryFileProvider(TemporaryFileProvider var1);

        public abstract Builder setRootDir(File var1);

        public abstract StorageConfiguration build();
    }
}

