/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files;

import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.FileOperations;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.WritableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.util.ClockBuddy;
import io.opentelemetry.sdk.common.Clock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public final class WritableFile
implements FileOperations {
    private final File file;
    private final StorageConfiguration configuration;
    private final Clock clock;
    private final long expireTimeMillis;
    private final OutputStream out;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private int size;

    public WritableFile(File file, long createdTimeMillis, StorageConfiguration configuration, Clock clock) throws IOException {
        this.file = file;
        this.configuration = configuration;
        this.clock = clock;
        this.expireTimeMillis = createdTimeMillis + configuration.getMaxFileAgeForWriteMillis();
        this.size = (int)file.length();
        this.out = new FileOutputStream(file);
    }

    public synchronized WritableResult append(byte[] data) throws IOException {
        if (this.isClosed.get()) {
            return WritableResult.FAILED;
        }
        if (this.hasExpired()) {
            this.close();
            return WritableResult.FAILED;
        }
        int futureSize = this.size + data.length;
        if (futureSize > this.configuration.getMaxFileSize()) {
            this.close();
            return WritableResult.FAILED;
        }
        this.out.write(data);
        this.size = futureSize;
        return WritableResult.SUCCEEDED;
    }

    @Override
    public synchronized long getSize() {
        return this.size;
    }

    @Override
    public synchronized boolean hasExpired() {
        return ClockBuddy.nowMillis(this.clock) >= this.expireTimeMillis;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.out.close();
        }
    }
}

