/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs.ProtoLogsDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.proto.logs.v1.LogsData;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public final class LogRecordDataSerializer
implements SignalSerializer<LogRecordData> {
    private static final LogRecordDataSerializer INSTANCE = new LogRecordDataSerializer();

    private LogRecordDataSerializer() {
    }

    static LogRecordDataSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Collection<LogRecordData> logRecordData) {
        byte[] byArray;
        LogsData proto = (LogsData)((Object)ProtoLogsDataMapper.getInstance().toProto(logRecordData));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int size = LogsData.ADAPTER.encodedSize((Object)proto);
            ProtobufTools.writeRawVarint32(size, out);
            proto.encode(out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public List<LogRecordData> deserialize(byte[] source) {
        try {
            return ProtoLogsDataMapper.getInstance().fromProto((LogsData)((Object)LogsData.ADAPTER.decode(source)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

