/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StoredBatchExporter;
import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.DiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class SpanDiskExporter
implements SpanExporter,
StoredBatchExporter {
    private final SpanExporter wrapped;
    private final DiskExporter<SpanData> diskExporter;

    public static SpanDiskExporter create(SpanExporter wrapped, File rootDir, StorageConfiguration configuration) throws IOException {
        return SpanDiskExporter.create(wrapped, rootDir, configuration, Clock.getDefault());
    }

    public static SpanDiskExporter create(SpanExporter wrapped, File rootDir, StorageConfiguration configuration, Clock clock) throws IOException {
        DiskExporter<SpanData> diskExporter = DiskExporter.builder().setRootDir(rootDir).setFolderName("spans").setStorageConfiguration(configuration).setSerializer(SignalSerializer.ofSpans()).setExportFunction(arg_0 -> ((SpanExporter)wrapped).export(arg_0)).setStorageClock(clock).build();
        return new SpanDiskExporter(wrapped, diskExporter);
    }

    private SpanDiskExporter(SpanExporter wrapped, DiskExporter<SpanData> diskExporter) {
        this.wrapped = wrapped;
        this.diskExporter = diskExporter;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.diskExporter.onExport(spans);
    }

    public CompletableResultCode shutdown() {
        try {
            this.diskExporter.onShutDown();
        }
        catch (IOException e) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            return completableResultCode;
        }
        finally {
            this.wrapped.shutdown();
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public boolean exportStoredBatch(long timeout, TimeUnit unit) throws IOException {
        return this.diskExporter.exportStoredBatch(timeout, unit);
    }
}

