/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.AttributesMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.ResourceMapper;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfoBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseProtoSignalsDataMapper<SIGNAL_ITEM, PROTO_SIGNAL_ITEM, PROTO_DATA, PROTO_RESOURCE_ITEM, PROTO_SCOPE_ITEM> {
    public PROTO_DATA toProto(Collection<SIGNAL_ITEM> sourceItems) {
        HashMap<Resource, Map<InstrumentationScopeInfo, List<PROTO_SIGNAL_ITEM>>> itemsByResourceAndScope = new HashMap<Resource, Map<InstrumentationScopeInfo, List<PROTO_SIGNAL_ITEM>>>();
        sourceItems.forEach(sourceData -> {
            ArrayList<PROTO_SIGNAL_ITEM> scopeSignals;
            Resource resource = this.getResourceFromSignal(sourceData);
            InstrumentationScopeInfo instrumentationScopeInfo = this.getInstrumentationScopeInfo(sourceData);
            HashMap<InstrumentationScopeInfo, ArrayList<PROTO_SIGNAL_ITEM>> itemsByResource = (HashMap<InstrumentationScopeInfo, ArrayList<PROTO_SIGNAL_ITEM>>)itemsByResourceAndScope.get(resource);
            if (itemsByResource == null) {
                itemsByResource = new HashMap<InstrumentationScopeInfo, ArrayList<PROTO_SIGNAL_ITEM>>();
                itemsByResourceAndScope.put(resource, itemsByResource);
            }
            if ((scopeSignals = (ArrayList<PROTO_SIGNAL_ITEM>)itemsByResource.get(instrumentationScopeInfo)) == null) {
                scopeSignals = new ArrayList<PROTO_SIGNAL_ITEM>();
                itemsByResource.put(instrumentationScopeInfo, scopeSignals);
            }
            scopeSignals.add(this.signalItemToProto(sourceData));
        });
        return this.createProtoData(itemsByResourceAndScope);
    }

    public List<SIGNAL_ITEM> fromProto(PROTO_DATA protoData) {
        ArrayList<SIGNAL_ITEM> result = new ArrayList<SIGNAL_ITEM>();
        for (PROTO_RESOURCE_ITEM resourceSignal : this.getProtoResources(protoData)) {
            Resource resource = this.getResourceFromProto(resourceSignal);
            for (PROTO_SCOPE_ITEM scopeSignals : this.getScopes(resourceSignal)) {
                InstrumentationScopeInfo scopeInfo = this.getInstrumentationScopeFromProto(scopeSignals);
                for (PROTO_SIGNAL_ITEM item : this.getSignalsFromProto(scopeSignals)) {
                    result.add(this.protoToSignalItem(item, resource, scopeInfo));
                }
            }
        }
        return result;
    }

    protected io.opentelemetry.proto.resource.v1.Resource resourceToProto(Resource resource) {
        return ResourceMapper.getInstance().mapToProto(resource);
    }

    protected Resource protoToResource(io.opentelemetry.proto.resource.v1.Resource protoResource, String schemaUrl) {
        return ResourceMapper.getInstance().mapToSdk(protoResource, schemaUrl.isEmpty() ? null : schemaUrl);
    }

    protected InstrumentationScopeInfo protoToInstrumentationScopeInfo(InstrumentationScope scope, @Nullable String schemaUrl) {
        InstrumentationScopeInfoBuilder builder = InstrumentationScopeInfo.builder((String)scope.name);
        builder.setAttributes(BaseProtoSignalsDataMapper.protoToAttributes(scope.attributes));
        if (!scope.version.isEmpty()) {
            builder.setVersion(scope.version);
        }
        if (schemaUrl != null) {
            builder.setSchemaUrl(schemaUrl);
        }
        return builder.build();
    }

    protected InstrumentationScope instrumentationScopeToProto(InstrumentationScopeInfo source) {
        InstrumentationScope.Builder builder = new InstrumentationScope.Builder().name(source.getName());
        if (source.getVersion() != null) {
            builder.version(source.getVersion());
        }
        builder.attributes.addAll(BaseProtoSignalsDataMapper.attributesToProto(source.getAttributes()));
        return builder.build();
    }

    protected abstract PROTO_SIGNAL_ITEM signalItemToProto(SIGNAL_ITEM var1);

    protected abstract SIGNAL_ITEM protoToSignalItem(PROTO_SIGNAL_ITEM var1, Resource var2, InstrumentationScopeInfo var3);

    protected abstract List<PROTO_RESOURCE_ITEM> getProtoResources(PROTO_DATA var1);

    protected abstract PROTO_DATA createProtoData(Map<Resource, Map<InstrumentationScopeInfo, List<PROTO_SIGNAL_ITEM>>> var1);

    protected abstract List<PROTO_SIGNAL_ITEM> getSignalsFromProto(PROTO_SCOPE_ITEM var1);

    protected abstract InstrumentationScopeInfo getInstrumentationScopeFromProto(PROTO_SCOPE_ITEM var1);

    protected abstract List<PROTO_SCOPE_ITEM> getScopes(PROTO_RESOURCE_ITEM var1);

    protected abstract Resource getResourceFromProto(PROTO_RESOURCE_ITEM var1);

    protected abstract Resource getResourceFromSignal(SIGNAL_ITEM var1);

    protected abstract InstrumentationScopeInfo getInstrumentationScopeInfo(SIGNAL_ITEM var1);

    private static List<KeyValue> attributesToProto(Attributes source) {
        return AttributesMapper.getInstance().attributesToProto(source);
    }

    private static Attributes protoToAttributes(List<KeyValue> source) {
        return AttributesMapper.getInstance().protoToAttributes(source);
    }
}

