/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StoredBatchExporter;
import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.DiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class LogRecordDiskExporter
implements LogRecordExporter,
StoredBatchExporter {
    private final LogRecordExporter wrapped;
    private final DiskExporter<LogRecordData> diskExporter;

    public static LogRecordDiskExporter create(LogRecordExporter wrapped, File rootDir, StorageConfiguration configuration) throws IOException {
        return LogRecordDiskExporter.create(wrapped, rootDir, configuration, Clock.getDefault());
    }

    static LogRecordDiskExporter create(LogRecordExporter wrapped, File rootDir, StorageConfiguration configuration, Clock clock) throws IOException {
        DiskExporter<LogRecordData> diskExporter = DiskExporter.builder().setSerializer(SignalSerializer.ofLogs()).setRootDir(rootDir).setFolderName("logs").setStorageConfiguration(configuration).setStorageClock(clock).setExportFunction(arg_0 -> ((LogRecordExporter)wrapped).export(arg_0)).build();
        return new LogRecordDiskExporter(wrapped, diskExporter);
    }

    private LogRecordDiskExporter(LogRecordExporter wrapped, DiskExporter<LogRecordData> diskExporter) {
        this.wrapped = wrapped;
        this.diskExporter = diskExporter;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.diskExporter.onExport(logs);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.diskExporter.onShutDown();
        }
        catch (IOException e) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            return completableResultCode;
        }
        finally {
            this.wrapped.shutdown();
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public boolean exportStoredBatch(long timeout, TimeUnit unit) throws IOException {
        return this.diskExporter.exportStoredBatch(timeout, unit);
    }
}

