/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files;

import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.StorageFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.WritableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.utils.StorageClock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public final class WritableFile
extends StorageFile {
    private final StorageConfiguration configuration;
    private final StorageClock clock;
    private final long expireTimeMillis;
    private final OutputStream out;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private int size;

    public WritableFile(File file, long createdTimeMillis, StorageConfiguration configuration, StorageClock clock) throws IOException {
        super(file);
        this.configuration = configuration;
        this.clock = clock;
        this.expireTimeMillis = createdTimeMillis + configuration.getMaxFileAgeForWriteMillis();
        this.size = (int)file.length();
        this.out = new FileOutputStream(file);
    }

    public synchronized WritableResult append(byte[] data) throws IOException {
        if (this.isClosed.get()) {
            return WritableResult.FAILED;
        }
        if (this.hasExpired()) {
            this.close();
            return WritableResult.FAILED;
        }
        int futureSize = this.size + data.length;
        if (futureSize > this.configuration.getMaxFileSize()) {
            this.close();
            return WritableResult.FAILED;
        }
        this.out.write(data);
        this.size = futureSize;
        return WritableResult.SUCCEEDED;
    }

    @Override
    public synchronized long getSize() {
        return this.size;
    }

    @Override
    public synchronized boolean hasExpired() {
        return this.clock.now() >= this.expireTimeMillis;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.out.close();
        }
    }
}

