/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files;

import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.StorageFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.DelimitedProtoStreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.ReadResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.StreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.utils.FileTransferUtil;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.utils.StorageClock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ReadableFile
extends StorageFile {
    private final int originalFileSize;
    private final StreamReader reader;
    private final FileTransferUtil fileTransferUtil;
    private final File temporaryFile;
    private final StorageClock clock;
    private final long expireTimeMillis;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private int readBytes = 0;
    @Nullable
    private ReadResult unconsumedResult;

    public ReadableFile(File file, long createdTimeMillis, StorageClock clock, StorageConfiguration configuration) throws IOException {
        this(file, createdTimeMillis, clock, configuration, DelimitedProtoStreamReader.Factory.getInstance());
    }

    public ReadableFile(File file, long createdTimeMillis, StorageClock clock, StorageConfiguration configuration, StreamReader.Factory readerFactory) throws IOException {
        super(file);
        this.clock = clock;
        this.expireTimeMillis = createdTimeMillis + configuration.getMaxFileAgeForReadMillis();
        this.originalFileSize = (int)file.length();
        this.temporaryFile = configuration.getTemporaryFileProvider().createTemporaryFile(file.getName());
        ReadableFile.copyFile(file, this.temporaryFile);
        FileInputStream tempInputStream = new FileInputStream(this.temporaryFile);
        this.fileTransferUtil = new FileTransferUtil(tempInputStream, file);
        this.reader = readerFactory.create(tempInputStream);
    }

    public synchronized ReadableResult readAndProcess(Function<byte[], Boolean> processing) throws IOException {
        if (this.isClosed.get()) {
            return ReadableResult.FAILED;
        }
        if (this.hasExpired()) {
            this.close();
            return ReadableResult.FAILED;
        }
        ReadResult read = this.readNextItem();
        if (read == null) {
            this.cleanUp();
            return ReadableResult.FAILED;
        }
        if (processing.apply(read.content).booleanValue()) {
            this.unconsumedResult = null;
            this.readBytes += read.totalReadLength;
            int amountOfBytesToTransfer = this.originalFileSize - this.readBytes;
            if (amountOfBytesToTransfer > 0) {
                this.fileTransferUtil.transferBytes(this.readBytes, amountOfBytesToTransfer);
            } else {
                this.cleanUp();
            }
            return ReadableResult.SUCCEEDED;
        }
        this.unconsumedResult = read;
        return ReadableResult.PROCESSING_FAILED;
    }

    @Nullable
    private ReadResult readNextItem() throws IOException {
        if (this.unconsumedResult != null) {
            return this.unconsumedResult;
        }
        return this.reader.read();
    }

    private void cleanUp() throws IOException {
        this.file.delete();
        this.close();
    }

    @Override
    public long getSize() {
        return this.originalFileSize;
    }

    @Override
    public synchronized boolean hasExpired() {
        return this.clock.now() >= this.expireTimeMillis;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.unconsumedResult = null;
            this.fileTransferUtil.close();
            this.reader.close();
            this.temporaryFile.delete();
        }
    }

    private static void copyFile(File from, File to) throws IOException {
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            int lengthRead;
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
            }
        }
    }
}

