/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage;

import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.ReadableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.WritableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.utils.StorageClock;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FolderManager {
    private final File folder;
    private final StorageClock clock;
    private final StorageConfiguration configuration;
    @Nullable
    private ReadableFile currentReadableFile;
    @Nullable
    private WritableFile currentWritableFile;

    public FolderManager(File folder, StorageConfiguration configuration, StorageClock clock) {
        this.folder = folder;
        this.configuration = configuration;
        this.clock = clock;
    }

    @Nullable
    public synchronized ReadableFile getReadableFile() throws IOException {
        this.currentReadableFile = null;
        File readableFile = this.findReadableFile();
        if (readableFile != null) {
            this.currentReadableFile = new ReadableFile(readableFile, Long.parseLong(readableFile.getName()), this.clock, this.configuration);
            return this.currentReadableFile;
        }
        return null;
    }

    public synchronized WritableFile createWritableFile() throws IOException {
        long systemCurrentTimeMillis = this.clock.now();
        File[] existingFiles = this.folder.listFiles();
        if (existingFiles != null && this.purgeExpiredFilesIfAny(existingFiles, systemCurrentTimeMillis) == 0) {
            this.removeOldestFileIfSpaceIsNeeded(existingFiles);
        }
        File file = new File(this.folder, String.valueOf(systemCurrentTimeMillis));
        this.currentWritableFile = new WritableFile(file, systemCurrentTimeMillis, this.configuration, this.clock);
        return this.currentWritableFile;
    }

    @Nullable
    private File findReadableFile() throws IOException {
        long currentTime = this.clock.now();
        File[] existingFiles = this.folder.listFiles();
        File oldestFileAvailable = null;
        long oldestFileCreationTimeMillis = 0L;
        if (existingFiles != null) {
            for (File existingFile : existingFiles) {
                long existingFileCreationTimeMillis = Long.parseLong(existingFile.getName());
                if (!this.isReadyToBeRead(currentTime, existingFileCreationTimeMillis) || this.hasExpiredForReading(currentTime, existingFileCreationTimeMillis) || oldestFileAvailable != null && existingFileCreationTimeMillis >= oldestFileCreationTimeMillis) continue;
                oldestFileCreationTimeMillis = existingFileCreationTimeMillis;
                oldestFileAvailable = existingFile;
            }
        }
        if (oldestFileAvailable != null && this.currentWritableFile != null && oldestFileAvailable.equals(this.currentWritableFile.file)) {
            this.currentWritableFile.close();
        }
        return oldestFileAvailable;
    }

    private int purgeExpiredFilesIfAny(File[] existingFiles, long currentTimeMillis) throws IOException {
        int filesDeleted = 0;
        for (File existingFile : existingFiles) {
            if (!this.hasExpiredForReading(currentTimeMillis, Long.parseLong(existingFile.getName()))) continue;
            if (this.currentReadableFile != null && existingFile.equals(this.currentReadableFile.file)) {
                this.currentReadableFile.close();
            }
            if (!existingFile.delete()) continue;
            ++filesDeleted;
        }
        return filesDeleted;
    }

    private void removeOldestFileIfSpaceIsNeeded(File[] existingFiles) throws IOException {
        if (existingFiles.length > 0 && this.isNeededToClearSpaceForNewFile(existingFiles)) {
            File oldest = FolderManager.getOldest(existingFiles);
            if (this.currentReadableFile != null && oldest.equals(this.currentReadableFile.file)) {
                this.currentReadableFile.close();
            }
            if (!oldest.delete()) {
                throw new IOException("Could not delete the file: " + oldest);
            }
        }
    }

    private static File getOldest(File[] existingFiles) {
        File oldest = null;
        for (File existingFile : existingFiles) {
            if (oldest != null && existingFile.getName().compareTo(oldest.getName()) >= 0) continue;
            oldest = existingFile;
        }
        return Objects.requireNonNull(oldest);
    }

    private boolean isNeededToClearSpaceForNewFile(File[] existingFiles) {
        int currentFolderSize = 0;
        for (File existingFile : existingFiles) {
            currentFolderSize += (int)existingFile.length();
        }
        return currentFolderSize + this.configuration.getMaxFileSize() > this.configuration.getMaxFolderSize();
    }

    private boolean isReadyToBeRead(long currentTimeMillis, long createdTimeInMillis) {
        return currentTimeMillis >= createdTimeInMillis + this.configuration.getMinFileAgeForReadMillis();
    }

    private boolean hasExpiredForReading(long systemCurrentTimeMillis, long createdTimeInMillis) {
        return systemCurrentTimeMillis > createdTimeInMillis + this.configuration.getMaxFileAgeForReadMillis();
    }
}

