/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentThresholdSampler;

public class ConsistentVariableThresholdSampler
extends ConsistentThresholdSampler {
    private volatile long threshold;
    private volatile String description = "";

    protected ConsistentVariableThresholdSampler(double samplingProbability) {
        this.updateSamplingProbability(samplingProbability);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getThreshold() {
        return this.threshold;
    }

    public void setSamplingProbability(double samplingProbability) {
        this.updateSamplingProbability(samplingProbability);
    }

    private void updateSamplingProbability(double samplingProbability) {
        long threshold = ConsistentSamplingUtil.calculateThreshold(samplingProbability);
        ConsistentSamplingUtil.checkThreshold(threshold);
        this.threshold = threshold;
        String thresholdString = threshold == ConsistentSamplingUtil.getMaxThreshold() ? "max" : ConsistentSamplingUtil.appendLast56BitHexEncodedWithoutTrailingZeros(new StringBuilder(), threshold).toString();
        this.description = "ConsistentVariableThresholdSampler{threshold=" + thresholdString + ", sampling probability=" + ConsistentSamplingUtil.calculateSamplingProbability(threshold) + "}";
    }
}

