/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent;

import io.opentelemetry.contrib.sampler.consistent.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent.RValueGenerator;
import io.opentelemetry.contrib.sampler.consistent.RandomGenerator;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentProbabilityBasedSampler
extends ConsistentSampler {
    private final int lowerPValue;
    private final int upperPValue;
    private final double probabilityToUseLowerPValue;
    private final String description;
    private final RandomGenerator randomGenerator;

    ConsistentProbabilityBasedSampler(double samplingProbability, RValueGenerator rValueGenerator, RandomGenerator randomGenerator) {
        super(rValueGenerator);
        if (samplingProbability < 0.0 || samplingProbability > 1.0) {
            throw new IllegalArgumentException("Sampling probability must be in range [0.0, 1.0]!");
        }
        this.description = String.format("ConsistentProbabilityBasedSampler{%.6f}", samplingProbability);
        this.randomGenerator = randomGenerator;
        this.lowerPValue = ConsistentProbabilityBasedSampler.getLowerBoundP(samplingProbability);
        this.upperPValue = ConsistentProbabilityBasedSampler.getUpperBoundP(samplingProbability);
        if (this.lowerPValue == this.upperPValue) {
            this.probabilityToUseLowerPValue = 1.0;
        } else {
            double upperSamplingProbability = ConsistentProbabilityBasedSampler.getSamplingProbability(this.lowerPValue);
            double lowerSamplingProbability = ConsistentProbabilityBasedSampler.getSamplingProbability(this.upperPValue);
            this.probabilityToUseLowerPValue = (samplingProbability - lowerSamplingProbability) / (upperSamplingProbability - lowerSamplingProbability);
        }
    }

    @Override
    protected int getP(int parentP, boolean isRoot) {
        if (this.randomGenerator.nextBoolean(this.probabilityToUseLowerPValue)) {
            return this.lowerPValue;
        }
        return this.upperPValue;
    }

    public String getDescription() {
        return this.description;
    }
}

