/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.baggage.processor;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import java.util.function.Predicate;

public final class BaggageLogRecordProcessor
implements LogRecordProcessor {
    private final Predicate<String> baggageKeyPredicate;

    public BaggageLogRecordProcessor(Predicate<String> baggageKeyPredicate) {
        this.baggageKeyPredicate = baggageKeyPredicate;
    }

    public static BaggageLogRecordProcessor allowAllBaggageKeys() {
        return new BaggageLogRecordProcessor(baggageKey -> true);
    }

    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        Baggage.fromContext((Context)context).forEach((s, baggageEntry) -> {
            if (this.baggageKeyPredicate.test((String)s)) {
                logRecord.setAttribute(AttributeKey.stringKey((String)s), (Object)baggageEntry.getValue());
            }
        });
    }
}

