/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.AwsXrayAdaptiveSamplingConfig;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSamplerBuilder;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.SamplingRuleApplier;
import io.opentelemetry.contrib.awsxray.XrayRulesSampler;
import io.opentelemetry.contrib.awsxray.XraySamplerClient;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class AwsXrayRemoteSampler
implements Sampler,
Closeable {
    static final long DEFAULT_TARGET_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private static final Logger logger = Logger.getLogger(AwsXrayRemoteSampler.class.getName());
    private static final int maxExportBatchSize = 512;
    private final Resource resource;
    private final Clock clock;
    private final Sampler initialSampler;
    private final XraySamplerClient client;
    private final ScheduledExecutorService executor;
    private final String clientId;
    private final long pollingIntervalNanos;
    private final Iterator<Long> jitterNanos;
    @Nullable
    private volatile ScheduledFuture<?> pollFuture;
    @Nullable
    private volatile ScheduledFuture<?> fetchTargetsFuture;
    @Nullable
    private volatile GetSamplingRulesResponse previousRulesResponse;
    private volatile Sampler sampler;
    @Nullable
    private AwsXrayAdaptiveSamplingConfig adaptiveSamplingConfig;
    @Nullable
    private BatchSpanProcessor bsp;

    public static AwsXrayRemoteSamplerBuilder newBuilder(Resource resource) {
        return new AwsXrayRemoteSamplerBuilder(resource);
    }

    AwsXrayRemoteSampler(Resource resource, Clock clock, String endpoint, Sampler initialSampler, long pollingIntervalNanos) {
        this.resource = resource;
        this.clock = clock;
        this.initialSampler = initialSampler;
        this.client = new XraySamplerClient(endpoint);
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread t = Executors.defaultThreadFactory().newThread(runnable);
            try {
                t.setDaemon(true);
                t.setName("xray-rules-poller");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return t;
        });
        this.clientId = AwsXrayRemoteSampler.generateClientId();
        this.sampler = initialSampler;
        this.pollingIntervalNanos = pollingIntervalNanos;
        this.jitterNanos = ThreadLocalRandom.current().longs(0L, pollingIntervalNanos / 100L).iterator();
        this.executor.execute(this::getAndUpdateSampler);
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return "AwsXrayRemoteSampler{" + this.sampler.getDescription() + "}";
    }

    public void setAdaptiveSamplingConfig(AwsXrayAdaptiveSamplingConfig config) {
        if (this.adaptiveSamplingConfig != null) {
            throw new IllegalStateException("Programming bug - Adaptive sampling config is already set");
        }
        if (config != null && this.adaptiveSamplingConfig == null) {
            this.adaptiveSamplingConfig = config;
            if (this.sampler instanceof XrayRulesSampler) {
                ((XrayRulesSampler)this.sampler).setAdaptiveSamplingConfig(config);
            }
        }
    }

    public void setSpanExporter(SpanExporter spanExporter) {
        if (this.bsp != null) {
            throw new IllegalStateException("Programming bug - BatchSpanProcessor is already set");
        }
        if (spanExporter != null && this.bsp == null) {
            this.bsp = BatchSpanProcessor.builder((SpanExporter)spanExporter).setExportUnsampledSpans(true).setMaxExportBatchSize(512).build();
        }
    }

    public void adaptSampling(ReadableSpan span, SpanData spanData) {
        if (this.bsp == null) {
            throw new IllegalStateException("Programming bug - BatchSpanProcessor is null while trying to adapt sampling");
        }
        if (this.sampler instanceof XrayRulesSampler) {
            ((XrayRulesSampler)this.sampler).adaptSampling(span, spanData, arg_0 -> ((BatchSpanProcessor)this.bsp).onEnd(arg_0));
        }
    }

    private void getAndUpdateSampler() {
        try {
            GetSamplingRulesResponse response = this.client.getSamplingRules(GetSamplingRulesRequest.create(null));
            if (!response.equals(this.previousRulesResponse)) {
                this.sampler = new XrayRulesSampler(this.clientId, this.resource, this.clock, this.initialSampler, response.getSamplingRules().stream().map(GetSamplingRulesResponse.SamplingRuleRecord::getRule).collect(Collectors.toList()), this.adaptiveSamplingConfig);
                this.previousRulesResponse = response;
                ScheduledFuture<?> existingFetchTargetsFuture = this.fetchTargetsFuture;
                if (existingFetchTargetsFuture != null) {
                    existingFetchTargetsFuture.cancel(false);
                }
                this.fetchTargetsFuture = this.executor.schedule(this::fetchTargets, DEFAULT_TARGET_INTERVAL_NANOS, TimeUnit.NANOSECONDS);
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "Failed to update sampler", t);
        }
        this.scheduleSamplerUpdate();
    }

    private void scheduleSamplerUpdate() {
        long delay = this.pollingIntervalNanos + this.jitterNanos.next();
        this.pollFuture = this.executor.schedule(this::getAndUpdateSampler, delay, TimeUnit.NANOSECONDS);
    }

    @Nullable
    Duration getNextSamplerUpdateScheduledDuration() {
        ScheduledFuture<?> pollFuture = this.pollFuture;
        if (pollFuture == null) {
            return null;
        }
        return Duration.ofNanos(pollFuture.getDelay(TimeUnit.NANOSECONDS));
    }

    private void fetchTargets() {
        if (!(this.sampler instanceof XrayRulesSampler)) {
            throw new IllegalStateException("Programming bug.");
        }
        XrayRulesSampler xrayRulesSampler = (XrayRulesSampler)this.sampler;
        try {
            Date now = Date.from(Instant.ofEpochSecond(0L, this.clock.now()));
            List<SamplingRuleApplier.SamplingRuleStatisticsSnapshot> statisticsSnapshot = xrayRulesSampler.snapshot(now);
            ArrayList<GetSamplingTargetsRequest.SamplingStatisticsDocument> statistics = new ArrayList<GetSamplingTargetsRequest.SamplingStatisticsDocument>();
            ArrayList<GetSamplingTargetsRequest.SamplingBoostStatisticsDocument> boostStatistics = new ArrayList<GetSamplingTargetsRequest.SamplingBoostStatisticsDocument>();
            statisticsSnapshot.stream().forEach(snapshot -> {
                if (snapshot.getStatisticsDocument() != null) {
                    statistics.add(snapshot.getStatisticsDocument());
                }
                if (snapshot.getBoostStatisticsDocument() != null && snapshot.getBoostStatisticsDocument().getTotalCount() > 0L) {
                    boostStatistics.add(snapshot.getBoostStatisticsDocument());
                }
            });
            Set<String> requestedTargetRuleNames = statistics.stream().map(GetSamplingTargetsRequest.SamplingStatisticsDocument::getRuleName).collect(Collectors.toSet());
            GetSamplingTargetsRequest req = GetSamplingTargetsRequest.create(statistics, boostStatistics);
            GetSamplingTargetsResponse response = this.client.getSamplingTargets(req);
            Map<String, GetSamplingTargetsResponse.SamplingTargetDocument> targets = response.getDocuments().stream().collect(Collectors.toMap(GetSamplingTargetsResponse.SamplingTargetDocument::getRuleName, Function.identity()));
            xrayRulesSampler = xrayRulesSampler.withTargets(targets, requestedTargetRuleNames, now);
            this.sampler = xrayRulesSampler;
        }
        catch (Throwable t) {
            this.fetchTargetsFuture = this.executor.schedule(this::fetchTargets, DEFAULT_TARGET_INTERVAL_NANOS, TimeUnit.NANOSECONDS);
            return;
        }
        long nextTargetFetchIntervalNanos = xrayRulesSampler.nextTargetFetchTimeNanos() - this.clock.nanoTime();
        this.fetchTargetsFuture = this.executor.schedule(this::fetchTargets, nextTargetFetchIntervalNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
        ScheduledFuture<?> pollFuture = this.pollFuture;
        if (pollFuture != null) {
            pollFuture.cancel(true);
        }
        this.executor.shutdownNow();
    }

    private static String generateClientId() {
        Random rand = new Random();
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] clientIdChars = new char[24];
        for (int i = 0; i < clientIdChars.length; ++i) {
            clientIdChars[i] = hex[rand.nextInt(hex.length)];
        }
        return new String(clientIdChars);
    }

    XraySamplerClient getClient() {
        return this.client;
    }

    Resource getResource() {
        return this.resource;
    }
}

