/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.AwsAttributeKeys;
import io.opentelemetry.contrib.awsxray.AwsSamplingResult;
import io.opentelemetry.contrib.awsxray.AwsXrayAdaptiveSamplingConfig;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.RateLimiter;
import io.opentelemetry.contrib.awsxray.SamplingRuleApplier;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServiceAttributes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class XrayRulesSampler
implements Sampler {
    private static final Logger logger = Logger.getLogger(XrayRulesSampler.class.getName());
    public static final AttributeKey<String> AWS_XRAY_SAMPLING_RULE = AttributeKey.stringKey((String)"aws.xray.sampling_rule");
    private static final String UNKNOWN_OPERATION = "UnknownOperation";
    private static final AttributeKey<String> URL_PATH = AttributeKey.stringKey((String)"url.path");
    private static final AttributeKey<String> HTTP_TARGET = AttributeKey.stringKey((String)"http.target");
    private static final AttributeKey<String> HTTP_REQUEST_METHOD = AttributeKey.stringKey((String)"http.request.method");
    private static final AttributeKey<String> HTTP_METHOD = AttributeKey.stringKey((String)"http.method");
    private final String clientId;
    private final Resource resource;
    private final Clock clock;
    private final Sampler fallbackSampler;
    private final SamplingRuleApplier[] ruleAppliers;
    private final Map<String, String> ruleToHashMap;
    private final Map<String, String> hashToRuleMap;
    private final boolean adaptiveSamplingRuleExists;
    private final Cache<String, AwsXrayAdaptiveSamplingConfig.UsageType> traceUsageCache;
    @Nullable
    private AwsXrayAdaptiveSamplingConfig adaptiveSamplingConfig;
    @Nullable
    private RateLimiter anomalyCaptureRateLimiter;

    XrayRulesSampler(String clientId, Resource resource, Clock clock, Sampler fallbackSampler, List<GetSamplingRulesResponse.SamplingRule> rules, @Nullable AwsXrayAdaptiveSamplingConfig adaptiveSamplingConfig) {
        this(clientId, resource, clock, fallbackSampler, (SamplingRuleApplier[])rules.stream().sorted(Comparator.comparingInt(GetSamplingRulesResponse.SamplingRule::getPriority)).map(rule -> new SamplingRuleApplier(clientId, (GetSamplingRulesResponse.SamplingRule)rule, (String)resource.getAttribute(ServiceAttributes.SERVICE_NAME), clock)).toArray(SamplingRuleApplier[]::new), XrayRulesSampler.createRuleHashMaps(rules), rules.stream().anyMatch(r -> r.getSamplingRateBoost() != null), adaptiveSamplingConfig, (Cache<String, AwsXrayAdaptiveSamplingConfig.UsageType>)Caffeine.newBuilder().maximumSize(100000L).ticker(() -> ((Clock)clock).nanoTime()).expireAfterWrite(Duration.ofMinutes(10L)).build());
    }

    private XrayRulesSampler(String clientId, Resource resource, Clock clock, Sampler fallbackSampler, SamplingRuleApplier[] ruleAppliers, Map<String, String> ruleToHashMap, boolean adaptiveSamplingRuleExists, @Nullable AwsXrayAdaptiveSamplingConfig adaptiveSamplingConfig, Cache<String, AwsXrayAdaptiveSamplingConfig.UsageType> traceUsageCache) {
        this.clientId = clientId;
        this.resource = resource;
        this.clock = clock;
        this.fallbackSampler = fallbackSampler;
        this.ruleAppliers = ruleAppliers;
        this.ruleToHashMap = ruleToHashMap;
        this.hashToRuleMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : ruleToHashMap.entrySet()) {
            this.hashToRuleMap.put(entry.getValue(), entry.getKey());
        }
        this.adaptiveSamplingRuleExists = adaptiveSamplingRuleExists;
        this.adaptiveSamplingConfig = adaptiveSamplingConfig;
        this.traceUsageCache = traceUsageCache;
        if (this.adaptiveSamplingConfig != null && this.adaptiveSamplingConfig.getAnomalyCaptureLimit() == null) {
            this.anomalyCaptureRateLimiter = new RateLimiter(1.0, 1.0, clock);
        } else if (adaptiveSamplingConfig != null && adaptiveSamplingConfig.getAnomalyCaptureLimit() != null) {
            int anomalyTracesPerSecond = adaptiveSamplingConfig.getAnomalyCaptureLimit().getAnomalyTracesPerSecond();
            this.anomalyCaptureRateLimiter = new RateLimiter(anomalyTracesPerSecond, anomalyTracesPerSecond, clock);
        }
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SpanContext parentSpanContext = Span.fromContext((Context)parentContext).getSpanContext();
        String upstreamMatchedRule = parentSpanContext.getTraceState().get("xrsr");
        if (upstreamMatchedRule == null) {
            Baggage b = Baggage.fromContext((Context)parentContext);
            upstreamMatchedRule = b != null ? b.getEntryValue("xrsr") : null;
        }
        for (SamplingRuleApplier applier : this.ruleAppliers) {
            if (!applier.matches(attributes, this.resource)) continue;
            SamplingResult result = applier.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
            String ruleToPropagate = upstreamMatchedRule != null ? (String)this.hashToRuleMap.getOrDefault(upstreamMatchedRule, null) : (parentSpanContext.isValid() ? null : applier.getRuleName());
            String hashedRule = this.ruleToHashMap.getOrDefault(ruleToPropagate, upstreamMatchedRule);
            return AwsSamplingResult.create(result.getDecision(), result.getAttributes().toBuilder().put(AWS_XRAY_SAMPLING_RULE.getKey(), ruleToPropagate != null ? ruleToPropagate : "UNKNOWN").build(), hashedRule);
        }
        logger.log(Level.FINE, "No sampling rule matched the request. This is a bug in either the OpenTelemetry SDK or X-Ray.");
        return this.fallbackSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return "XrayRulesSampler{" + Arrays.toString(this.ruleAppliers) + "}";
    }

    void setAdaptiveSamplingConfig(AwsXrayAdaptiveSamplingConfig config) {
        if (this.adaptiveSamplingConfig != null) {
            throw new IllegalStateException("Programming bug - Adaptive sampling config is already set");
        }
        if (config != null && this.adaptiveSamplingConfig == null) {
            this.adaptiveSamplingConfig = config;
            if (config.getAnomalyCaptureLimit() != null) {
                int anomalyTracesPerSecond = config.getAnomalyCaptureLimit().getAnomalyTracesPerSecond();
                this.anomalyCaptureRateLimiter = new RateLimiter(anomalyTracesPerSecond, anomalyTracesPerSecond, this.clock);
            } else {
                this.anomalyCaptureRateLimiter = new RateLimiter(1.0, 1.0, this.clock);
            }
        }
    }

    void adaptSampling(ReadableSpan span, SpanData spanData, Consumer<ReadableSpan> spanBatcher) {
        if (!this.adaptiveSamplingRuleExists && this.adaptiveSamplingConfig == null) {
            return;
        }
        AnomalyDetectionResult result = this.isAnomaly(span, spanData);
        boolean shouldBoostSampling = result.shouldBoostSampling();
        boolean shouldCaptureAnomalySpan = result.shouldCaptureAnomalySpan();
        String traceId = spanData.getTraceId();
        AwsXrayAdaptiveSamplingConfig.UsageType existingUsage = (AwsXrayAdaptiveSamplingConfig.UsageType)((Object)this.traceUsageCache.getIfPresent((Object)traceId));
        boolean isNewTrace = existingUsage == null;
        boolean isSpanCaptured = false;
        if (AwsXrayAdaptiveSamplingConfig.UsageType.isUsedForAnomalyTraceCapture(existingUsage) || shouldCaptureAnomalySpan && !span.getSpanContext().isSampled() && this.anomalyCaptureRateLimiter != null && this.anomalyCaptureRateLimiter.trySpend(1.0)) {
            spanBatcher.accept(span);
            isSpanCaptured = true;
        }
        boolean isCountedAsAnomalyForBoost = false;
        if (shouldBoostSampling || isNewTrace) {
            String traceStateValue = span.getSpanContext().getTraceState().get("xrsr");
            String upstreamRuleName = traceStateValue != null ? this.hashToRuleMap.getOrDefault(traceStateValue, traceStateValue) : traceStateValue;
            SamplingRuleApplier ruleToReportTo = null;
            SamplingRuleApplier matchedRule = null;
            for (SamplingRuleApplier applier : this.ruleAppliers) {
                if (applier.getRuleName().equals(upstreamRuleName)) {
                    ruleToReportTo = applier;
                    break;
                }
                if (!applier.matches(spanData.getAttributes(), this.resource)) continue;
                matchedRule = applier;
            }
            if (ruleToReportTo == null) {
                if (matchedRule == null) {
                    logger.log(Level.FINE, "No sampling rule matched the request. This is a bug in either the OpenTelemetry SDK or X-Ray.");
                } else if (!span.getParentSpanContext().isValid()) {
                    ruleToReportTo = matchedRule;
                }
            }
            if (shouldBoostSampling && ruleToReportTo != null && ruleToReportTo.hasBoost() && !AwsXrayAdaptiveSamplingConfig.UsageType.isUsedForBoost(existingUsage)) {
                ruleToReportTo.countAnomalyTrace(span);
                isCountedAsAnomalyForBoost = true;
            }
            if (isNewTrace && ruleToReportTo != null && ruleToReportTo.hasBoost()) {
                ruleToReportTo.countTrace();
            }
        }
        this.updateTraceUsageCache(traceId, isSpanCaptured, isCountedAsAnomalyForBoost);
    }

    List<SamplingRuleApplier.SamplingRuleStatisticsSnapshot> snapshot(Date now) {
        return Arrays.stream(this.ruleAppliers).map(rule -> rule.snapshot(now)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    long nextTargetFetchTimeNanos() {
        return Arrays.stream(this.ruleAppliers).mapToLong(SamplingRuleApplier::getNextSnapshotTimeNanos).min().orElseGet(() -> this.clock.nanoTime() + AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS);
    }

    XrayRulesSampler withTargets(Map<String, GetSamplingTargetsResponse.SamplingTargetDocument> ruleTargets, Set<String> requestedTargetRuleNames, Date now) {
        long currentNanoTime = this.clock.nanoTime();
        long defaultNextSnapshotTimeNanos = currentNanoTime + AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS;
        SamplingRuleApplier[] newAppliers = (SamplingRuleApplier[])Arrays.stream(this.ruleAppliers).map(rule -> {
            GetSamplingTargetsResponse.SamplingTargetDocument target = (GetSamplingTargetsResponse.SamplingTargetDocument)ruleTargets.get(rule.getRuleName());
            if (target != null) {
                return rule.withTarget(target, now, currentNanoTime);
            }
            if (requestedTargetRuleNames.contains(rule.getRuleName())) {
                return rule.withNextSnapshotTimeNanos(defaultNextSnapshotTimeNanos);
            }
            return rule;
        }).toArray(SamplingRuleApplier[]::new);
        return new XrayRulesSampler(this.clientId, this.resource, this.clock, this.fallbackSampler, newAppliers, this.ruleToHashMap, this.adaptiveSamplingRuleExists, this.adaptiveSamplingConfig, this.traceUsageCache);
    }

    private AnomalyDetectionResult isAnomaly(ReadableSpan span, SpanData spanData) {
        List<AwsXrayAdaptiveSamplingConfig.AnomalyConditions> anomalyConditions;
        boolean shouldBoostSampling = false;
        boolean shouldCaptureAnomalySpan = false;
        Long statusCode = (Long)spanData.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE);
        List<AwsXrayAdaptiveSamplingConfig.AnomalyConditions> list = anomalyConditions = this.adaptiveSamplingConfig != null ? this.adaptiveSamplingConfig.getAnomalyConditions() : null;
        if (anomalyConditions != null) {
            String operation = (String)spanData.getAttributes().get(AwsAttributeKeys.AWS_LOCAL_OPERATION);
            if (operation == null) {
                operation = XrayRulesSampler.generateIngressOperation(spanData);
            }
            for (AwsXrayAdaptiveSamplingConfig.AnomalyConditions condition : anomalyConditions) {
                Long highLatencyMs;
                List<String> operations;
                if (shouldBoostSampling && AwsXrayAdaptiveSamplingConfig.UsageType.SAMPLING_BOOST.equals((Object)condition.getUsage()) || shouldCaptureAnomalySpan && AwsXrayAdaptiveSamplingConfig.UsageType.ANOMALY_TRACE_CAPTURE.equals((Object)condition.getUsage()) || (operations = condition.getOperations()) != null && !operations.isEmpty() && !operations.contains(operation)) continue;
                boolean isAnomaly = false;
                String errorCodeRegex = condition.getErrorCodeRegex();
                if (statusCode != null && errorCodeRegex != null) {
                    isAnomaly = statusCode.toString().matches(errorCodeRegex);
                }
                if ((highLatencyMs = condition.getHighLatencyMs()) != null) {
                    boolean bl = isAnomaly = (errorCodeRegex == null || isAnomaly) && (double)span.getLatencyNanos() / 1000000.0 >= (double)highLatencyMs.longValue();
                }
                if (isAnomaly) {
                    AwsXrayAdaptiveSamplingConfig.UsageType usage = condition.getUsage();
                    if (usage != null) {
                        switch (usage) {
                            case BOTH: {
                                shouldBoostSampling = true;
                                shouldCaptureAnomalySpan = true;
                                break;
                            }
                            case SAMPLING_BOOST: {
                                shouldBoostSampling = true;
                                break;
                            }
                            case ANOMALY_TRACE_CAPTURE: {
                                shouldCaptureAnomalySpan = true;
                                break;
                            }
                        }
                    } else {
                        shouldBoostSampling = true;
                        shouldCaptureAnomalySpan = true;
                    }
                }
                if (!shouldBoostSampling || !shouldCaptureAnomalySpan) continue;
                break;
            }
        } else if (statusCode != null && statusCode > 499L || statusCode == null && spanData.getStatus() != null && StatusCode.ERROR.equals((Object)spanData.getStatus().getStatusCode())) {
            shouldBoostSampling = true;
            shouldCaptureAnomalySpan = true;
        }
        return new AnomalyDetectionResult(shouldBoostSampling, shouldCaptureAnomalySpan);
    }

    static boolean isKeyPresent(SpanData span, AttributeKey<?> key) {
        return span.getAttributes().get(key) != null;
    }

    private static String generateIngressOperation(SpanData span) {
        String operation = UNKNOWN_OPERATION;
        if (XrayRulesSampler.isKeyPresent(span, URL_PATH) || XrayRulesSampler.isKeyPresent(span, HTTP_TARGET)) {
            String httpTarget;
            String string = httpTarget = XrayRulesSampler.isKeyPresent(span, URL_PATH) ? (String)span.getAttributes().get(URL_PATH) : (String)span.getAttributes().get(HTTP_TARGET);
            if (httpTarget != null) {
                operation = XrayRulesSampler.extractApiPathValue(httpTarget);
                if (XrayRulesSampler.isKeyPresent(span, HTTP_REQUEST_METHOD) || XrayRulesSampler.isKeyPresent(span, HTTP_METHOD)) {
                    String httpMethod;
                    String string2 = httpMethod = XrayRulesSampler.isKeyPresent(span, HTTP_REQUEST_METHOD) ? (String)span.getAttributes().get(HTTP_REQUEST_METHOD) : (String)span.getAttributes().get(HTTP_METHOD);
                    if (httpMethod != null) {
                        operation = httpMethod + " " + operation;
                    }
                }
            }
        }
        return operation;
    }

    private static String extractApiPathValue(String httpTarget) {
        if (httpTarget == null || httpTarget.isEmpty()) {
            return "/";
        }
        String[] paths = httpTarget.split("/");
        if (paths.length > 1) {
            return "/" + paths[1];
        }
        return "/";
    }

    private void updateTraceUsageCache(String traceId, boolean isSpanCaptured, boolean isCountedAsAnomalyForBoost) {
        AwsXrayAdaptiveSamplingConfig.UsageType existingUsage = (AwsXrayAdaptiveSamplingConfig.UsageType)((Object)this.traceUsageCache.getIfPresent((Object)traceId));
        if (isSpanCaptured && isCountedAsAnomalyForBoost) {
            this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.BOTH);
        } else if (isSpanCaptured) {
            if (AwsXrayAdaptiveSamplingConfig.UsageType.isUsedForBoost(existingUsage)) {
                this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.BOTH);
            } else {
                this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.ANOMALY_TRACE_CAPTURE);
            }
        } else if (isCountedAsAnomalyForBoost) {
            if (AwsXrayAdaptiveSamplingConfig.UsageType.isUsedForAnomalyTraceCapture(existingUsage)) {
                this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.BOTH);
            } else {
                this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.SAMPLING_BOOST);
            }
        } else if (existingUsage != null) {
            this.traceUsageCache.put((Object)traceId, (Object)existingUsage);
        } else {
            this.traceUsageCache.put((Object)traceId, (Object)AwsXrayAdaptiveSamplingConfig.UsageType.NEITHER);
        }
    }

    private static Map<String, String> createRuleHashMaps(List<GetSamplingRulesResponse.SamplingRule> rules) {
        HashMap<String, String> ruleToHashMap = new HashMap<String, String>();
        for (GetSamplingRulesResponse.SamplingRule rule : rules) {
            String ruleName = rule.getRuleName();
            if (ruleName == null) continue;
            ruleToHashMap.put(ruleName, XrayRulesSampler.hashRuleName(ruleName));
        }
        return ruleToHashMap;
    }

    static String hashRuleName(String ruleName) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(ruleName.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < Math.min(hash.length, 8); ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return ruleName;
        }
    }

    Cache<String, AwsXrayAdaptiveSamplingConfig.UsageType> getTraceUsageCache() {
        this.traceUsageCache.cleanUp();
        return this.traceUsageCache;
    }

    private static class AnomalyDetectionResult {
        private final boolean shouldBoostSampling;
        private final boolean shouldCaptureAnomalySpan;

        AnomalyDetectionResult(boolean shouldBoostSampling, boolean shouldCaptureAnomalySpan) {
            this.shouldBoostSampling = shouldBoostSampling;
            this.shouldCaptureAnomalySpan = shouldCaptureAnomalySpan;
        }

        boolean shouldBoostSampling() {
            return this.shouldBoostSampling;
        }

        boolean shouldCaptureAnomalySpan() {
            return this.shouldCaptureAnomalySpan;
        }
    }
}

