/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AlwaysRecordSampler
implements Sampler {
    private final Sampler rootSampler;

    public static AlwaysRecordSampler create(Sampler rootSampler) {
        return new AlwaysRecordSampler(rootSampler);
    }

    private AlwaysRecordSampler(Sampler rootSampler) {
        this.rootSampler = rootSampler;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingResult result = this.rootSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        if (result.getDecision() == SamplingDecision.DROP) {
            result = AlwaysRecordSampler.wrapResultWithRecordOnlyResult(result);
        }
        return result;
    }

    public String getDescription() {
        return "AlwaysRecordSampler{" + this.rootSampler.getDescription() + "}";
    }

    private static SamplingResult wrapResultWithRecordOnlyResult(final SamplingResult result) {
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return SamplingDecision.RECORD_ONLY;
            }

            public Attributes getAttributes() {
                return result.getAttributes();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                return result.getUpdatedTraceState(parentTraceState);
            }
        };
    }
}

