/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.RateLimitingSampler;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.ServiceAttributes;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SamplingRuleApplier {
    private static final AttributeKey<String> AWS_ECS_CONTAINER_ARN = AttributeKey.stringKey((String)"aws.ecs.container.arn");
    private static final AttributeKey<String> CLOUD_PLATFORM = AttributeKey.stringKey((String)"cloud.platform");
    private static final AttributeKey<String> CLOUD_RESOURCE_ID = AttributeKey.stringKey((String)"cloud.resource_id");
    public static final String AWS_EC2 = "aws_ec2";
    public static final String AWS_ECS = "aws_ecs";
    public static final String AWS_EKS = "aws_eks";
    public static final String AWS_LAMBDA = "aws_lambda";
    public static final String AWS_ELASTIC_BEANSTALK = "aws_elastic_beanstalk";
    private static final AttributeKey<String> HTTP_HOST = AttributeKey.stringKey((String)"http.host");
    private static final AttributeKey<String> HTTP_METHOD = AttributeKey.stringKey((String)"http.method");
    private static final AttributeKey<String> HTTP_TARGET = AttributeKey.stringKey((String)"http.target");
    private static final AttributeKey<String> HTTP_URL = AttributeKey.stringKey((String)"http.url");
    private static final AttributeKey<String> NET_HOST_NAME = AttributeKey.stringKey((String)"net.host.name");
    private static final Map<String, String> XRAY_CLOUD_PLATFORM;
    private final String clientId;
    private final String ruleName;
    private final Clock clock;
    private final Sampler reservoirSampler;
    private final long reservoirEndTimeNanos;
    private final Sampler fixedRateSampler;
    private final boolean borrowing;
    private final Map<String, Matcher> attributeMatchers;
    private final Matcher urlPathMatcher;
    private final Matcher serviceNameMatcher;
    private final Matcher httpMethodMatcher;
    private final Matcher hostMatcher;
    private final Matcher serviceTypeMatcher;
    private final Matcher resourceArnMatcher;
    private final Statistics statistics;
    private final long nextSnapshotTimeNanos;

    SamplingRuleApplier(String clientId, GetSamplingRulesResponse.SamplingRule rule, Clock clock) {
        this.clientId = clientId;
        this.clock = clock;
        String ruleName = rule.getRuleName();
        if (ruleName == null) {
            ruleName = "default";
        }
        this.ruleName = ruleName;
        this.nextSnapshotTimeNanos = clock.nanoTime();
        this.reservoirEndTimeNanos = Long.MAX_VALUE;
        if (rule.getReservoirSize() > 0) {
            this.reservoirSampler = this.createRateLimited(1);
            this.borrowing = true;
        } else {
            this.reservoirSampler = Sampler.alwaysOff();
            this.borrowing = false;
        }
        this.fixedRateSampler = SamplingRuleApplier.createFixedRate(rule.getFixedRate());
        this.attributeMatchers = rule.getAttributes().isEmpty() ? Collections.emptyMap() : rule.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SamplingRuleApplier.toMatcher((String)e.getValue())));
        this.urlPathMatcher = SamplingRuleApplier.toMatcher(rule.getUrlPath());
        this.serviceNameMatcher = SamplingRuleApplier.toMatcher(rule.getServiceName());
        this.httpMethodMatcher = SamplingRuleApplier.toMatcher(rule.getHttpMethod());
        this.hostMatcher = SamplingRuleApplier.toMatcher(rule.getHost());
        this.serviceTypeMatcher = SamplingRuleApplier.toMatcher(rule.getServiceType());
        this.resourceArnMatcher = SamplingRuleApplier.toMatcher(rule.getResourceArn());
        this.statistics = new Statistics();
    }

    private SamplingRuleApplier(String clientId, String ruleName, Clock clock, Sampler reservoirSampler, long reservoirEndTimeNanos, Sampler fixedRateSampler, boolean borrowing, Map<String, Matcher> attributeMatchers, Matcher urlPathMatcher, Matcher serviceNameMatcher, Matcher httpMethodMatcher, Matcher hostMatcher, Matcher serviceTypeMatcher, Matcher resourceArnMatcher, Statistics statistics, long nextSnapshotTimeNanos) {
        this.clientId = clientId;
        this.ruleName = ruleName;
        this.clock = clock;
        this.reservoirSampler = reservoirSampler;
        this.reservoirEndTimeNanos = reservoirEndTimeNanos;
        this.fixedRateSampler = fixedRateSampler;
        this.borrowing = borrowing;
        this.attributeMatchers = attributeMatchers;
        this.urlPathMatcher = urlPathMatcher;
        this.serviceNameMatcher = serviceNameMatcher;
        this.httpMethodMatcher = httpMethodMatcher;
        this.hostMatcher = hostMatcher;
        this.serviceTypeMatcher = serviceTypeMatcher;
        this.resourceArnMatcher = resourceArnMatcher;
        this.statistics = statistics;
        this.nextSnapshotTimeNanos = nextSnapshotTimeNanos;
    }

    boolean matches(Attributes attributes, Resource resource) {
        int schemeEndIndex;
        int matchedAttributes = 0;
        String httpTarget = null;
        String httpUrl = null;
        String httpMethod = null;
        String host = null;
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            Matcher matcher;
            if (((AttributeKey)entry.getKey()).equals(HTTP_TARGET)) {
                httpTarget = (String)entry.getValue();
            } else if (((AttributeKey)entry.getKey()).equals(HTTP_URL)) {
                httpUrl = (String)entry.getValue();
            } else if (((AttributeKey)entry.getKey()).equals(HTTP_METHOD)) {
                httpMethod = (String)entry.getValue();
            } else if (((AttributeKey)entry.getKey()).equals(NET_HOST_NAME)) {
                host = (String)entry.getValue();
            } else if (((AttributeKey)entry.getKey()).equals(HTTP_HOST)) {
                host = (String)entry.getValue();
            }
            if ((matcher = this.attributeMatchers.get(((AttributeKey)entry.getKey()).getKey())) == null) continue;
            if (matcher.matches(entry.getValue().toString())) {
                ++matchedAttributes;
                continue;
            }
            return false;
        }
        if (matchedAttributes != this.attributeMatchers.size()) {
            return false;
        }
        if (httpTarget == null && httpUrl != null && (schemeEndIndex = httpUrl.indexOf("://")) > 0) {
            int pathIndex = httpUrl.indexOf(47, schemeEndIndex + "://".length());
            httpTarget = pathIndex < 0 ? "/" : httpUrl.substring(pathIndex);
        }
        return this.urlPathMatcher.matches(httpTarget) && this.serviceNameMatcher.matches((String)resource.getAttribute(ServiceAttributes.SERVICE_NAME)) && this.httpMethodMatcher.matches(httpMethod) && this.hostMatcher.matches(host) && this.serviceTypeMatcher.matches(SamplingRuleApplier.getServiceType(resource)) && this.resourceArnMatcher.matches(SamplingRuleApplier.getArn(attributes, resource));
    }

    SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingResult result;
        this.statistics.requests.increment();
        boolean reservoirExpired = this.clock.nanoTime() >= this.reservoirEndTimeNanos;
        SamplingResult samplingResult = result = !reservoirExpired ? this.reservoirSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : SamplingResult.create((SamplingDecision)SamplingDecision.DROP);
        if (result.getDecision() != SamplingDecision.DROP) {
            if (this.borrowing) {
                this.statistics.borrowed.increment();
            }
            this.statistics.sampled.increment();
            return result;
        }
        result = this.fixedRateSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        if (result.getDecision() != SamplingDecision.DROP) {
            this.statistics.sampled.increment();
        }
        return result;
    }

    @Nullable
    GetSamplingTargetsRequest.SamplingStatisticsDocument snapshot(Date now) {
        if (this.clock.nanoTime() < this.nextSnapshotTimeNanos) {
            return null;
        }
        return GetSamplingTargetsRequest.SamplingStatisticsDocument.newBuilder().setClientId(this.clientId).setRuleName(this.ruleName).setTimestamp(now).setRequestCount(this.statistics.requests.sumThenReset()).setSampledCount(this.statistics.sampled.sumThenReset()).setBorrowCount(this.statistics.borrowed.sumThenReset()).build();
    }

    long getNextSnapshotTimeNanos() {
        return this.nextSnapshotTimeNanos;
    }

    SamplingRuleApplier withTarget(GetSamplingTargetsResponse.SamplingTargetDocument target, Date now) {
        Sampler newFixedRateSampler = SamplingRuleApplier.createFixedRate(target.getFixedRate());
        Sampler newReservoirSampler = Sampler.alwaysOff();
        long newReservoirEndTimeNanos = this.clock.nanoTime();
        if (target.getReservoirQuota() != null && target.getReservoirQuotaTtl() != null) {
            newReservoirSampler = this.createRateLimited(target.getReservoirQuota());
            newReservoirEndTimeNanos = this.clock.nanoTime() + Duration.between(now.toInstant(), target.getReservoirQuotaTtl().toInstant()).toNanos();
        }
        long intervalNanos = target.getIntervalSecs() != null ? TimeUnit.SECONDS.toNanos(target.getIntervalSecs().intValue()) : AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS;
        long newNextSnapshotTimeNanos = this.clock.nanoTime() + intervalNanos;
        return new SamplingRuleApplier(this.clientId, this.ruleName, this.clock, newReservoirSampler, newReservoirEndTimeNanos, newFixedRateSampler, false, this.attributeMatchers, this.urlPathMatcher, this.serviceNameMatcher, this.httpMethodMatcher, this.hostMatcher, this.serviceTypeMatcher, this.resourceArnMatcher, this.statistics, newNextSnapshotTimeNanos);
    }

    SamplingRuleApplier withNextSnapshotTimeNanos(long newNextSnapshotTimeNanos) {
        return new SamplingRuleApplier(this.clientId, this.ruleName, this.clock, this.reservoirSampler, this.reservoirEndTimeNanos, this.fixedRateSampler, this.borrowing, this.attributeMatchers, this.urlPathMatcher, this.serviceNameMatcher, this.httpMethodMatcher, this.hostMatcher, this.serviceTypeMatcher, this.resourceArnMatcher, this.statistics, newNextSnapshotTimeNanos);
    }

    String getRuleName() {
        return this.ruleName;
    }

    @Nullable
    private static String getArn(Attributes attributes, Resource resource) {
        String arn = (String)resource.getAttributes().get(AWS_ECS_CONTAINER_ARN);
        if (arn != null) {
            return arn;
        }
        String cloudPlatform = (String)resource.getAttributes().get(CLOUD_PLATFORM);
        if (AWS_LAMBDA.equals(cloudPlatform)) {
            return SamplingRuleApplier.getLambdaArn(attributes, resource);
        }
        return null;
    }

    @Nullable
    private static String getLambdaArn(Attributes attributes, Resource resource) {
        String arn = (String)resource.getAttributes().get(CLOUD_RESOURCE_ID);
        if (arn != null) {
            return arn;
        }
        return (String)attributes.get(CLOUD_RESOURCE_ID);
    }

    @Nullable
    private static String getServiceType(Resource resource) {
        String cloudPlatform = (String)resource.getAttributes().get(CLOUD_PLATFORM);
        if (cloudPlatform == null) {
            return null;
        }
        return XRAY_CLOUD_PLATFORM.get(cloudPlatform);
    }

    private static Matcher toMatcher(String globPattern) {
        if (globPattern.equals("*")) {
            return TrueMatcher.INSTANCE;
        }
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c != '*' && c != '?') continue;
            return new PatternMatcher(SamplingRuleApplier.toRegexPattern(globPattern));
        }
        return new StringMatcher(globPattern);
    }

    private static Pattern toRegexPattern(String globPattern) {
        int tokenStart = -1;
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c == '*' || c == '?') {
                if (tokenStart != -1) {
                    patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart, i)));
                    tokenStart = -1;
                }
                if (c == '*') {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append(".");
                continue;
            }
            if (tokenStart != -1) continue;
            tokenStart = i;
        }
        if (tokenStart != -1) {
            patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart)));
        }
        return Pattern.compile(patternBuilder.toString());
    }

    private Sampler createRateLimited(int numPerSecond) {
        return new RateLimitingSampler(numPerSecond, this.clock);
    }

    private static Sampler createFixedRate(double rate) {
        return Sampler.traceIdRatioBased((double)rate);
    }

    static {
        HashMap<String, String> xrayCloudPlatform = new HashMap<String, String>();
        xrayCloudPlatform.put(AWS_EC2, "AWS::EC2::Instance");
        xrayCloudPlatform.put(AWS_ECS, "AWS::ECS::Container");
        xrayCloudPlatform.put(AWS_EKS, "AWS::EKS::Container");
        xrayCloudPlatform.put(AWS_ELASTIC_BEANSTALK, "AWS::ElasticBeanstalk::Environment");
        xrayCloudPlatform.put(AWS_LAMBDA, "AWS::Lambda::Function");
        XRAY_CLOUD_PLATFORM = Collections.unmodifiableMap(xrayCloudPlatform);
    }

    private static interface Matcher {
        public boolean matches(@Nullable String var1);
    }

    private static class Statistics {
        final LongAdder requests = new LongAdder();
        final LongAdder sampled = new LongAdder();
        final LongAdder borrowed = new LongAdder();

        private Statistics() {
        }
    }

    private static enum TrueMatcher implements Matcher
    {
        INSTANCE;


        @Override
        public boolean matches(@Nullable String s) {
            return true;
        }

        public String toString() {
            return "TrueMatcher";
        }
    }

    private static class PatternMatcher
    implements Matcher {
        private final Pattern pattern;

        PatternMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@Nullable String s) {
            if (s == null) {
                return false;
            }
            return this.pattern.matcher(s).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private static class StringMatcher
    implements Matcher {
        private final String target;

        StringMatcher(String target) {
            this.target = target;
        }

        @Override
        public boolean matches(@Nullable String s) {
            if (s == null) {
                return false;
            }
            return this.target.equalsIgnoreCase(s);
        }

        public String toString() {
            return this.target;
        }
    }
}

