/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.contrib.awsxray.AttributePropagatingSpanProcessor;
import io.opentelemetry.contrib.awsxray.AwsAttributeKeys;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AttributePropagatingSpanProcessorBuilder {
    private AttributeKey<String> spanNamePropagationKey = AwsAttributeKeys.AWS_LOCAL_OPERATION;
    private List<AttributeKey<String>> attributesKeysToPropagate = Arrays.asList(AwsAttributeKeys.AWS_REMOTE_SERVICE, AwsAttributeKeys.AWS_REMOTE_OPERATION);

    public static AttributePropagatingSpanProcessorBuilder create() {
        return new AttributePropagatingSpanProcessorBuilder();
    }

    private AttributePropagatingSpanProcessorBuilder() {
    }

    @CanIgnoreReturnValue
    public AttributePropagatingSpanProcessorBuilder setSpanNamePropagationKey(AttributeKey<String> spanNamePropagationKey) {
        Objects.requireNonNull(spanNamePropagationKey, "spanNamePropagationKey");
        this.spanNamePropagationKey = spanNamePropagationKey;
        return this;
    }

    @CanIgnoreReturnValue
    public AttributePropagatingSpanProcessorBuilder setAttributesKeysToPropagate(List<AttributeKey<String>> attributesKeysToPropagate) {
        Objects.requireNonNull(attributesKeysToPropagate, "attributesKeysToPropagate");
        this.attributesKeysToPropagate = Collections.unmodifiableList(attributesKeysToPropagate);
        return this;
    }

    public AttributePropagatingSpanProcessor build() {
        return AttributePropagatingSpanProcessor.create(this.spanNamePropagationKey, this.attributesKeysToPropagate);
    }
}

