/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.sdk.trace.IdGenerator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public final class AwsXrayIdGenerator
implements IdGenerator {
    private static final AwsXrayIdGenerator INSTANCE = new AwsXrayIdGenerator();
    private static final IdGenerator RANDOM_ID_GENERATOR = IdGenerator.random();

    public static AwsXrayIdGenerator getInstance() {
        return INSTANCE;
    }

    public String generateSpanId() {
        return RANDOM_ID_GENERATOR.generateSpanId();
    }

    public String generateTraceId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long timestampSecs = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long hiRandom = (long)((Random)random).nextInt() & 0xFFFFFFFFL;
        long lowRandom = ((Random)random).nextLong();
        return TraceId.fromLongs((long)(timestampSecs << 32 | hiRandom), (long)lowRandom);
    }

    private AwsXrayIdGenerator() {
    }
}

