/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.contrib.awsxray.AwsMetricAttributeGenerator;
import io.opentelemetry.contrib.awsxray.AwsSpanMetricsProcessor;
import io.opentelemetry.contrib.awsxray.MetricAttributeGenerator;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Objects;

public final class AwsSpanMetricsProcessorBuilder {
    private static final String ERROR = "Error";
    private static final String FAULT = "Fault";
    private static final String LATENCY = "Latency";
    private static final String LATENCY_UNITS = "Milliseconds";
    private static final MetricAttributeGenerator DEFAULT_GENERATOR = new AwsMetricAttributeGenerator();
    private static final String DEFAULT_SCOPE_NAME = "AwsSpanMetricsProcessor";
    private final MeterProvider meterProvider;
    private final Resource resource;
    private MetricAttributeGenerator generator = DEFAULT_GENERATOR;
    private String scopeName = "AwsSpanMetricsProcessor";

    public static AwsSpanMetricsProcessorBuilder create(MeterProvider meterProvider, Resource resource) {
        return new AwsSpanMetricsProcessorBuilder(meterProvider, resource);
    }

    private AwsSpanMetricsProcessorBuilder(MeterProvider meterProvider, Resource resource) {
        this.meterProvider = meterProvider;
        this.resource = resource;
    }

    @CanIgnoreReturnValue
    public AwsSpanMetricsProcessorBuilder setGenerator(MetricAttributeGenerator generator) {
        Objects.requireNonNull(generator, "generator");
        this.generator = generator;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSpanMetricsProcessorBuilder setScopeName(String scopeName) {
        Objects.requireNonNull(scopeName, "scopeName");
        this.scopeName = scopeName;
        return this;
    }

    public AwsSpanMetricsProcessor build() {
        Meter meter = this.meterProvider.get(this.scopeName);
        LongCounter errorCounter = meter.counterBuilder(ERROR).build();
        LongCounter faultCounter = meter.counterBuilder(FAULT).build();
        DoubleHistogram latencyHistogram = meter.histogramBuilder(LATENCY).setUnit(LATENCY_UNITS).build();
        return AwsSpanMetricsProcessor.create(errorCounter, faultCounter, latencyHistogram, this.generator, this.resource);
    }
}

