/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.MetricAttributeGenerator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AwsSpanMetricsProcessor
implements SpanProcessor {
    private static final double NANOS_TO_MILLIS = 1000000.0;
    private static final int ERROR_CODE_LOWER_BOUND = 400;
    private static final int ERROR_CODE_UPPER_BOUND = 499;
    private static final int FAULT_CODE_LOWER_BOUND = 500;
    private static final int FAULT_CODE_UPPER_BOUND = 599;
    private final LongCounter errorCounter;
    private final LongCounter faultCounter;
    private final DoubleHistogram latencyHistogram;
    private final MetricAttributeGenerator generator;
    private final Resource resource;

    static AwsSpanMetricsProcessor create(LongCounter errorCounter, LongCounter faultCounter, DoubleHistogram latencyHistogram, MetricAttributeGenerator generator, Resource resource) {
        return new AwsSpanMetricsProcessor(errorCounter, faultCounter, latencyHistogram, generator, resource);
    }

    private AwsSpanMetricsProcessor(LongCounter errorCounter, LongCounter faultCounter, DoubleHistogram latencyHistogram, MetricAttributeGenerator generator, Resource resource) {
        this.errorCounter = errorCounter;
        this.faultCounter = faultCounter;
        this.latencyHistogram = latencyHistogram;
        this.generator = generator;
        this.resource = resource;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    public boolean isStartRequired() {
        return false;
    }

    public void onEnd(ReadableSpan span) {
        SpanData spanData = span.toSpanData();
        Attributes attributes = this.generator.generateMetricAttributesFromSpan(spanData, this.resource);
        if (!attributes.isEmpty()) {
            this.recordErrorOrFault(span, attributes);
            this.recordLatency(span, attributes);
        }
    }

    public boolean isEndRequired() {
        return true;
    }

    private void recordErrorOrFault(ReadableSpan span, Attributes attributes) {
        Long httpStatusCode = (Long)span.getAttribute(SemanticAttributes.HTTP_STATUS_CODE);
        if (httpStatusCode == null) {
            return;
        }
        if (httpStatusCode >= 400L && httpStatusCode <= 499L) {
            this.errorCounter.add(1L, attributes);
        } else if (httpStatusCode >= 500L && httpStatusCode <= 599L) {
            this.faultCounter.add(1L, attributes);
        }
    }

    private void recordLatency(ReadableSpan span, Attributes attributes) {
        long nanos = span.getLatencyNanos();
        double millis = (double)nanos / 1000000.0;
        this.latencyHistogram.record(millis, attributes);
    }
}

