/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.awsxray.AwsAttributeKeys;
import io.opentelemetry.contrib.awsxray.MetricAttributeGenerator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AwsMetricAttributeGenerator
implements MetricAttributeGenerator {
    private static final Logger logger = Logger.getLogger(AwsMetricAttributeGenerator.class.getName());
    private static final String GRAPHQL = "graphql";
    private static final String UNKNOWN_SERVICE = "UnknownService";
    private static final String UNKNOWN_OPERATION = "UnknownOperation";
    private static final String UNKNOWN_REMOTE_SERVICE = "UnknownRemoteService";
    private static final String UNKNOWN_REMOTE_OPERATION = "UnknownRemoteOperation";

    AwsMetricAttributeGenerator() {
    }

    @Override
    public Attributes generateMetricAttributesFromSpan(SpanData span, Resource resource) {
        AttributesBuilder builder = Attributes.builder();
        switch (span.getKind()) {
            case CONSUMER: 
            case SERVER: {
                AwsMetricAttributeGenerator.setService(resource, span, builder);
                AwsMetricAttributeGenerator.setIngressOperation(span, builder);
                AwsMetricAttributeGenerator.setSpanKind(span, builder);
                break;
            }
            case PRODUCER: 
            case CLIENT: {
                AwsMetricAttributeGenerator.setService(resource, span, builder);
                AwsMetricAttributeGenerator.setEgressOperation(span, builder);
                AwsMetricAttributeGenerator.setRemoteServiceAndOperation(span, builder);
                AwsMetricAttributeGenerator.setSpanKind(span, builder);
                break;
            }
        }
        return builder.build();
    }

    private static void setService(Resource resource, SpanData span, AttributesBuilder builder) {
        String service = (String)resource.getAttribute(ResourceAttributes.SERVICE_NAME);
        if (service == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_SERVICE, span);
            service = UNKNOWN_SERVICE;
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_SERVICE, (Object)service);
    }

    private static void setIngressOperation(SpanData span, AttributesBuilder builder) {
        String operation = span.getName();
        if (operation == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_OPERATION, span);
            operation = UNKNOWN_OPERATION;
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_OPERATION, (Object)operation);
    }

    private static void setEgressOperation(SpanData span, AttributesBuilder builder) {
        String operation = (String)span.getAttributes().get(AwsAttributeKeys.AWS_LOCAL_OPERATION);
        if (operation == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_OPERATION, span);
            operation = UNKNOWN_OPERATION;
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_OPERATION, (Object)operation);
    }

    private static void setRemoteServiceAndOperation(SpanData span, AttributesBuilder builder) {
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_SERVICE) || AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_OPERATION)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, AwsAttributeKeys.AWS_REMOTE_SERVICE);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, AwsAttributeKeys.AWS_REMOTE_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.RPC_SERVICE) || AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.RPC_METHOD)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, (AttributeKey<String>)SemanticAttributes.RPC_SERVICE);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, (AttributeKey<String>)SemanticAttributes.RPC_METHOD);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.DB_SYSTEM) || AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.DB_OPERATION)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, (AttributeKey<String>)SemanticAttributes.DB_SYSTEM);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, (AttributeKey<String>)SemanticAttributes.DB_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.FAAS_INVOKED_PROVIDER) || AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.FAAS_INVOKED_NAME)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, (AttributeKey<String>)SemanticAttributes.FAAS_INVOKED_PROVIDER);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, (AttributeKey<String>)SemanticAttributes.FAAS_INVOKED_NAME);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.MESSAGING_SYSTEM) || AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.MESSAGING_OPERATION)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, (AttributeKey<String>)SemanticAttributes.MESSAGING_SYSTEM);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, (AttributeKey<String>)SemanticAttributes.MESSAGING_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.GRAPHQL_OPERATION_TYPE)) {
            builder.put(AwsAttributeKeys.AWS_REMOTE_SERVICE, (Object)GRAPHQL);
            AwsMetricAttributeGenerator.setRemoteOperation(span, builder, (AttributeKey<String>)SemanticAttributes.GRAPHQL_OPERATION_TYPE);
        } else {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_SERVICE, span);
            builder.put(AwsAttributeKeys.AWS_REMOTE_SERVICE, (Object)UNKNOWN_REMOTE_SERVICE);
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_OPERATION, span);
            builder.put(AwsAttributeKeys.AWS_REMOTE_OPERATION, (Object)UNKNOWN_REMOTE_OPERATION);
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, (AttributeKey<String>)SemanticAttributes.PEER_SERVICE) && !AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_SERVICE)) {
            AwsMetricAttributeGenerator.setRemoteService(span, builder, (AttributeKey<String>)SemanticAttributes.PEER_SERVICE);
        }
    }

    private static void setSpanKind(SpanData span, AttributesBuilder builder) {
        String spanKind = span.getKind().name();
        builder.put(AwsAttributeKeys.AWS_SPAN_KIND, (Object)spanKind);
    }

    private static boolean isKeyPresent(SpanData span, AttributeKey<String> key) {
        return span.getAttributes().get(key) != null;
    }

    private static void setRemoteService(SpanData span, AttributesBuilder builder, AttributeKey<String> remoteServiceKey) {
        String remoteService = (String)span.getAttributes().get(remoteServiceKey);
        if (remoteService == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_SERVICE, span);
            remoteService = UNKNOWN_REMOTE_SERVICE;
        }
        builder.put(AwsAttributeKeys.AWS_REMOTE_SERVICE, (Object)remoteService);
    }

    private static void setRemoteOperation(SpanData span, AttributesBuilder builder, AttributeKey<String> remoteOperationKey) {
        String remoteOperation = (String)span.getAttributes().get(remoteOperationKey);
        if (remoteOperation == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_OPERATION, span);
            remoteOperation = UNKNOWN_REMOTE_OPERATION;
        }
        builder.put(AwsAttributeKeys.AWS_REMOTE_OPERATION, (Object)remoteOperation);
    }

    private static void logUnknownAttribute(AttributeKey<String> attributeKey, SpanData span) {
        Object[] params = new String[]{attributeKey.getKey(), span.getKind().name(), span.getSpanContext().getSpanId()};
        logger.log(Level.FINEST, "No valid {0} value found for {1} span {2}", params);
    }
}

