/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.JaxRsRuntimeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.ReaderInputStream;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.DefaultMethod;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.ext.ProtocolHeaders;
import org.apache.cxf.jaxrs.ext.ProtocolHeadersImpl;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.impl.ContainerRequestContextImpl;
import org.apache.cxf.jaxrs.impl.ContainerResponseContextImpl;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MediaTypeHeaderProvider;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorContextImpl;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.impl.ResourceInfoImpl;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.impl.WriterInterceptorContextImpl;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.BeanResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfoComparator;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoComparator;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AccumulatingIntersector;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.MimeTypesIntersector;
import org.apache.cxf.jaxrs.utils.NonAccumulatingIntersector;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.codehaus.jackson.JsonParseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class JAXRSUtils {
    public static final MediaType ALL_TYPES = new MediaType();
    public static final String ROOT_RESOURCE_CLASS = "root.resource.class";
    public static final String IGNORE_MESSAGE_WRITERS = "ignore.message.writers";
    public static final String ROOT_INSTANCE = "service.root.instance";
    public static final String ROOT_PROVIDER = "service.root.provider";
    public static final String EXCEPTION_FROM_MAPPER = "exception.from.mapper";
    public static final String SECOND_JAXRS_EXCEPTION = "second.jaxrs.exception";
    public static final String PARTIAL_HIERARCHICAL_MEDIA_SUBTYPE_CHECK = "media.subtype.partial.check";
    public static final String DOC_LOCATION = "wadl.location";
    public static final String MEDIA_TYPE_Q_PARAM = "q";
    public static final String MEDIA_TYPE_QS_PARAM = "qs";
    private static final String MEDIA_TYPE_DISTANCE_PARAM = "d";
    private static final String DEFAULT_CONTENT_TYPE = "default.content.type";
    private static final String KEEP_SUBRESOURCE_CANDIDATES = "keep.subresource.candidates";
    private static final TraceComponent tc = Tr.register(JAXRSUtils.class, null, null);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSUtils.class);
    private static final String PATH_SEGMENT_SEP = "/";
    private static final String REPORT_FAULT_MESSAGE_PROPERTY = "org.apache.cxf.jaxrs.report-fault-message";
    private static final String NO_CONTENT_EXCEPTION = "javax.ws.rs.core.NoContentException";
    private static final String HTTP_CHARSET_PARAM = "charset";
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Set<Class<?>> STREAMING_OUT_TYPES = new HashSet<Class>(Arrays.asList(InputStream.class, Reader.class, StreamingOutput.class));
    static final long serialVersionUID = 8454000615860612307L;

    private JAXRSUtils() {
    }

    public static boolean isStreamingOutType(Class<?> type) {
        return STREAMING_OUT_TYPES.contains(type);
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode) {
        return JAXRSUtils.getPathSegments(thePath, decode, true);
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode, boolean ignoreLastSlash) {
        String[] segments = StringUtils.split(thePath, PATH_SEGMENT_SEP);
        ArrayList<PathSegment> theList = new ArrayList<PathSegment>();
        for (String path : segments) {
            if (StringUtils.isEmpty(path)) continue;
            theList.add(new PathSegmentImpl(path, decode));
        }
        int len = thePath.length();
        if (len > 0 && thePath.charAt(len - 1) == '/') {
            String value = ignoreLastSlash ? "" : PATH_SEGMENT_SEP;
            theList.add(new PathSegmentImpl(value, false));
        }
        return theList;
    }

    private static String[] getUserMediaTypes(Object provider, boolean consumes) {
        String[] values = null;
        if (AbstractConfigurableProvider.class.isAssignableFrom(provider.getClass())) {
            List<String> types = null;
            types = consumes ? ((AbstractConfigurableProvider)provider).getConsumeMediaTypes() : ((AbstractConfigurableProvider)provider).getProduceMediaTypes();
            if (types != null) {
                String[] stringArray;
                if (types.size() > 0) {
                    stringArray = types.toArray(new String[types.size()]);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*/*";
                }
                values = stringArray;
            }
        }
        return values;
    }

    public static List<MediaType> getProviderConsumeTypes(MessageBodyReader<?> provider) {
        String[] values = JAXRSUtils.getUserMediaTypes(provider, true);
        if (values == null) {
            return JAXRSUtils.getConsumeTypes(provider.getClass().getAnnotation(Consumes.class));
        }
        return JAXRSUtils.getMediaTypes(values);
    }

    public static List<MediaType> getProviderProduceTypes(MessageBodyWriter<?> provider) {
        String[] values = JAXRSUtils.getUserMediaTypes(provider, false);
        if (values == null) {
            return JAXRSUtils.getProduceTypes(provider.getClass().getAnnotation(Produces.class));
        }
        return JAXRSUtils.getMediaTypes(values);
    }

    public static List<MediaType> getMediaTypes(String[] values) {
        ArrayList<MediaType> supportedMimeTypes = new ArrayList<MediaType>(values.length);
        for (int i = 0; i < values.length; ++i) {
            supportedMimeTypes.addAll(JAXRSUtils.parseMediaTypes(values[i]));
        }
        return supportedMimeTypes;
    }

    public static void injectParameters(OperationResourceInfo ori, Object requestObject, Message message) {
        JAXRSUtils.injectParameters(ori, ori.getClassResourceInfo(), requestObject, message);
    }

    public static void injectParameters(OperationResourceInfo ori, BeanResourceInfo bri, Object requestObject, Message message) {
        Object o;
        Parameter p;
        if (bri.isSingleton() && (!bri.getParameterMethods().isEmpty() || !bri.getParameterFields().isEmpty()) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Injecting request parameters into singleton resource is not thread-safe", (Object[])new Object[0]);
        }
        MultivaluedMap values = (MultivaluedMap)message.get("jaxrs.template.parameters");
        for (Method m : bri.getParameterMethods()) {
            p = ResourceUtils.getParameter(0, m.getAnnotations(), m.getParameterTypes()[0]);
            o = p.getType() == ParameterType.BEAN ? JAXRSUtils.createBeanParamValue(message, m.getParameterTypes()[0], ori) : JAXRSUtils.createHttpParameterValue(p, m.getParameterTypes()[0], m.getGenericParameterTypes()[0], m.getParameterAnnotations()[0], message, (MultivaluedMap<String, String>)values, ori);
            InjectionUtils.injectThroughMethod(requestObject, m, o, message);
        }
        for (Field f : bri.getParameterFields()) {
            p = ResourceUtils.getParameter(0, f.getAnnotations(), f.getType());
            o = null;
            o = p.getType() == ParameterType.BEAN ? JAXRSUtils.createBeanParamValue(message, f.getType(), ori) : JAXRSUtils.createHttpParameterValue(p, f.getType(), f.getGenericType(), f.getAnnotations(), message, (MultivaluedMap<String, String>)values, ori);
            InjectionUtils.injectFieldValue(f, requestObject, o);
        }
    }

    public static Map<ClassResourceInfo, MultivaluedMap<String, String>> selectResourceClass(List<ClassResourceInfo> resources, String path, Message message) {
        boolean isFineLevelLoggable;
        boolean bl = isFineLevelLoggable = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (isFineLevelLoggable) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ClassResourceInfo classResourceInfo : resources) {
                stringBuilder.append(classResourceInfo.getResourceClass());
                stringBuilder.append(" , ");
            }
            String stringClassResourceInfo = stringBuilder.toString();
            Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("START_CRI_MATCH", BUNDLE, path + " All known ClassResourceInfo: " + (String)stringClassResourceInfo).toString(), (Object[])new Object[0]);
        }
        if (resources.size() == 1) {
            MetadataMap<String, String> values = new MetadataMap<String, String>();
            return resources.get(0).getURITemplate().match(path, values) ? Collections.singletonMap(resources.get(0), values) : null;
        }
        TreeMap<ClassResourceInfo, MetadataMap<String, String>> candidateList = new TreeMap<ClassResourceInfo, MetadataMap<String, String>>(new ClassResourceInfoComparator(message));
        for (ClassResourceInfo cri : resources) {
            MetadataMap<String, String> map = new MetadataMap<String, String>();
            if (cri.getURITemplate().match(path, map)) {
                candidateList.put(cri, map);
                if (!isFineLevelLoggable) continue;
                Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("CRI_SELECTED_POSSIBLY", BUNDLE, cri.getServiceClass().getName(), path, cri.getURITemplate().getValue()).toString(), (Object[])new Object[0]);
                continue;
            }
            if (!isFineLevelLoggable) continue;
            Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("CRI_NO_MATCH", BUNDLE, path, cri.getServiceClass().getName()).toString(), (Object[])new Object[0]);
        }
        if (!candidateList.isEmpty()) {
            LinkedHashMap<ClassResourceInfo, MultivaluedMap<String, String>> cris = new LinkedHashMap<ClassResourceInfo, MultivaluedMap<String, String>>(candidateList.size());
            ClassResourceInfo firstCri = null;
            for (Map.Entry entry : candidateList.entrySet()) {
                ClassResourceInfo cri = (ClassResourceInfo)entry.getKey();
                if (cris.isEmpty()) {
                    firstCri = cri;
                    cris.put(cri, (MultivaluedMap<String, String>)((MultivaluedMap)entry.getValue()));
                } else {
                    if (URITemplate.compareTemplates(firstCri.getURITemplate(), cri.getURITemplate()) != 0) break;
                    cris.put(cri, (MultivaluedMap<String, String>)((MultivaluedMap)entry.getValue()));
                }
                if (!isFineLevelLoggable) continue;
                Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("CRI_SELECTED", BUNDLE, cri.getServiceClass().getName(), path, cri.getURITemplate().getValue()).toString(), (Object[])new Object[0]);
            }
            return cris;
        }
        return null;
    }

    public static OperationResourceInfo findTargetMethod(Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources, Message message, String httpMethod, MultivaluedMap<String, String> matchedValues, String requestContentType, List<MediaType> acceptContentTypes) {
        return JAXRSUtils.findTargetMethod(matchedResources, message, httpMethod, matchedValues, requestContentType, acceptContentTypes, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static OperationResourceInfo findTargetMethod(Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources, Message message, String httpMethod, MultivaluedMap<String, String> matchedValues, String requestContentType, List<MediaType> acceptContentTypes, boolean throwException, boolean recordMatchedUri) {
        MediaType requestType;
        boolean isFineLevelLoggable = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        boolean getMethod = "GET".equals(httpMethod);
        try {
            requestType = JAXRSUtils.toMediaType(requestContentType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void ex;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"401", null, (Object[])new Object[]{matchedResources, message, httpMethod, matchedValues, requestContentType, acceptContentTypes, throwException, recordMatchedUri});
            throw ExceptionUtils.toNotSupportedException((Throwable)ex, null);
        }
        TreeMap<OperationResourceInfo, MetadataMap<String, String>> candidateList = new TreeMap<OperationResourceInfo, MetadataMap<String, String>>(new OperationResourceInfoComparator(message, httpMethod, getMethod, requestType, acceptContentTypes));
        int pathMatched = 0;
        int methodMatched = 0;
        int consumeMatched = 0;
        boolean resourceMethodsAdded = false;
        LinkedList<OperationResourceInfo> finalPathSubresources = null;
        for (Map.Entry<ClassResourceInfo, MultivaluedMap<String, String>> rEntry : matchedResources.entrySet()) {
            ClassResourceInfo resource = rEntry.getKey();
            MultivaluedMap<String, String> values = rEntry.getValue();
            String path = JAXRSUtils.getCurrentPath(values);
            if (isFineLevelLoggable) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("START_OPER_MATCH", BUNDLE, resource.getServiceClass().getName());
                Tr.debug((TraceComponent)tc, (String)msg.toString(), (Object[])new Object[0]);
            }
            for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
                boolean added = false;
                URITemplate uriTemplate = ori.getURITemplate();
                MetadataMap<String, String> map = new MetadataMap<String, String>((Map<String, List<String>>)values);
                if (uriTemplate != null && uriTemplate.match(path, map)) {
                    boolean finalPath;
                    String finalGroup = (String)map.getFirst("FINAL_MATCH_GROUP");
                    boolean bl = finalPath = StringUtils.isEmpty(finalGroup) || PATH_SEGMENT_SEP.equals(finalGroup);
                    if (ori.isSubResourceLocator()) {
                        candidateList.put(ori, map);
                        if (finalPath) {
                            if (finalPathSubresources == null) {
                                finalPathSubresources = new LinkedList<OperationResourceInfo>();
                            }
                            finalPathSubresources.add(ori);
                        }
                        added = true;
                    } else if (finalPath) {
                        ++pathMatched;
                        if (JAXRSUtils.matchHttpMethod(ori.getHttpMethod(), httpMethod)) {
                            ++methodMatched;
                            if (getMethod || JAXRSUtils.matchConsumeTypes(requestType, ori)) {
                                ++consumeMatched;
                                for (MediaType acceptType : acceptContentTypes) {
                                    if (!JAXRSUtils.matchProduceTypes(acceptType, ori)) continue;
                                    candidateList.put(ori, map);
                                    added = true;
                                    resourceMethodsAdded = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!isFineLevelLoggable) continue;
                if (added) {
                    Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("OPER_SELECTED_POSSIBLY", BUNDLE, ori.getMethodToInvoke().getName()).toString(), (Object[])new Object[0]);
                    continue;
                }
                JAXRSUtils.logNoMatchMessage(ori, path, httpMethod, requestType, acceptContentTypes);
            }
        }
        if (finalPathSubresources != null && resourceMethodsAdded && !MessageUtils.getContextualBoolean(message, KEEP_SUBRESOURCE_CANDIDATES, false)) {
            for (OperationResourceInfo key : finalPathSubresources) {
                candidateList.remove(key);
            }
        }
        if (!candidateList.isEmpty()) {
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            matchedValues.clear();
            matchedValues.putAll((Map)firstEntry.getValue());
            OperationResourceInfo ori = (OperationResourceInfo)firstEntry.getKey();
            if (JAXRSUtils.headMethodPossible(ori.getHttpMethod(), httpMethod)) {
                Tr.info((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("GET_INSTEAD_OF_HEAD", BUNDLE, ori.getClassResourceInfo().getServiceClass().getName(), ori.getMethodToInvoke().getName()).toString(), (Object[])new Object[0]);
            }
            if (isFineLevelLoggable) {
                Tr.debug((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("OPER_SELECTED", BUNDLE, ori.getMethodToInvoke().getName(), ori.getClassResourceInfo().getServiceClass().getName()).toString(), (Object[])new Object[0]);
            }
            if (!ori.isSubResourceLocator()) {
                MediaType responseMediaType = JAXRSUtils.intersectSortMediaTypes(acceptContentTypes, ori.getProduceTypes(), false).get(0);
                message.getExchange().put("Content-Type", JAXRSUtils.mediaTypeToString(responseMediaType, MEDIA_TYPE_Q_PARAM, MEDIA_TYPE_QS_PARAM));
            }
            if (recordMatchedUri) {
                JAXRSUtils.pushOntoStack(ori, matchedValues, message);
            }
            return ori;
        }
        if (!throwException) {
            return null;
        }
        int status = pathMatched == 0 ? 404 : (methodMatched == 0 ? 405 : (consumeMatched == 0 ? 415 : 406));
        Map.Entry<ClassResourceInfo, MultivaluedMap<String, String>> firstCri = matchedResources.entrySet().iterator().next();
        String name = firstCri.getKey().isRoot() ? "NO_OP_EXC" : "NO_SUBRESOURCE_METHOD_FOUND";
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, message.get("org.apache.cxf.request.uri"), JAXRSUtils.getCurrentPath(firstCri.getValue()), httpMethod, JAXRSUtils.mediaTypeToString(requestType, new String[0]), JAXRSUtils.convertTypesToString(acceptContentTypes));
        if (!"OPTIONS".equalsIgnoreCase(httpMethod)) {
            Tr.warning((TraceComponent)tc, (String)errorMsg.toString(), (Object[])new Object[0]);
        }
        Response response = JAXRSUtils.createResponse(JAXRSUtils.getRootResources(message), message, errorMsg.toString(), status, methodMatched == 0);
        throw ExceptionUtils.toHttpException(null, response);
    }

    public static Level getExceptionLogLevel(Message message, Class<? extends WebApplicationException> exClass) {
        Level logLevel = null;
        Object logLevelProp = message.get(exClass.getName() + ".log.level");
        if (logLevelProp != null) {
            if (logLevelProp instanceof Level) {
                logLevel = (Level)logLevelProp;
            } else {
                try {
                    logLevel = Level.parse(logLevelProp.toString());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"564", null, (Object[])new Object[]{message, exClass});
                }
            }
        }
        return logLevel;
    }

    private static List<MediaType> intersectSortMediaTypes(List<MediaType> acceptTypes, List<MediaType> producesTypes, final boolean checkDistance) {
        List<MediaType> all = JAXRSUtils.intersectMimeTypes(acceptTypes, producesTypes, true, checkDistance);
        if (all.size() > 1) {
            Collections.sort(all, new Comparator<MediaType>(){
                static final long serialVersionUID = -3569500495208860397L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    int result = JAXRSUtils.compareMediaTypes(mt1, mt2, null);
                    if (result == 0) {
                        result = JAXRSUtils.compareQualityAndDistance(mt1, mt2, checkDistance);
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.JAXRSUtils$1", 1.class, null, null);
                }
            });
        }
        return all;
    }

    private static int compareQualityAndDistance(MediaType mt1, MediaType mt2, boolean checkDistance) {
        int result = JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2, MEDIA_TYPE_Q_PARAM);
        if (result == 0) {
            result = JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2, MEDIA_TYPE_QS_PARAM);
        }
        if (result == 0 && checkDistance) {
            Integer dist1 = Integer.valueOf((String)mt1.getParameters().get(MEDIA_TYPE_DISTANCE_PARAM));
            Integer dist2 = Integer.valueOf((String)mt2.getParameters().get(MEDIA_TYPE_DISTANCE_PARAM));
            result = dist1.compareTo(dist2);
        }
        return result;
    }

    private static String getCurrentPath(MultivaluedMap<String, String> values) {
        String path = (String)values.getFirst((Object)"FINAL_MATCH_GROUP");
        return path == null ? PATH_SEGMENT_SEP : path;
    }

    public static List<ClassResourceInfo> getRootResources(Message message) {
        Service service = message.getExchange().getService();
        return ((JAXRSServiceImpl)service).getClassResourceInfos();
    }

    public static boolean noResourceMethodForOptions(Response exResponse, String httpMethod) {
        return exResponse != null && exResponse.getStatus() == 405 && "OPTIONS".equalsIgnoreCase(httpMethod);
    }

    private static void logNoMatchMessage(OperationResourceInfo ori, String path, String httpMethod, MediaType requestType, List<MediaType> acceptContentTypes) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("OPER_NO_MATCH", BUNDLE, ori.getMethodToInvoke().getName(), path, ori.getURITemplate().getValue(), httpMethod, ori.getHttpMethod(), requestType.toString(), JAXRSUtils.convertTypesToString(ori.getConsumeTypes()), JAXRSUtils.convertTypesToString(acceptContentTypes), JAXRSUtils.convertTypesToString(ori.getProduceTypes()));
        Tr.debug((TraceComponent)tc, (String)errorMsg.toString(), (Object[])new Object[0]);
    }

    public static Response createResponse(List<ClassResourceInfo> cris, Message msg, String responseMessage, int status, boolean addAllow) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(status);
        if (addAllow) {
            Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources = null;
            HashSet<String> allowedMethods = new HashSet<String>();
            for (ClassResourceInfo cri : cris) {
                if (cri.getParent() != null) {
                    allowedMethods.addAll(cri.getAllowedMethods());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Adding All Allowed Headers " + cri.getAllowedMethods()), (Object[])new Object[0]);
                    break;
                }
                for (OperationResourceInfo ori : cri.getMethodDispatcher().getOperationResourceInfos()) {
                    MultivaluedMap values;
                    if (ori.isSubResourceLocator()) continue;
                    if (matchedResources == null) {
                        String messagePath = HttpUtils.getPathToMatch(msg, true);
                        matchedResources = JAXRSUtils.selectResourceClass(cris, messagePath, msg);
                    }
                    if ((values = (MultivaluedMap)matchedResources.get(cri)) == null) continue;
                    String httpMethod = ori.getHttpMethod();
                    if (!JAXRSUtils.isFinalPath(ori, (MultivaluedMap<String, String>)values) || !JAXRSUtils.matchHttpMethod(httpMethod, "*")) continue;
                    allowedMethods.add(httpMethod);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Adding Allow Header " + httpMethod), (Object[])new Object[0]);
                }
            }
            for (String m : allowedMethods) {
                rb.header("Allow", (Object)m);
            }
            if (!allowedMethods.contains("OPTIONS")) {
                rb.header("Allow", (Object)"OPTIONS");
            }
            if (!allowedMethods.contains("HEAD") && allowedMethods.contains("GET")) {
                rb.header("Allow", (Object)"HEAD");
            }
        }
        if (msg != null && MessageUtils.isTrue(msg.getContextualProperty(REPORT_FAULT_MESSAGE_PROPERTY))) {
            rb.type(MediaType.TEXT_PLAIN_TYPE).entity((Object)responseMessage);
        }
        return rb.build();
    }

    private static boolean matchHttpMethod(String expectedMethod, String httpMethod) {
        if ("*".equals(httpMethod)) {
            return true;
        }
        return expectedMethod.equalsIgnoreCase(httpMethod) || JAXRSUtils.headMethodPossible(expectedMethod, httpMethod) || expectedMethod.equals(DefaultMethod.class.getSimpleName());
    }

    private static boolean isFinalPath(OperationResourceInfo ori, MultivaluedMap<String, String> values) {
        boolean finalPath = false;
        String path = JAXRSUtils.getCurrentPath(values);
        URITemplate uriTemplate = ori.getURITemplate();
        MetadataMap<String, String> map = new MetadataMap<String, String>((Map<String, List<String>>)values);
        if (uriTemplate != null && uriTemplate.match(path, map)) {
            String finalGroup = (String)map.getFirst("FINAL_MATCH_GROUP");
            finalPath = StringUtils.isEmpty(finalGroup) || PATH_SEGMENT_SEP.equals(finalGroup);
        }
        return finalPath;
    }

    public static boolean headMethodPossible(String expectedMethod, String httpMethod) {
        return "HEAD".equalsIgnoreCase(httpMethod) && "GET".equals(expectedMethod);
    }

    private static String convertTypesToString(List<MediaType> types) {
        StringBuilder sb = new StringBuilder();
        for (MediaType type : types) {
            sb.append(JAXRSUtils.mediaTypeToString(type, new String[0])).append(',');
        }
        return sb.toString();
    }

    public static List<MediaType> getConsumeTypes(Consumes cm) {
        return cm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(cm.value());
    }

    public static List<MediaType> getProduceTypes(Produces pm) {
        return pm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(pm.value());
    }

    public static int compareSortedConsumesMediaTypes(List<MediaType> mts1, List<MediaType> mts2, MediaType ct) {
        List<MediaType> actualMts1 = JAXRSUtils.getCompatibleMediaTypes(mts1, ct);
        List<MediaType> actualMts2 = JAXRSUtils.getCompatibleMediaTypes(mts2, ct);
        return JAXRSUtils.compareSortedMediaTypes(actualMts1, actualMts2, null);
    }

    public static int compareSortedAcceptMediaTypes(List<MediaType> mts1, List<MediaType> mts2, List<MediaType> acceptTypes) {
        List<MediaType> actualMts1 = JAXRSUtils.intersectSortMediaTypes(mts1, acceptTypes, true);
        List<MediaType> actualMts2 = JAXRSUtils.intersectSortMediaTypes(mts2, acceptTypes, true);
        int size1 = actualMts1.size();
        int size2 = actualMts2.size();
        for (int i = 0; i < size1 && i < size2; ++i) {
            int result = JAXRSUtils.compareMediaTypes(actualMts1.get(i), actualMts2.get(i), null);
            if (result == 0) {
                result = JAXRSUtils.compareQualityAndDistance(actualMts1.get(i), actualMts2.get(i), true);
            }
            if (result == 0) continue;
            return result;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    private static List<MediaType> getCompatibleMediaTypes(List<MediaType> mts, MediaType ct) {
        List<MediaType> actualMts;
        if (mts.size() == 1) {
            actualMts = mts;
        } else {
            actualMts = new LinkedList<MediaType>();
            for (MediaType mt : mts) {
                if (!JAXRSUtils.isMediaTypeCompatible(mt, ct)) continue;
                actualMts.add(mt);
            }
        }
        return actualMts;
    }

    public static int compareSortedMediaTypes(List<MediaType> mts1, List<MediaType> mts2, String qs) {
        int size1 = mts1.size();
        int size2 = mts2.size();
        for (int i = 0; i < size1 && i < size2; ++i) {
            int result = JAXRSUtils.compareMediaTypes(mts1.get(i), mts2.get(i), qs);
            if (result == 0) continue;
            return result;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    public static int compareMediaTypes(MediaType mt1, MediaType mt2) {
        return JAXRSUtils.compareMediaTypes(mt1, mt2, MEDIA_TYPE_Q_PARAM);
    }

    public static int compareMediaTypes(MediaType mt1, MediaType mt2, String qs) {
        boolean mt1TypeWildcard = mt1.isWildcardType();
        boolean mt2TypeWildcard = mt2.isWildcardType();
        if (mt1TypeWildcard && !mt2TypeWildcard) {
            return 1;
        }
        if (!mt1TypeWildcard && mt2TypeWildcard) {
            return -1;
        }
        boolean mt1SubTypeWildcard = mt1.getSubtype().contains("*");
        boolean mt2SubTypeWildcard = mt2.getSubtype().contains("*");
        if (mt1SubTypeWildcard && !mt2SubTypeWildcard) {
            return 1;
        }
        if (!mt1SubTypeWildcard && mt2SubTypeWildcard) {
            return -1;
        }
        return qs != null ? JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2, qs) : 0;
    }

    public static int compareMediaTypesQualityFactors(MediaType mt1, MediaType mt2) {
        float q1 = JAXRSUtils.getMediaTypeQualityFactor((String)mt1.getParameters().get(MEDIA_TYPE_Q_PARAM));
        float q2 = JAXRSUtils.getMediaTypeQualityFactor((String)mt2.getParameters().get(MEDIA_TYPE_Q_PARAM));
        return Float.compare(q1, q2) * -1;
    }

    public static int compareMediaTypesQualityFactors(MediaType mt1, MediaType mt2, String qs) {
        float q1 = JAXRSUtils.getMediaTypeQualityFactor((String)mt1.getParameters().get(qs));
        float q2 = JAXRSUtils.getMediaTypeQualityFactor((String)mt2.getParameters().get(qs));
        return Float.compare(q1, q2) * -1;
    }

    public static float getMediaTypeQualityFactor(String q) {
        if (q == null) {
            return 1.0f;
        }
        if (q.charAt(0) == '.') {
            q = '0' + q;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"863", null, (Object[])new Object[]{q});
            return 1.0f;
        }
    }

    public static List<Object> processParameters(OperationResourceInfo ori, MultivaluedMap<String, String> values, Message message) throws IOException, WebApplicationException {
        Class<?>[] parameterTypes = ori.getInParameterTypes();
        List<Parameter> paramsInfo = ori.getParameters();
        boolean preferModelParams = paramsInfo.size() > parameterTypes.length && !PropertyUtils.isTrue(message.getContextualProperty("org.apache.cxf.preferMethodParameters"));
        int parameterTypesLengh = preferModelParams ? paramsInfo.size() : parameterTypes.length;
        Type[] genericParameterTypes = ori.getInGenericParameterTypes();
        Annotation[][] anns = ori.getInParameterAnnotations();
        ArrayList<Object> params = new ArrayList<Object>(parameterTypesLengh);
        for (int i = 0; i < parameterTypesLengh; ++i) {
            Class<?> param = null;
            Type genericParam = null;
            Annotation[] paramAnns = null;
            if (!preferModelParams) {
                param = parameterTypes[i];
                genericParam = InjectionUtils.processGenericTypeIfNeeded(ori.getClassResourceInfo().getServiceClass(), param, genericParameterTypes[i]);
                param = InjectionUtils.updateParamClassToTypeIfNeeded(param, genericParam);
                paramAnns = anns == null ? EMPTY_ANNOTATIONS : anns[i];
            } else {
                genericParam = param = paramsInfo.get(i).getJavaType();
                paramAnns = EMPTY_ANNOTATIONS;
            }
            Object paramValue = JAXRSUtils.processParameter(param, genericParam, paramAnns, paramsInfo.get(i), values, message, ori);
            params.add(paramValue);
        }
        return params;
    }

    private static Object processParameter(Class<?> parameterClass, Type parameterType, Annotation[] parameterAnns, Parameter parameter, MultivaluedMap<String, String> values, Message message, OperationResourceInfo ori) throws IOException, WebApplicationException {
        if (parameter.getType() == ParameterType.REQUEST_BODY) {
            Reader reader;
            MessageContextImpl mc;
            MediaType mt;
            InputStream is;
            if (parameterClass == AsyncResponse.class) {
                return new AsyncResponseImpl(message);
            }
            String contentType = (String)message.get("Content-Type");
            if (contentType == null) {
                String defaultCt = (String)message.getContextualProperty(DEFAULT_CONTENT_TYPE);
                contentType = defaultCt == null ? "application/octet-stream" : defaultCt;
            }
            if ((is = (mt = (mc = new MessageContextImpl(message)).getHttpHeaders().getMediaType()) == null || mt.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE) ? JAXRSUtils.copyAndGetEntityStream(message) : message.getContent(InputStream.class)) == null && (reader = message.getContent(Reader.class)) != null) {
                is = new ReaderInputStream(reader);
            }
            return JAXRSUtils.readFromMessageBody(parameterClass, parameterType, parameterAnns, is, JAXRSUtils.toMediaType(contentType), ori, message);
        }
        if (parameter.getType() == ParameterType.CONTEXT) {
            return JAXRSUtils.createContextValue(message, parameterType, parameterClass);
        }
        if (parameter.getType() == ParameterType.BEAN) {
            return JAXRSUtils.createBeanParamValue(message, parameterClass, ori);
        }
        return JAXRSUtils.createHttpParameterValue(parameter, parameterClass, parameterType, parameterAnns, message, values, ori);
    }

    public static Object createHttpParameterValue(Parameter parameter, Class<?> parameterClass, Type genericParam, Annotation[] paramAnns, Message message, MultivaluedMap<String, String> values, OperationResourceInfo ori) {
        boolean isEncoded = parameter.isEncoded() || ori != null && ori.isEncodedEnabled();
        String defaultValue = parameter.getDefaultValue();
        if (defaultValue == null && ori != null) {
            defaultValue = ori.getDefaultParameterValue();
        }
        if (parameter.getType() == ParameterType.PATH) {
            return JAXRSUtils.readFromUriParam(message, parameter.getName(), parameterClass, genericParam, paramAnns, values, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.QUERY) {
            return JAXRSUtils.readQueryString(parameter.getName(), parameterClass, genericParam, paramAnns, message, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.MATRIX) {
            return JAXRSUtils.processMatrixParam(message, parameter.getName(), parameterClass, genericParam, paramAnns, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.FORM) {
            return JAXRSUtils.processFormParam(message, parameter.getName(), parameterClass, genericParam, paramAnns, defaultValue, !isEncoded);
        }
        if (parameter.getType() == ParameterType.COOKIE) {
            return JAXRSUtils.processCookieParam(message, parameter.getName(), parameterClass, genericParam, paramAnns, defaultValue);
        }
        Object result = null;
        if (parameter.getType() == ParameterType.HEADER) {
            result = JAXRSUtils.processHeaderParam(message, parameter.getName(), parameterClass, genericParam, paramAnns, defaultValue);
        }
        return result;
    }

    private static Object processMatrixParam(Message m, String key, Class<?> pClass, Type genericType, Annotation[] paramAnns, String defaultValue, boolean decode) {
        List<PathSegment> segments = JAXRSUtils.getPathSegments((String)m.get("org.apache.cxf.request.uri"), decode);
        if (segments.size() > 0) {
            MetadataMap<String, String> params = new MetadataMap<String, String>();
            for (PathSegment ps : segments) {
                MultivaluedMap matrix = ps.getMatrixParameters();
                for (Map.Entry entry : matrix.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        params.add((String)entry.getKey(), value);
                    }
                }
            }
            if ("".equals(key)) {
                return InjectionUtils.handleBean(pClass, paramAnns, params, ParameterType.MATRIX, m, false);
            }
            List values = (List)params.get(key);
            return InjectionUtils.createParameterObject(values, pClass, genericType, paramAnns, defaultValue, false, ParameterType.MATRIX, m);
        }
        return null;
    }

    private static Object processFormParam(Message m, String key, Class<?> pClass, Type genericType, Annotation[] paramAnns, String defaultValue, boolean decode) {
        MessageContextImpl mc = new MessageContextImpl(m);
        MediaType mt = mc.getHttpHeaders().getMediaType();
        MetadataMap<String, String> params = (MetadataMap<String, String>)m.get("org.apache.cxf.form_data");
        if (params == null) {
            params = new MetadataMap<String, String>();
            m.put("org.apache.cxf.form_data", params);
            if (mt == null || mt.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                InputStream entityStream = JAXRSUtils.copyAndGetEntityStream(m);
                String enc = HttpUtils.getEncoding(mt, StandardCharsets.UTF_8.name());
                String body = FormUtils.readBody(entityStream, enc);
                FormUtils.populateMapFromStringOrHttpRequest(params, m, body, enc, decode);
            } else if ("multipart".equalsIgnoreCase(mt.getType()) && MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mt)) {
                MultipartBody body = AttachmentUtils.getMultipartBody(mc);
                FormUtils.populateMapFromMultipart(params, body, m, decode);
            } else {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("WRONG_FORM_MEDIA_TYPE", BUNDLE, mt.toString());
                Tr.warning((TraceComponent)tc, (String)errorMsg.toString(), (Object[])new Object[0]);
                throw ExceptionUtils.toNotSupportedException(null, null);
            }
        }
        if ("".equals(key)) {
            return InjectionUtils.handleBean(pClass, paramAnns, params, ParameterType.FORM, m, false);
        }
        List results = (List)params.get(key);
        return InjectionUtils.createParameterObject(results, pClass, genericType, paramAnns, defaultValue, false, ParameterType.FORM, m);
    }

    public static MultivaluedMap<String, String> getMatrixParams(String path, boolean decode) {
        int index = path.indexOf(59);
        return index == -1 ? new MetadataMap<String, String>() : JAXRSUtils.getStructuredParams(path.substring(index + 1), ";", decode, false);
    }

    private static Object processHeaderParam(Message m, String header, Class<?> pClass, Type genericType, Annotation[] paramAnns, String defaultValue) {
        List<String> values = new HttpHeadersImpl(m).getRequestHeader(header);
        if (values != null && values.isEmpty()) {
            values = null;
        }
        return InjectionUtils.createParameterObject(values, pClass, genericType, paramAnns, defaultValue, false, ParameterType.HEADER, m);
    }

    private static Object processCookieParam(Message m, String cookieName, Class<?> pClass, Type genericType, Annotation[] paramAnns, String defaultValue) {
        Cookie c = new HttpHeadersImpl(m).getCookies().get(cookieName);
        if (c == null && defaultValue != null) {
            c = Cookie.valueOf((String)(cookieName + '=' + defaultValue));
        }
        if (c == null) {
            return null;
        }
        if (pClass.isAssignableFrom(Cookie.class)) {
            return c;
        }
        String value = InjectionUtils.isSupportedCollectionOrArray(pClass) && InjectionUtils.getActualType(genericType) == Cookie.class ? c.toString() : c.getValue();
        return InjectionUtils.createParameterObject(Collections.singletonList(value), pClass, genericType, paramAnns, null, false, ParameterType.COOKIE, m);
    }

    /*
     * WARNING - void declaration
     */
    public static Object createBeanParamValue(Message m, Class<?> clazz, OperationResourceInfo ori) {
        Object instance;
        BeanParamInfo bmi = ServerProviderFactory.getInstance(m).getBeanParamInfo(clazz);
        if (bmi == null) {
            Tr.warning((TraceComponent)tc, (String)"Bean parameter info is not available", (Object[])new Object[0]);
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        try {
            instance = clazz.newInstance();
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"1184", null, (Object[])new Object[]{m, clazz, ori});
            throw ExceptionUtils.toInternalServerErrorException((Throwable)t, null);
        }
        JAXRSUtils.injectParameters(ori, bmi, instance, m);
        InjectionUtils.injectContexts(instance, bmi, m);
        return instance;
    }

    public static Message getContextMessage(Message m) {
        Message contextMessage;
        Message message = contextMessage = m.getExchange() != null ? m.getExchange().getInMessage() : m;
        if (contextMessage == null && !PropertyUtils.isTrue(m.get("org.apache.cxf.message.inbound"))) {
            contextMessage = m;
        }
        return contextMessage;
    }

    public static <T> T createContextValue(Message m, Type genericType, Class<T> clazz) {
        ContextProvider provider;
        Message contextMessage = JAXRSUtils.getContextMessage(m);
        Object o = null;
        if (UriInfo.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createUriInfo(contextMessage);
        } else if (HttpHeaders.class.isAssignableFrom(clazz) || ProtocolHeaders.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createHttpHeaders(contextMessage, clazz);
        } else if (SecurityContext.class.isAssignableFrom(clazz)) {
            SecurityContext customContext = contextMessage.get(SecurityContext.class);
            o = customContext == null ? new SecurityContextImpl(contextMessage) : customContext;
        } else if (MessageContext.class.isAssignableFrom(clazz)) {
            o = new MessageContextImpl(m);
        } else if (ResourceInfo.class.isAssignableFrom(clazz)) {
            o = new ResourceInfoImpl(contextMessage);
        } else if (ResourceContext.class.isAssignableFrom(clazz)) {
            OperationResourceInfo operationResourceInfo = contextMessage.getExchange().get(OperationResourceInfo.class);
            if (operationResourceInfo != null) {
                o = new ResourceContextImpl(contextMessage, operationResourceInfo);
            }
        } else if (Request.class.isAssignableFrom(clazz)) {
            o = new RequestImpl(contextMessage);
        } else if (Providers.class.isAssignableFrom(clazz)) {
            o = new ProvidersImpl(contextMessage);
        } else if (ContextResolver.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createContextResolver(genericType, contextMessage);
        } else if (Configuration.class.isAssignableFrom(clazz)) {
            o = ProviderFactory.getInstance(contextMessage).getConfiguration(contextMessage);
        } else if (Application.class.isAssignableFrom(clazz)) {
            ProviderInfo providerInfo = (ProviderInfo)contextMessage.getExchange().getEndpoint().get(Application.class.getName());
            o = providerInfo == null ? null : providerInfo.getProvider();
        } else if (contextMessage != null && (provider = ProviderFactory.getInstance(contextMessage).createContextProvider(clazz, contextMessage)) != null) {
            o = provider.createContext(contextMessage);
        }
        if (o == null && contextMessage != null && !MessageUtils.isRequestor(contextMessage)) {
            o = HttpUtils.createServletResourceValue(contextMessage, clazz);
        }
        return clazz.cast(o);
    }

    private static UriInfo createUriInfo(Message m) {
        if (MessageUtils.isRequestor(m)) {
            m = m.getExchange() != null ? m.getExchange().getOutMessage() : m;
        }
        MultivaluedMap templateParams = (MultivaluedMap)m.get("jaxrs.template.parameters");
        return new UriInfoImpl(m, (MultivaluedMap<String, String>)templateParams);
    }

    private static Object createHttpHeaders(Message m, Class<?> ctxClass) {
        if (MessageUtils.isRequestor(m)) {
            m = m.getExchange() != null ? m.getExchange().getOutMessage() : m;
        }
        return HttpHeaders.class.isAssignableFrom(ctxClass) ? new HttpHeadersImpl(m) : new ProtocolHeadersImpl(m);
    }

    public static ContextResolver<?> createContextResolver(Type genericType, Message m) {
        if (genericType instanceof ParameterizedType) {
            return ProviderFactory.getInstance(m).createContextResolver(((ParameterizedType)genericType).getActualTypeArguments()[0], m);
        }
        if (m != null) {
            return ProviderFactory.getInstance(m).createContextResolver(genericType, m);
        }
        return null;
    }

    public static Object createResourceValue(Message m, Type genericType, Class<?> clazz) {
        return JAXRSUtils.createContextValue(m, genericType, clazz);
    }

    private static Object readFromUriParam(Message m, String parameterName, Class<?> paramType, Type genericType, Annotation[] paramAnns, MultivaluedMap<String, String> values, String defaultValue, boolean decoded) {
        if ("".equals(parameterName)) {
            return InjectionUtils.handleBean(paramType, paramAnns, values, ParameterType.PATH, m, decoded);
        }
        List results = (List)values.get((Object)parameterName);
        return InjectionUtils.createParameterObject(results, paramType, genericType, paramAnns, defaultValue, decoded, ParameterType.PATH, m);
    }

    private static Object readQueryString(String queryName, Class<?> paramType, Type genericType, Annotation[] paramAnns, Message m, String defaultValue, boolean decode) {
        MultivaluedMap<String, String> queryMap = new UriInfoImpl(m, null).getQueryParameters(decode);
        if ("".equals(queryName)) {
            return InjectionUtils.handleBean(paramType, paramAnns, queryMap, ParameterType.QUERY, m, false);
        }
        return InjectionUtils.createParameterObject((List)queryMap.get((Object)queryName), paramType, genericType, paramAnns, defaultValue, false, ParameterType.QUERY, m);
    }

    public static MultivaluedMap<String, String> getStructuredParams(String query, String sep, boolean decode, boolean decodePlus) {
        MetadataMap<String, String> map = new MetadataMap<String, String>(new LinkedHashMap());
        JAXRSUtils.getStructuredParams(map, query, sep, decode, decodePlus);
        return map;
    }

    public static void getStructuredParams(MultivaluedMap<String, String> queries, String query, String sep, boolean decode, boolean decodePlus) {
        JAXRSUtils.getStructuredParams(queries, query, sep, decode, decodePlus, false);
    }

    public static void getStructuredParams(MultivaluedMap<String, String> queries, String query, String sep, boolean decode, boolean decodePlus, boolean valueIsCollection) {
        if (!StringUtils.isEmpty(query)) {
            List<String> parts = Arrays.asList(StringUtils.split(query, sep));
            for (String part : parts) {
                String name;
                int index = part.indexOf(61);
                String value = null;
                if (index == -1) {
                    name = part;
                } else {
                    name = part.substring(0, index);
                    String string = value = index < part.length() ? part.substring(index + 1) : "";
                }
                if (valueIsCollection) {
                    for (String s : value.split(",")) {
                        JAXRSUtils.addStructuredPartToMap(queries, sep, name, s, decode, decodePlus);
                    }
                    continue;
                }
                JAXRSUtils.addStructuredPartToMap(queries, sep, name, value, decode, decodePlus);
            }
        }
    }

    private static void addStructuredPartToMap(MultivaluedMap<String, String> queries, String sep, String name, String value, boolean decode, boolean decodePlus) {
        if (value != null) {
            if (decodePlus && value.contains("+")) {
                value = value.replace('+', ' ');
            }
            if (decode) {
                value = ";".equals(sep) ? HttpUtils.pathDecode(value) : HttpUtils.urlDecode(value);
            }
        }
        queries.add((Object)HttpUtils.urlDecode(name), (Object)value);
    }

    @FFDCIgnore(value={IOException.class, WebApplicationException.class, Exception.class})
    private static Object readFromMessageBody(Class<?> targetTypeClass, Type parameterType, Annotation[] parameterAnnotations, InputStream is, MediaType contentType, OperationResourceInfo ori, Message m) throws IOException, WebApplicationException {
        List<MediaType> types = JAXRSUtils.intersectMimeTypes(ori.getConsumeTypes(), contentType);
        ServerProviderFactory pf = ServerProviderFactory.getInstance(m);
        for (MediaType type : types) {
            List<ReaderInterceptor> readers = pf.createMessageBodyReaderInterceptor(targetTypeClass, parameterType, parameterAnnotations, type, m, true, ori.getNameBindings());
            if (readers == null) continue;
            try {
                return JAXRSUtils.readFromMessageBodyReader(readers, targetTypeClass, parameterType, parameterAnnotations, is, type, m);
            }
            catch (IOException e) {
                if (e.getClass().getName().equals(NO_CONTENT_EXCEPTION)) {
                    throw ExceptionUtils.toBadRequestException(e, null);
                }
                throw e;
            }
            catch (WebApplicationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
        JAXRSUtils.logMessageHandlerProblem("NO_MSG_READER", targetTypeClass, contentType);
        throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static Object readFromMessageBodyReader(List<ReaderInterceptor> readers, Class<?> targetTypeClass, final Type parameterType, final Annotation[] parameterAnnotations, final InputStream is, final MediaType mediaType, final Message m) throws IOException, WebApplicationException {
        if (readers.size() > 1) {
            ReaderInterceptor first = readers.remove(0);
            ReaderInterceptorContextImpl context = new ReaderInterceptorContextImpl(targetTypeClass, parameterType, parameterAnnotations, is, m, readers);
            return first.aroundReadFrom((ReaderInterceptorContext)context);
        }
        final MessageBodyReader<?> provider = ((ReaderInterceptorMBR)readers.get(0)).getMBR();
        final Class<?> cls = targetTypeClass;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -679897140565915138L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws IOException, WebApplicationException {
                    return provider.readFrom(cls, parameterType, parameterAnnotations, mediaType, new HttpHeadersImpl(m).getRequestHeaders(), is);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.JAXRSUtils$2", 2.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e1 = e.getException();
            if (e1 instanceof JsonParseException) {
                throw new BadRequestException((Throwable)e1);
            }
            if (e1 instanceof IOException) {
                throw (IOException)e1;
            }
            throw (WebApplicationException)((Object)e1);
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static void writeMessageBody(List<WriterInterceptor> writers, final Object entity, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, Message message) throws WebApplicationException, IOException {
        final OutputStream entityStream = message.getContent(OutputStream.class);
        if (writers.size() > 1) {
            WriterInterceptor first = writers.remove(0);
            WriterInterceptorContextImpl context = new WriterInterceptorContextImpl(entity, type, genericType, annotations, entityStream, message, writers);
            first.aroundWriteTo((WriterInterceptorContext)context);
        } else {
            long size;
            final MessageBodyWriter<Object> writer = ((WriterInterceptorMBW)writers.get(0)).getMBW();
            if (type == byte[].class && (size = writer.getSize(entity, type, genericType, annotations, mediaType)) != -1L) {
                httpHeaders.putSingle((Object)"Content-Length", (Object)Long.toString(size));
            }
            HttpUtils.convertHeaderValuesToString(httpHeaders, true);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 2705857747974655386L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() throws IOException, WebApplicationException {
                        writer.writeTo(entity, type, genericType, annotations, mediaType, httpHeaders, entityStream);
                        return Boolean.TRUE;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.JAXRSUtils$3", 3.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                throw (WebApplicationException)((Object)e1);
            }
        }
    }

    public static boolean matchConsumeTypes(MediaType requestContentType, OperationResourceInfo ori) {
        return JAXRSUtils.doMimeTypesIntersect(ori.getConsumeTypes(), requestContentType);
    }

    public static boolean matchProduceTypes(MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.doMimeTypesIntersect(ori.getProduceTypes(), acceptContentType);
    }

    public static boolean matchMimeTypes(MediaType requestContentType, MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.doMimeTypesIntersect(ori.getConsumeTypes(), requestContentType) && JAXRSUtils.doMimeTypesIntersect(ori.getProduceTypes(), acceptContentType);
    }

    public static List<MediaType> parseMediaTypes(String types) {
        ArrayList<MediaType> acceptValues = new ArrayList<MediaType>();
        if (types != null) {
            int x = 0;
            int y = types.indexOf(44);
            while (y > 0) {
                acceptValues.add(JAXRSUtils.toMediaType(types.substring(x, y).trim()));
                x = y + 1;
                y = types.indexOf(44, x);
            }
            String lastMediaType = types.substring(x).trim();
            if (!lastMediaType.isEmpty()) {
                acceptValues.add(JAXRSUtils.toMediaType(lastMediaType));
            }
        } else {
            acceptValues.add(ALL_TYPES);
        }
        return acceptValues;
    }

    public static boolean doMimeTypesIntersect(List<MediaType> mimeTypesA, MediaType mimeTypeB) {
        return JAXRSUtils.doMimeTypesIntersect(mimeTypesA, Collections.singletonList(mimeTypeB));
    }

    public static boolean doMimeTypesIntersect(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes) {
        NonAccumulatingIntersector intersector = new NonAccumulatingIntersector();
        JAXRSUtils.intersectMimeTypes(requiredMediaTypes, userMediaTypes, intersector);
        return intersector.doIntersect();
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes, boolean addRequiredParamsIfPossible) {
        return JAXRSUtils.intersectMimeTypes(requiredMediaTypes, userMediaTypes, addRequiredParamsIfPossible, false);
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes, boolean addRequiredParamsIfPossible, boolean addDistanceParameter) {
        AccumulatingIntersector intersector = new AccumulatingIntersector(addRequiredParamsIfPossible, addDistanceParameter);
        JAXRSUtils.intersectMimeTypes(requiredMediaTypes, userMediaTypes, intersector);
        return new ArrayList<MediaType>(intersector.getSupportedMimeTypeList());
    }

    private static void intersectMimeTypes(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes, MimeTypesIntersector intersector) {
        for (MediaType requiredType : requiredMediaTypes) {
            for (MediaType userType : userMediaTypes) {
                boolean isCompatible = JAXRSUtils.isMediaTypeCompatible(requiredType, userType);
                if (!isCompatible) continue;
                boolean parametersMatched = true;
                for (Map.Entry entry : userType.getParameters().entrySet()) {
                    String value = (String)requiredType.getParameters().get(entry.getKey());
                    if (value == null || entry.getValue() == null || JAXRSUtils.stripDoubleQuotesIfNeeded(value).equals(JAXRSUtils.stripDoubleQuotesIfNeeded((String)entry.getValue())) || HTTP_CHARSET_PARAM.equals(entry.getKey()) && value.equalsIgnoreCase((String)entry.getValue())) continue;
                    parametersMatched = false;
                    break;
                }
                if (!parametersMatched || intersector.intersect(requiredType, userType)) continue;
                return;
            }
        }
    }

    private static String stripDoubleQuotesIfNeeded(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static boolean isMediaTypeCompatible(MediaType requiredType, MediaType userType) {
        boolean isCompatible = requiredType.isCompatible(userType);
        if (!isCompatible && requiredType.getType().equalsIgnoreCase(userType.getType())) {
            isCompatible = JAXRSUtils.compareCompositeSubtypes(requiredType, userType, PhaseInterceptorChain.getCurrentMessage());
        }
        return isCompatible;
    }

    static boolean compareCompositeSubtypes(String requiredType, String userType, Message message) {
        return JAXRSUtils.compareCompositeSubtypes(JAXRSUtils.toMediaType(requiredType), JAXRSUtils.toMediaType(userType), message);
    }

    private static boolean compareCompositeSubtypes(MediaType requiredType, MediaType userType, Message message) {
        boolean isCompatible = false;
        String subType1 = requiredType.getSubtype();
        String subType2 = userType.getSubtype();
        String subTypeAfterPlus1 = JAXRSUtils.splitMediaSubType(subType1, true);
        String subTypeAfterPlus2 = JAXRSUtils.splitMediaSubType(subType2, true);
        if (message != null && MessageUtils.isTrue(message.getContextualProperty(PARTIAL_HIERARCHICAL_MEDIA_SUBTYPE_CHECK))) {
            if (subTypeAfterPlus1 != null || subTypeAfterPlus2 != null) {
                boolean nullPossible = subTypeAfterPlus1 == null || subTypeAfterPlus2 == null;
                boolean bl = isCompatible = subTypeAfterPlus1 == null && subTypeAfterPlus2.equals(subType1) || subTypeAfterPlus2 == null && subTypeAfterPlus1.equals(subType2);
                if (!isCompatible && !nullPossible) {
                    boolean bl2 = isCompatible = subTypeAfterPlus1.equalsIgnoreCase(subTypeAfterPlus2) && (subType1.charAt(0) == '*' || subType2.charAt(0) == '*');
                }
                if (!isCompatible) {
                    String subTypeBeforePlus1 = JAXRSUtils.splitMediaSubType(subType1, false);
                    String subTypeBeforePlus2 = JAXRSUtils.splitMediaSubType(subType2, false);
                    nullPossible = subTypeBeforePlus1 == null || subTypeBeforePlus2 == null;
                    boolean bl3 = isCompatible = subTypeBeforePlus1 == null && subTypeBeforePlus2.equals(subType1) || subTypeBeforePlus2 == null && subTypeBeforePlus1.equals(subType2);
                    if (!isCompatible && !nullPossible) {
                        isCompatible = subTypeBeforePlus1.equalsIgnoreCase(subTypeBeforePlus2) && (subType1.charAt(subType1.length() - 1) == '*' || subType2.charAt(subType2.length() - 1) == '*');
                    }
                }
            }
        } else if (subTypeAfterPlus1 != null && subTypeAfterPlus2 != null) {
            boolean bl = isCompatible = subTypeAfterPlus1.equalsIgnoreCase(subTypeAfterPlus2) && (subType1.charAt(0) == '*' || subType2.charAt(0) == '*');
            if (!isCompatible) {
                String subTypeBeforePlus2;
                String subTypeBeforePlus1 = JAXRSUtils.splitMediaSubType(subType1, false);
                isCompatible = subTypeBeforePlus1.equalsIgnoreCase(subTypeBeforePlus2 = JAXRSUtils.splitMediaSubType(subType2, false)) && (subType1.charAt(subType1.length() - 1) == '*' || subType2.charAt(subType2.length() - 1) == '*');
            }
        }
        return isCompatible;
    }

    private static String splitMediaSubType(String type, boolean after) {
        int index = type.indexOf(43);
        return index == -1 ? null : (after ? type.substring(index + 1) : type.substring(0, index));
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> mimeTypesA, MediaType mimeTypeB) {
        return JAXRSUtils.intersectMimeTypes(mimeTypesA, Collections.singletonList(mimeTypeB), false);
    }

    public static List<MediaType> intersectMimeTypes(String mimeTypesA, String mimeTypesB) {
        return JAXRSUtils.intersectMimeTypes(JAXRSUtils.parseMediaTypes(mimeTypesA), JAXRSUtils.parseMediaTypes(mimeTypesB), false);
    }

    public static List<MediaType> sortMediaTypes(String mediaTypes, String qs) {
        return JAXRSUtils.sortMediaTypes(JAXRSUtils.parseMediaTypes(mediaTypes), qs);
    }

    public static List<MediaType> sortMediaTypes(List<MediaType> types, final String qs) {
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){
                static final long serialVersionUID = 5898909507248444963L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypes(mt1, mt2, qs);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.JAXRSUtils$4", 4.class, null, null);
                }
            });
        }
        return types;
    }

    public static <T extends Throwable> Response convertFaultToResponse(T ex, Message currentMessage) {
        return ExceptionUtils.convertFaultToResponse(ex, currentMessage);
    }

    public static void setMessageContentType(Message message, Response response) {
        Object ct;
        if (response != null && (ct = response.getMetadata().getFirst((Object)"Content-Type")) != null) {
            Exchange ex = message.getExchange();
            if (ex.getInMessage() == message) {
                ex.put("Content-Type", ct.toString());
            } else {
                message.put("Content-Type", ct.toString());
            }
        }
    }

    public static QName getClassQName(Class<?> type) {
        String nsURI = PackageUtils.getNamespace(PackageUtils.getPackageName(type));
        if (nsURI.endsWith(PATH_SEGMENT_SEP)) {
            nsURI = nsURI.substring(0, nsURI.length() - 1);
        }
        return new QName(nsURI, type.getSimpleName(), "ns1");
    }

    public static QName convertStringToQName(String name) {
        return DOMUtils.convertStringToQName(name, "");
    }

    public static boolean runContainerRequestFilters(ServerProviderFactory pf, Message m, boolean preMatch, Set<String> names) throws IOException {
        List<ProviderInfo<ContainerRequestFilter>> containerFilters;
        Set<String> appNameBindings = AnnotationUtils.getNameBindings(pf.getApplicationProvider().getResourceClass().getAnnotations());
        if (names != null) {
            names.addAll(appNameBindings);
        } else {
            names = appNameBindings;
        }
        List<ProviderInfo<ContainerRequestFilter>> list = containerFilters = preMatch ? pf.getPreMatchContainerRequestFilters() : pf.getPostMatchContainerRequestFilters(names);
        if (!containerFilters.isEmpty()) {
            ContainerRequestContextImpl context = new ContainerRequestContextImpl(m, preMatch, false);
            for (ProviderInfo<ContainerRequestFilter> filter : containerFilters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, m);
                filter.getProvider().filter((ContainerRequestContext)context);
                Response response = m.getExchange().get(Response.class);
                if (response == null) continue;
                JAXRSUtils.setMessageContentType(m, response);
                return true;
            }
        }
        return false;
    }

    public static void runContainerResponseFilters(ServerProviderFactory pf, ResponseImpl r, Message m, OperationResourceInfo ori, Method invoked) throws IOException, Throwable {
        Set<String> names = ori == null ? null : ori.getNameBindings();
        Set<String> appNameBindings = AnnotationUtils.getNameBindings(pf.getApplicationProvider().getResourceClass().getAnnotations());
        if (names != null) {
            names.addAll(appNameBindings);
        } else {
            names = appNameBindings;
        }
        List<ProviderInfo<ContainerResponseFilter>> containerFilters = pf.getContainerResponseFilters(names);
        if (!containerFilters.isEmpty()) {
            ContainerRequestContextImpl requestContext = new ContainerRequestContextImpl(m.getExchange().getInMessage(), false, true);
            ContainerResponseContextImpl responseContext = new ContainerResponseContextImpl(r, m, ori == null ? null : ori.getClassResourceInfo().getServiceClass(), invoked);
            for (ProviderInfo<ContainerResponseFilter> filter : containerFilters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, m);
                filter.getProvider().filter((ContainerRequestContext)requestContext, (ContainerResponseContext)responseContext);
            }
        }
    }

    public static String mediaTypeToString(MediaType mt, String ... ignoreParams) {
        List<String> list = ignoreParams == null || ignoreParams.length == 0 ? null : Arrays.asList(ignoreParams);
        return MediaTypeHeaderProvider.typeToString(mt, list);
    }

    public static MediaType toMediaType(String value) {
        if (value == null) {
            return ALL_TYPES;
        }
        return MediaTypeHeaderProvider.valueOf(value);
    }

    public static Response toResponse(int status) {
        return JAXRSUtils.toResponseBuilder(status).build();
    }

    public static Response toResponse(Response.Status status) {
        return JAXRSUtils.toResponse(status.getStatusCode());
    }

    public static Response.ResponseBuilder toResponseBuilder(int status) {
        return new ResponseBuilderImpl().status(status);
    }

    public static Response.ResponseBuilder toResponseBuilder(Response.Status status) {
        return JAXRSUtils.toResponseBuilder(status.getStatusCode());
    }

    public static Response.ResponseBuilder fromResponse(Response response) {
        return JAXRSUtils.fromResponse(response, true);
    }

    public static Response.ResponseBuilder fromResponse(Response response, boolean copyEntity) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(response.getStatus());
        if (copyEntity) {
            rb.entity(response.getEntity());
        }
        for (Map.Entry entry : response.getMetadata().entrySet()) {
            List values = (List)entry.getValue();
            for (Object value : values) {
                rb.header((String)entry.getKey(), value);
            }
        }
        return rb;
    }

    public static Response copyResponseIfNeeded(Response response) {
        if (!(response instanceof ResponseImpl)) {
            Field[] declaredFields;
            Response r = JAXRSUtils.fromResponse(response).build();
            for (Field f : declaredFields = ReflectionUtil.getDeclaredFields(response.getClass())) {
                Class<?> declClass = f.getType();
                if (declClass != Annotation[].class) continue;
                try {
                    Annotation[] fieldAnnotations = ReflectionUtil.accessDeclaredField(f, response, Annotation[].class);
                    ((ResponseImpl)r).setEntityAnnotations(fieldAnnotations);
                }
                catch (Throwable fieldAnnotations) {
                    FFDCFilter.processException((Throwable)fieldAnnotations, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"1920", null, (Object[])new Object[]{response});
                    Tr.warning((TraceComponent)tc, (String)"Custom annotations if any can not be copied", (Object[])new Object[0]);
                }
                break;
            }
            return r;
        }
        return response;
    }

    public static Message getCurrentMessage() {
        return PhaseInterceptorChain.getCurrentMessage();
    }

    public static ClassResourceInfo getRootResource(Message m) {
        return (ClassResourceInfo)m.getExchange().get(ROOT_RESOURCE_CLASS);
    }

    public static void pushOntoStack(OperationResourceInfo ori, MultivaluedMap<String, String> params, Message msg) {
        OperationResourceInfoStack stack = msg.get(OperationResourceInfoStack.class);
        if (stack == null) {
            stack = new OperationResourceInfoStack();
            msg.put(OperationResourceInfoStack.class, stack);
        }
        List<String> values = null;
        if (params.size() <= 1) {
            values = Collections.emptyList();
        } else {
            values = new ArrayList(params.size() - 1);
            JAXRSUtils.addTemplateVarValues(values, params, ori.getClassResourceInfo().getURITemplate());
            JAXRSUtils.addTemplateVarValues(values, params, ori.getURITemplate());
        }
        Class<?> realClass = ori.getClassResourceInfo().getServiceClass();
        stack.push(new MethodInvocationInfo(ori, realClass, values));
    }

    private static void addTemplateVarValues(List<String> values, MultivaluedMap<String, String> params, URITemplate template) {
        if (template != null) {
            for (String var : template.getVariables()) {
                List paramValues = (List)params.get((Object)var);
                if (paramValues == null) continue;
                values.addAll(paramValues);
            }
        }
    }

    public static String logMessageHandlerProblem(String name, Class<?> cls, MediaType ct) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, cls.getName(), JAXRSUtils.mediaTypeToString(ct, new String[0]));
        String errorMessage = errorMsg.toString();
        Tr.error((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
        return errorMessage;
    }

    public static JaxRsRuntimeException toJaxRsRuntimeException(Throwable ex) {
        return new JaxRsRuntimeException(ex);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream copyAndGetEntityStream(Message m) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream origInputStream = m.getContent(InputStream.class);
        try {
            IOUtils.copy(origInputStream, baos);
        }
        catch (IOException iOException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"1993", null, (Object[])new Object[]{m});
                throw ExceptionUtils.toInternalServerErrorException((Throwable)e, null);
            }
            catch (Throwable throwable) {
                try {
                    origInputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"1998", null, (Object[])new Object[]{m});
                }
                throw throwable;
            }
        }
        try {
            origInputStream.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.utils.JAXRSUtils", (String)"1998", null, (Object[])new Object[]{m});
        }
        byte[] copiedBytes = baos.toByteArray();
        m.setContent(InputStream.class, new ByteArrayInputStream(copiedBytes));
        return new ByteArrayInputStream(copiedBytes);
    }
}

