/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.JaxRsConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.interceptor.CachedTime;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final TraceComponent tc = Tr.register(JAXRSOutInterceptor.class, null, null);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);
    static final long serialVersionUID = -4350422302552971165L;

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    @Override
    public void handleMessage(Message message) {
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(message);
        try {
            this.processResponse(providerFactory, message);
        }
        finally {
            ServerProviderFactory.releaseRequestState(providerFactory, message);
        }
    }

    private void processResponse(ServerProviderFactory providerFactory, Message message) {
        if (this.isResponseAlreadyHandled(message)) {
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        Object responseObj = objs.get(0);
        Response response = null;
        if (responseObj instanceof Response) {
            response = (Response)responseObj;
            if (response.getStatus() == 500 && message.getExchange().get("exception.from.mapper") != null) {
                message.put(Message.RESPONSE_CODE, 500);
                return;
            }
        } else {
            int status = this.getStatus(message, responseObj != null ? 200 : 204);
            response = JAXRSUtils.toResponseBuilder(status).entity(responseObj).build();
        }
        Exchange exchange = message.getExchange();
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class.getName());
        this.serializeMessage(providerFactory, message, response, ori, true);
    }

    private int getStatus(Message message, int defaultValue) {
        Object customStatus = message.getExchange().get(Message.RESPONSE_CODE);
        return customStatus == null ? defaultValue : (Integer)customStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void serializeMessage(ServerProviderFactory providerFactory, Message message, Response theResponse, OperationResourceInfo ori, boolean firstTry) {
        boolean ignoreWriters;
        ResponseImpl response = (ResponseImpl)JAXRSUtils.copyResponseIfNeeded(theResponse);
        Exchange exchange = message.getExchange();
        boolean headResponse = response.getStatus() == 200 && firstTry && ori != null && "HEAD".equals(ori.getHttpMethod());
        Object entity = response.getActualEntity();
        if (headResponse && entity != null) {
            Tr.info((TraceComponent)tc, (String)new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString(), (Object[])new Object[0]);
            entity = null;
        }
        Method invoked = ori == null ? null : (ori.getAnnotatedMethod() != null ? ori.getAnnotatedMethod() : ori.getMethodToInvoke());
        Annotation[] annotations = null;
        Annotation[] staticAnns = ori != null ? ori.getOutAnnotations() : new Annotation[]{};
        Annotation[] responseAnns = response.getEntityAnnotations();
        if (responseAnns != null) {
            annotations = new Annotation[staticAnns.length + responseAnns.length];
            System.arraycopy(staticAnns, 0, annotations, 0, staticAnns.length);
            System.arraycopy(responseAnns, 0, annotations, staticAnns.length, responseAnns.length);
        } else {
            annotations = staticAnns;
        }
        response.setStatus(this.getActualStatus(response.getStatus(), entity));
        response.setEntity(entity, annotations);
        MultivaluedMap<String, Object> responseHeaders = this.prepareResponseHeaders(message, response, entity, firstTry);
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue()) {
            try {
                JAXRSUtils.runContainerResponseFilters(providerFactory, response, message, ori, invoked);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"171", (Object)this, (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
                this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
                return;
            }
        }
        entity = InjectionUtils.getEntity(response.getActualEntity());
        this.setResponseStatus(message, this.getActualStatus(response.getStatus(), entity));
        if (entity == null) {
            if (!headResponse) {
                responseHeaders.putSingle((Object)"Content-Length", (Object)"0");
                if (MessageUtils.getContextualBoolean(message, "remove.content.type.for.empty.response", false)) {
                    responseHeaders.remove((Object)"Content-Type");
                    message.remove("Content-Type");
                }
            }
            HttpUtils.convertHeaderValuesToString(responseHeaders, true);
            return;
        }
        Object ignoreWritersProp = exchange.get("ignore.message.writers");
        boolean bl = ignoreWriters = ignoreWritersProp == null ? false : Boolean.valueOf(ignoreWritersProp.toString());
        if (ignoreWriters) {
            this.writeResponseToStream(message.getContent(OutputStream.class), entity);
            return;
        }
        MediaType responseMediaType = this.getResponseMediaType(responseHeaders.getFirst((Object)"Content-Type"));
        Class<?> serviceCls = invoked != null ? ori.getClassResourceInfo().getServiceClass() : null;
        Class<?> targetType = InjectionUtils.getRawResponseClass(entity);
        Type genericType = InjectionUtils.getGenericResponseType(invoked, serviceCls, response.getActualEntity(), targetType, exchange);
        targetType = InjectionUtils.updateParamClassToTypeIfNeeded(targetType, genericType);
        annotations = response.getEntityAnnotations();
        List<WriterInterceptor> writers = providerFactory.createMessageBodyWriterInterceptor(targetType, genericType, annotations, responseMediaType, message, ori == null ? null : ori.getNameBindings());
        OutputStream outOriginal = message.getContent(OutputStream.class);
        if (writers == null || writers.isEmpty()) {
            this.writeResponseErrorMessage(message, outOriginal, "NO_MSG_WRITER", targetType, responseMediaType);
            return;
        }
        try {
            boolean checkWriters = false;
            if (responseMediaType.isWildcardSubtype()) {
                Produces pM = AnnotationUtils.getMethodAnnotation(ori == null ? null : ori.getAnnotatedMethod(), Produces.class);
                Produces pC = AnnotationUtils.getClassAnnotation(serviceCls, Produces.class);
                checkWriters = pM == null && pC == null;
            }
            responseMediaType = this.checkFinalContentType(responseMediaType, writers, checkWriters);
        }
        catch (Throwable checkWriters) {
            void ex;
            FFDCFilter.processException((Throwable)checkWriters, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"228", (Object)this, (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
            this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
            return;
        }
        String finalResponseContentType = JAXRSUtils.mediaTypeToString(responseMediaType, new String[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Response content type is: " + finalResponseContentType), (Object[])new Object[0]);
        }
        responseHeaders.putSingle((Object)"Content-Type", (Object)finalResponseContentType);
        message.put("Content-Type", finalResponseContentType);
        boolean enabled = this.checkBufferingMode(message, writers, firstTry);
        try {
            try {
                JAXRSUtils.writeMessageBody(writers, entity, targetType, genericType, annotations, responseMediaType, responseHeaders, message);
                if (this.isResponseRedirected(message)) {
                    return;
                }
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    OutputStream os = message.getContent(OutputStream.class);
                    if (os != outOriginal && os instanceof CachedOutputStream) {
                        os.close();
                    }
                    message.setContent(OutputStream.class, outOriginal);
                    message.put(XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (Throwable os) {
            void ex;
            FFDCFilter.processException((Throwable)os, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"267", (Object)this, (Object[])new Object[]{providerFactory, message, theResponse, ori, firstTry});
            this.logWriteError(firstTry, targetType, responseMediaType);
            this.handleWriteException(providerFactory, message, (Throwable)ex, firstTry);
        }
    }

    private MultivaluedMap<String, Object> prepareResponseHeaders(Message message, ResponseImpl response, Object entity, boolean firstTry) {
        MultivaluedMap<String, Object> responseHeaders = response.getMetadata();
        Map userHeaders = (Map)message.get(Message.PROTOCOL_HEADERS);
        if (firstTry && userHeaders != null) {
            responseHeaders.putAll(userHeaders);
        }
        if (entity != null) {
            Object customContentType = responseHeaders.getFirst((Object)"Content-Type");
            if (customContentType == null) {
                String initialResponseContentType = (String)message.get("Content-Type");
                if (initialResponseContentType != null) {
                    responseHeaders.putSingle((Object)"Content-Type", (Object)initialResponseContentType);
                }
            } else {
                message.put("Content-Type", customContentType.toString());
            }
        }
        message.put(Message.PROTOCOL_HEADERS, responseHeaders);
        this.setResponseDate(responseHeaders, firstTry);
        return responseHeaders;
    }

    private MediaType getResponseMediaType(Object mediaTypeHeader) {
        MediaType responseMediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader == null ? MediaType.WILDCARD_TYPE : JAXRSUtils.toMediaType(mediaTypeHeader.toString()));
        return responseMediaType;
    }

    private int getActualStatus(int status, Object responseObj) {
        if (status == -1) {
            return responseObj == null ? 204 : 200;
        }
        return status;
    }

    private boolean checkBufferingMode(Message m, List<WriterInterceptor> writers, boolean firstTry) {
        if (!firstTry) {
            return false;
        }
        WriterInterceptor last = writers.get(writers.size() - 1);
        MessageBodyWriter<Object> w = ((WriterInterceptorMBW)last).getMBW();
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean enabled = MessageUtils.isTrue(outBuf);
        boolean configurableProvider = w instanceof AbstractConfigurableProvider;
        if (!enabled && outBuf == null && configurableProvider) {
            enabled = ((AbstractConfigurableProvider)w).getEnableBuffering();
        }
        if (enabled) {
            boolean streamingOn;
            boolean bl = streamingOn = configurableProvider ? ((AbstractConfigurableProvider)w).getEnableStreaming() : false;
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, new CachedOutputStream());
            }
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        XMLStreamWriter writer = null;
        writer = enabled ? m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get(XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = null;
                try {
                    origWriter = StaxUtils.createXMLStreamWriter(osOriginal);
                    for (XMLEvent event : cache.getEvents()) {
                        StaxUtils.writeEvent(event, origWriter);
                    }
                }
                finally {
                    StaxUtils.close(origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            return;
        }
        if (enabled && (os = m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0L) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void logWriteError(boolean firstTry, Class<?> cls, MediaType ct) {
        if (firstTry) {
            JAXRSUtils.logMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, ct);
        }
    }

    private void handleWriteException(ServerProviderFactory pf, Message message, Throwable ex, boolean firstTry) {
        Response excResponse = null;
        if (firstTry) {
            excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        } else {
            message.getExchange().put("second.jaxrs.exception", Boolean.TRUE);
        }
        if (excResponse == null) {
            this.setResponseStatus(message, 500);
            throw new Fault(ex);
        }
        this.serializeMessage(pf, message, excResponse, null, false);
    }

    private void writeResponseErrorMessage(Message message, OutputStream out, String name, Class<?> cls, MediaType ct) {
        message.put("Content-Type", "text/plain");
        message.put(Message.RESPONSE_CODE, 500);
        try {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
            if (out != null) {
                out.write(errorMessage.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"410", (Object)this, (Object[])new Object[]{message, out, name, cls, ct});
        }
    }

    private MediaType checkFinalContentType(MediaType mt, List<WriterInterceptor> writers, boolean checkWriters) {
        int mbwIndex;
        MessageBodyWriter<Object> writer;
        Produces pm;
        if (checkWriters && (pm = (writer = ((WriterInterceptorMBW)writers.get(mbwIndex = writers.size() == 1 ? 0 : writers.size() - 1)).getMBW()).getClass().getAnnotation(Produces.class)) != null) {
            List<MediaType> sorted = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(pm.value()), "qs");
            mt = JAXRSUtils.intersectMimeTypes(sorted, mt).get(0);
        }
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            if ("application".equals(mt.getType()) || mt.isWildcardType()) {
                mt = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            } else {
                throw ExceptionUtils.toNotAcceptableException(null, null);
            }
        }
        return mt;
    }

    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (!firstTry || headers.containsKey((Object)"Date")) {
            return;
        }
        headers.putSingle((Object)"Date", (Object)CachedTime.getCachedTime().getTimeAsString(-1L));
    }

    private boolean isResponseAlreadyHandled(Message m) {
        return this.isResponseAlreadyCommited(m) || this.isResponseRedirected(m);
    }

    private boolean isResponseAlreadyCommited(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get("http.response.done"));
    }

    private boolean isResponseRedirected(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get("http.request.redirected"));
    }

    /*
     * WARNING - void declaration
     */
    private void writeResponseToStream(OutputStream os, Object responseObj) {
        try {
            byte[] bytes = responseObj.toString().getBytes(StandardCharsets.UTF_8);
            os.write(bytes, 0, bytes.length);
        }
        catch (Exception bytes) {
            void ex;
            FFDCFilter.processException((Throwable)bytes, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor", (String)"462", (Object)this, (Object[])new Object[]{os, responseObj});
            Tr.error((TraceComponent)tc, (String)"Problem with writing the data to the output stream", (Object[])new Object[0]);
            ex.printStackTrace();
            throw new RuntimeException((Throwable)ex);
        }
    }

    private void setResponseStatus(Message message, int status) {
        message.put(Message.RESPONSE_CODE, status);
        boolean responseHeadersCopied = this.isResponseHeadersCopied(message);
        if (responseHeadersCopied) {
            HttpServletResponse response = (HttpServletResponse)message.get("HTTP.RESPONSE");
            response.setStatus(status);
        }
    }

    private boolean isResponseHeadersCopied(Message message) {
        return MessageUtils.isTrue(message.get("http.headers.copied"));
    }

    @Override
    public void handleFault(Message message) {
    }
}

