/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientMessageObserver;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.spec.ClientRequestFilterInterceptor;
import org.apache.cxf.jaxrs.client.spec.ClientResponseFilterInterceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractClient
implements Client {
    protected static final String EXECUTOR_SERVICE_PROPERTY = "executorService";
    protected static final String REQUEST_CONTEXT = "RequestContext";
    protected static final String RESPONSE_CONTEXT = "ResponseContext";
    protected static final String KEEP_CONDUIT_ALIVE = "KeepConduitAlive";
    protected static final String HTTP_SCHEME = "http";
    private static final String ALLOW_EMPTY_PATH_VALUES = "allow.empty.path.template.value";
    private static final String PROXY_PROPERTY = "jaxrs.proxy";
    private static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    private static final String SERVICE_NOT_AVAIL_PROPERTY = "org.apache.cxf.transport.service_not_available";
    private static final String COMPLETE_IF_SERVICE_NOT_AVAIL_PROPERTY = "org.apache.cxf.transport.complete_if_service_not_available";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractClient.class);
    private static final Set<String> KNOWN_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"));
    protected ClientConfiguration cfg;
    private ClientState state;
    private AtomicBoolean closed;
    static final long serialVersionUID = -726856197505362579L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AbstractClient(ClientState initialState) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "<init>", new Object[]{initialState});
        }
        this.cfg = new ClientConfiguration();
        this.closed = new AtomicBoolean();
        this.state = initialState;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client query(String name, Object ... values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "query", new Object[]{name, values});
        }
        this.addMatrixQueryParamsToBuilder(this.getCurrentBuilder(), name, ParameterType.QUERY, null, values);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "query", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client header(String name, Object ... values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "header", new Object[]{name, values});
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if ("Content-Type".equals(name)) {
            if (values.length > 1) {
                throw new IllegalArgumentException("Content-Type can have a single value only");
            }
            this.type(this.convertParamValue(values[0], null));
        } else {
            for (Object o : values) {
                this.possiblyAddHeader(name, this.convertParamValue(o, null));
            }
        }
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "header", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client headers(MultivaluedMap<String, String> map) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "headers", new Object[]{map});
        }
        this.removeAllHeaders();
        this.state.getRequestHeaders().putAll(map);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "headers", abstractClient);
        }
        return abstractClient;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAllHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "removeAllHeaders", new Object[0]);
        }
        this.state.getRequestHeaders().clear();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "removeAllHeaders");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client accept(MediaType ... types) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "accept", new Object[]{types});
        }
        for (MediaType mt : types) {
            this.possiblyAddHeader("Accept", JAXRSUtils.mediaTypeToString(mt, new String[0]));
        }
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "accept", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client type(MediaType ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "type", new Object[]{ct});
        }
        Client client = this.type(JAXRSUtils.mediaTypeToString(ct, new String[0]));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            client = client;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "type", client);
        }
        return client;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client type(String type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "type", new Object[]{type});
        }
        this.state.getRequestHeaders().putSingle((Object)"Content-Type", (Object)type);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "type", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client accept(String ... types) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "accept", new Object[]{types});
        }
        for (String type : types) {
            this.possiblyAddHeader("Accept", type);
        }
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "accept", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client cookie(Cookie cookie) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "cookie", new Object[]{cookie});
        }
        this.possiblyAddHeader("Cookie", cookie.toString());
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "cookie", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client authorization(Object auth) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "authorization", new Object[]{auth});
        }
        String value = this.convertParamValue(auth, null);
        this.state.getRequestHeaders().putSingle((Object)"Authorization", (Object)value);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "authorization", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client modified(Date date, boolean ifNot) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "modified", new Object[]{date, ifNot});
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        String hName = ifNot ? "If-Unmodified-Since" : "If-Modified-Since";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)dateFormat.format(date));
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "modified", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client language(String language) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "language", new Object[]{language});
        }
        this.state.getRequestHeaders().putSingle((Object)"Content-Language", (Object)language);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "language", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client match(EntityTag tag, boolean ifNot) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "match", new Object[]{tag, ifNot});
        }
        String hName = ifNot ? "If-None-Match" : "If-Match";
        this.state.getRequestHeaders().putSingle((Object)hName, (Object)tag.toString());
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "match", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client acceptLanguage(String ... languages) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "acceptLanguage", new Object[]{languages});
        }
        for (String s : languages) {
            this.possiblyAddHeader("Accept-Language", s);
        }
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "acceptLanguage", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client acceptEncoding(String ... encs) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "acceptEncoding", new Object[]{encs});
        }
        for (String s : encs) {
            this.possiblyAddHeader("Accept-Encoding", s);
        }
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "acceptEncoding", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client encoding(String enc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "encoding", new Object[]{enc});
        }
        this.state.getRequestHeaders().putSingle((Object)"Content-Encoding", (Object)enc);
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "encoding", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MultivaluedMap<String, String> getHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getHeaders", new Object[0]);
        }
        MetadataMap<String, String> map = new MetadataMap<String, String>(false, true);
        map.putAll((Map)this.state.getRequestHeaders());
        MetadataMap<String, String> metadataMap = map;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getHeaders", metadataMap);
        }
        return metadataMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI getBaseURI() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getBaseURI", new Object[0]);
        }
        URI uRI = this.state.getBaseURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getBaseURI", uRI);
        }
        return uRI;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI getCurrentURI() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getCurrentURI", new Object[0]);
        }
        URI uRI = this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getCurrentURI", uRI);
        }
        return uRI;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Response getResponse() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getResponse", new Object[0]);
        }
        Response response = this.state.getResponse();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            response = response;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getResponse", response);
        }
        return response;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client reset() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "reset", new Object[0]);
        }
        this.state.reset();
        AbstractClient abstractClient = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractClient = abstractClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "reset", abstractClient);
        }
        return abstractClient;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "close", new Object[0]);
        }
        if (this.closed.compareAndSet(false, true)) {
            if (this.cfg.getBus() == null) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "close");
                }
                return;
            }
            for (Closeable c : this.cfg.getEndpoint().getCleanupHooks()) {
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"353", (Object)this, (Object[])new Object[0]);
                }
            }
            ClientLifeCycleManager mgr = this.cfg.getBus().getExtension(ClientLifeCycleManager.class);
            if (null != mgr) {
                mgr.clientDestroyed(new FrontendClientAdapter(this.getConfiguration()));
            }
            if (this.cfg.getConduitSelector() instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.cfg.getConduitSelector())).close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"365", (Object)this, (Object[])new Object[0]);
                }
            } else {
                this.cfg.getConduit().close();
            }
            this.state.reset();
            if (this.cfg.isShutdownBusOnClose()) {
                this.cfg.getBus().shutdown(false);
            }
            this.state = null;
            this.cfg = null;
        }
        this.closed = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void possiblyAddHeader(String name, String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "possiblyAddHeader", new Object[]{name, value});
        }
        if (!this.isDuplicate(name, value)) {
            this.state.getRequestHeaders().add((Object)name, (Object)value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "possiblyAddHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isDuplicate(String name, String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "isDuplicate", new Object[]{name, value});
        }
        List values = (List)this.state.getRequestHeaders().get((Object)name);
        boolean bl = values != null && values.contains(value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "isDuplicate", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClientState getState() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getState", new Object[0]);
        }
        ClientState clientState = this.state;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clientState = clientState;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getState", clientState);
        }
        return clientState;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected UriBuilder getCurrentBuilder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getCurrentBuilder", new Object[0]);
        }
        UriBuilder uriBuilder = this.state.getCurrentBuilder();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uriBuilder = uriBuilder;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getCurrentBuilder", uriBuilder);
        }
        return uriBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void resetResponse() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "resetResponse", new Object[0]);
        }
        this.state.setResponse(null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "resetResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void resetBaseAddress(URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "resetBaseAddress", new Object[]{uri});
        }
        this.state.setBaseURI(uri);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "resetBaseAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void resetCurrentBuilder(URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "resetCurrentBuilder", new Object[]{uri});
        }
        this.state.setCurrentBuilder(new UriBuilderImpl(uri));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "resetCurrentBuilder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected MultivaluedMap<String, String> getTemplateParametersMap(URITemplate template, List<Object> values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getTemplateParametersMap", new Object[]{template, values});
        }
        if (values != null && values.size() != 0) {
            List<String> vars = template.getVariables();
            MetadataMap<String, String> templatesMap = new MetadataMap<String, String>(vars.size());
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= values.size()) continue;
                templatesMap.add(vars.get(i), values.get(i).toString());
            }
            MetadataMap<String, String> metadataMap = templatesMap;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                metadataMap = metadataMap;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getTemplateParametersMap", metadataMap);
            }
            return metadataMap;
        }
        MultivaluedMap<String, String> multivaluedMap = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getTemplateParametersMap", multivaluedMap);
        }
        return multivaluedMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Response.ResponseBuilder setResponseBuilder(Message outMessage, Exchange exchange) throws Exception {
        Message responseMessage;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setResponseBuilder", new Object[]{outMessage, exchange});
        }
        Response response = exchange.get(Response.class);
        if (response != null) {
            outMessage.getExchange().getInMessage().put(Message.PROTOCOL_HEADERS, response.getStringHeaders());
            Response.ResponseBuilder responseBuilder = JAXRSUtils.fromResponse(JAXRSUtils.copyResponseIfNeeded(response));
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                responseBuilder = responseBuilder;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setResponseBuilder", responseBuilder);
            }
            return responseBuilder;
        }
        Integer status = this.getResponseCode(exchange);
        Response.ResponseBuilder currentResponseBuilder = JAXRSUtils.toResponseBuilder(status);
        Message message = responseMessage = exchange.getInMessage() != null ? exchange.getInMessage() : exchange.getInFaultMessage();
        if (responseMessage == null) {
            Response.ResponseBuilder responseBuilder = currentResponseBuilder;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                responseBuilder = responseBuilder;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setResponseBuilder", responseBuilder);
            }
            return responseBuilder;
        }
        Map protocolHeaders = CastUtils.cast((Map)responseMessage.get(Message.PROTOCOL_HEADERS));
        boolean splitHeaders = MessageUtils.isTrue(outMessage.getContextualProperty(HEADER_SPLIT_PROPERTY));
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            if (HttpUtils.isDateRelatedHeader((String)entry.getKey())) {
                currentResponseBuilder.header((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            for (Object valObject : (List)entry.getValue()) {
                if (splitHeaders && valObject instanceof String) {
                    String[] values;
                    String val = (String)valObject;
                    if (val == null || val.length() == 0) {
                        values = new String[]{""};
                    } else if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
                        values = this.parseQuotedHeaderValue(val);
                    } else {
                        String[] stringArray;
                        boolean splitPossible;
                        boolean bl = splitPossible = !"Set-Cookie".equalsIgnoreCase((String)entry.getKey()) || !val.toUpperCase().contains("Expires".toUpperCase());
                        if (splitPossible) {
                            stringArray = val.split(",");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = val;
                        }
                        values = stringArray;
                    }
                    for (String s : values) {
                        String theValue = s.trim();
                        if (theValue.length() <= 0) continue;
                        currentResponseBuilder.header((String)entry.getKey(), (Object)theValue);
                    }
                    continue;
                }
                currentResponseBuilder.header((String)entry.getKey(), valObject);
            }
        }
        String ct = (String)responseMessage.get("Content-Type");
        if (ct != null) {
            currentResponseBuilder.type(ct);
        }
        InputStream mStream = responseMessage.getContent(InputStream.class);
        currentResponseBuilder.entity((Object)mStream);
        Response.ResponseBuilder responseBuilder = currentResponseBuilder;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            responseBuilder = responseBuilder;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setResponseBuilder", responseBuilder);
        }
        return responseBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> void writeBody(T o, Message outMessage, Class<?> cls, Type type, Annotation[] anns, OutputStream os) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "writeBody", new Object[]{o, outMessage, cls, type, anns, os});
        }
        if (o == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "writeBody");
            }
            return;
        }
        MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
        Class<?> theClass = cls;
        Object contentTypeHeader = headers.getFirst((Object)"Content-Type");
        if (contentTypeHeader == null) {
            contentTypeHeader = "*/*";
        }
        MediaType contentType = JAXRSUtils.toMediaType(contentTypeHeader.toString());
        List<WriterInterceptor> writers = ClientProviderFactory.getInstance(outMessage).createMessageBodyWriterInterceptor(theClass, type, anns, contentType, outMessage, null);
        if (writers != null) {
            try {
                JAXRSUtils.writeMessageBody(writers, o, theClass, type, anns, contentType, (MultivaluedMap<String, Object>)headers, outMessage);
                OutputStream realOs = outMessage.get(OutputStream.class);
                if (realOs != null) {
                    realOs.flush();
                }
            }
            catch (Exception realOs) {
                void ex;
                FFDCFilter.processException((Throwable)realOs, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"531", (Object)this, (Object[])new Object[]{o, outMessage, cls, type, anns, os});
                AbstractClient.reportMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, contentType, (Throwable)ex);
            }
        } else {
            AbstractClient.reportMessageHandlerProblem("NO_MSG_WRITER", cls, contentType, null);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "writeBody");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected WebApplicationException convertToWebApplicationException(Response r) {
        WebApplicationException webApplicationException;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "convertToWebApplicationException", new Object[]{r});
            }
            try {
                Class<?> exceptionClass = ExceptionUtils.getWebApplicationExceptionClass(r, WebApplicationException.class);
                Constructor<?> ctr = exceptionClass.getConstructor(Response.class);
                webApplicationException = (WebApplicationException)((Object)ctr.newInstance(r));
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable exceptionClass) {
                FFDCFilter.processException((Throwable)exceptionClass, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"546", (Object)this, (Object[])new Object[]{r});
                WebApplicationException webApplicationException2 = new WebApplicationException(r);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    webApplicationException2 = webApplicationException2;
                    LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertToWebApplicationException", (Object)webApplicationException2);
                }
                return webApplicationException2;
            }
            webApplicationException = webApplicationException;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertToWebApplicationException", (Object)webApplicationException);
        }
        return webApplicationException;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> T readBody(Response r, Message outMessage, Class<T> cls, Type type, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "readBody", new Object[]{r, outMessage, cls, type, anns});
        }
        if (cls == Response.class) {
            T t = cls.cast(r);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "readBody", t);
            }
            return t;
        }
        int status = r.getStatus();
        if ((status < 200 || status == 204) && r.getLength() <= 0 || status >= 300) {
            T t = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "readBody", t);
            }
            return t;
        }
        T t = ((ResponseImpl)r).doReadEntity(cls, type, anns, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "readBody", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean responseStreamCanBeClosed(Message outMessage, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "responseStreamCanBeClosed", new Object[]{outMessage, cls});
        }
        boolean bl = !JAXRSUtils.isStreamingOutType(cls) && MessageUtils.isTrue(outMessage.getContextualProperty("response.stream.auto.close"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "responseStreamCanBeClosed", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void completeExchange(Exchange exchange, boolean proxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "completeExchange", new Object[]{exchange, proxy});
        }
        exchange.put(KEEP_CONDUIT_ALIVE, true);
        this.getConfiguration().getConduitSelector().complete(exchange);
        String s = (String)exchange.getOutMessage().get(Message.BASE_PATH);
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "completeExchange");
            }
            return;
        }
        s = (String)exchange.getOutMessage().get("transport.retransmit.url");
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "completeExchange");
            }
            return;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "completeExchange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object[] preProcessResult(Message message) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "preProcessResult", new Object[]{message});
        }
        Exchange exchange = message.getExchange();
        Exception ex = message.getContent(Exception.class);
        if (ex == null) {
            ex = message.getExchange().get(Exception.class);
        }
        if (ex == null && !exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                while (exchange.get("IN_CHAIN_COMPLETE") == null) {
                    exchange.wait(this.cfg.getSynchronousTimeout());
                }
            }
        }
        if (ex == null) {
            ex = message.getContent(Exception.class);
        }
        if (ex != null || PropertyUtils.isTrue(exchange.get(SERVICE_NOT_AVAIL_PROPERTY)) && PropertyUtils.isTrue(exchange.get(COMPLETE_IF_SERVICE_NOT_AVAIL_PROPERTY))) {
            this.getConfiguration().getConduitSelector().complete(exchange);
        }
        if (ex != null) {
            this.checkClientException(message, ex);
        }
        this.checkClientException(message, exchange.get(Exception.class));
        List result = exchange.get(List.class);
        Object[] objectArray = result != null ? result.toArray() : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectArray = objectArray;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "preProcessResult", objectArray);
        }
        return objectArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkClientException(Message outMessage, Exception ex) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "checkClientException", new Object[]{outMessage, ex});
        }
        Exception actualEx = ex instanceof Fault ? ((Fault)ex).getCause() : ex;
        Exchange exchange = outMessage.getExchange();
        Integer responseCode = this.getResponseCode(exchange);
        if (responseCode == null || responseCode < 300 && !(actualEx instanceof IOException) || actualEx instanceof IOException && exchange.get("client.redirect.exception") != null) {
            if (actualEx instanceof ProcessingException) {
                throw (RuntimeException)actualEx;
            }
            if (actualEx != null) {
                Object useProcExProp = exchange.get("wrap.in.processing.exception");
                if (actualEx instanceof RuntimeException && useProcExProp != null && PropertyUtils.isFalse(useProcExProp)) {
                    throw actualEx;
                }
                throw new ProcessingException((Throwable)actualEx);
            }
            if (!exchange.isOneWay() || this.cfg.isResponseExpectedForOneway()) {
                this.waitForResponseCode(exchange);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "checkClientException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void waitForResponseCode(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "waitForResponseCode", new Object[]{exchange});
        }
        Exchange exchange2 = exchange;
        synchronized (exchange2) {
            if (this.getResponseCode(exchange) == null) {
                try {
                    exchange.wait(this.cfg.getSynchronousTimeout());
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"656", (Object)this, (Object[])new Object[]{exchange});
                }
                if (this.getResponseCode(exchange) == null) {
                    throw new ProcessingException("Response timeout");
                }
            } else {
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl15.1 : MonitorExitStatement: MONITOREXIT : var2_2
                if (LOG == null || !LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "waitForResponseCode");
                return;
            }
        }
        if (LOG == null || !LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "waitForResponseCode");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Integer getResponseCode(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getResponseCode", new Object[]{exchange});
        }
        Integer responseCode = (Integer)exchange.get(Message.RESPONSE_CODE);
        if (responseCode == null && exchange.getInMessage() != null) {
            responseCode = (Integer)exchange.getInMessage().get(Message.RESPONSE_CODE);
        }
        if (responseCode == null && exchange.isOneWay() && !this.state.getBaseURI().toString().startsWith(HTTP_SCHEME)) {
            responseCode = 202;
        }
        Integer n = responseCode;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getResponseCode", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected URI calculateNewRequestURI(Map<String, Object> reqContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "calculateNewRequestURI", new Object[]{reqContext});
        }
        URI newBaseURI = URI.create(reqContext.get(Message.ENDPOINT_ADDRESS).toString());
        URI requestURI = URI.create(reqContext.get("org.apache.cxf.request.uri").toString());
        URI uRI = this.calculateNewRequestURI(newBaseURI, requestURI, MessageUtils.isTrue(reqContext.get(PROXY_PROPERTY)));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "calculateNewRequestURI", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private URI calculateNewRequestURI(URI newBaseURI, URI requestURI, boolean proxy) {
        String basePath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "calculateNewRequestURI", new Object[]{newBaseURI, requestURI, proxy});
        }
        String baseURIPath = newBaseURI.getRawPath();
        String reqURIPath = requestURI.getRawPath();
        UriBuilder builder = new UriBuilderImpl().uri(newBaseURI);
        String string = basePath = reqURIPath.startsWith(baseURIPath) ? baseURIPath : this.getBaseURI().getRawPath();
        String relativePath = reqURIPath.equals(basePath) ? "" : (reqURIPath.startsWith(basePath) ? reqURIPath.substring(basePath.length()) : reqURIPath);
        builder.path(relativePath);
        String newQuery = newBaseURI.getRawQuery();
        if (newQuery == null) {
            builder.replaceQuery(requestURI.getRawQuery());
        } else {
            builder.replaceQuery(newQuery);
        }
        URI newRequestURI = builder.build(new Object[0]);
        this.resetBaseAddress(newBaseURI);
        URI current = proxy ? newBaseURI : newRequestURI;
        this.resetCurrentBuilder(current);
        URI uRI = newRequestURI;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "calculateNewRequestURI", uRI);
        }
        return uRI;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doRunInterceptorChain(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "doRunInterceptorChain", new Object[]{m});
        }
        try {
            m.getInterceptorChain().doIntercept(m);
        }
        catch (Exception exception) {
            void ex;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"716", (Object)this, (Object[])new Object[]{m});
            m.setContent(Exception.class, ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "doRunInterceptorChain");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object[] retryInvoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        Object[] objectArray;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "retryInvoke", new Object[]{oi, params, context, exchange});
            }
            try {
                Object body = params.length == 0 ? null : params[0];
                Map<String, Object> reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
                MultivaluedMap headers = (MultivaluedMap)reqContext.get(Message.PROTOCOL_HEADERS);
                URI newRequestURI = this.calculateNewRequestURI(reqContext);
                Object response = this.retryInvoke(newRequestURI, (MultivaluedMap<String, String>)headers, body, exchange, context);
                exchange.put(List.class, this.getContentsList(response));
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = response;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable body) {
                void t;
                FFDCFilter.processException((Throwable)body, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"740", (Object)this, (Object[])new Object[]{oi, params, context, exchange});
                Exception ex = t instanceof Exception ? (Exception)t : new Exception((Throwable)t);
                exchange.put(Exception.class, ex);
                Object[] objectArray3 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    objectArray3 = objectArray3;
                    LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "retryInvoke", objectArray3);
                }
                return objectArray3;
            }
            objectArray = objectArray;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "retryInvoke", objectArray);
        }
        return objectArray;
    }

    protected abstract Object retryInvoke(URI var1, MultivaluedMap<String, String> var2, Object var3, Exchange var4, Map<String, Object> var5) throws Throwable;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addMatrixQueryParamsToBuilder(UriBuilder ub, String paramName, ParameterType pt, Annotation[] anns, Object ... pValues) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "addMatrixQueryParamsToBuilder", new Object[]{ub, paramName, pt, anns, pValues});
        }
        if (pt != ParameterType.MATRIX && pt != ParameterType.QUERY) {
            throw new IllegalArgumentException("This method currently deal with matrix and query parameters only");
        }
        if (!"".equals(paramName)) {
            if (pValues != null && pValues.length > 0) {
                for (Object pValue : pValues) {
                    if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                        List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                        Iterator it = c.iterator();
                        while (it.hasNext()) {
                            this.convertMatrixOrQueryToBuilder(ub, paramName, it.next(), pt, anns);
                        }
                        continue;
                    }
                    this.convertMatrixOrQueryToBuilder(ub, paramName, pValue, pt, anns);
                }
            } else {
                this.addMatrixOrQueryToBuilder(ub, paramName, pt, pValues);
            }
        } else {
            Object pValue = pValues[0];
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(pValue, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    this.convertMatrixOrQueryToBuilder(ub, (String)entry.getKey(), v, pt, anns);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "addMatrixQueryParamsToBuilder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void convertMatrixOrQueryToBuilder(UriBuilder ub, String paramName, Object pValue, ParameterType pt, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "convertMatrixOrQueryToBuilder", new Object[]{ub, paramName, pValue, pt, anns});
        }
        String convertedValue = this.convertParamValue(pValue, anns);
        this.addMatrixOrQueryToBuilder(ub, paramName, pt, convertedValue);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertMatrixOrQueryToBuilder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addMatrixOrQueryToBuilder(UriBuilder ub, String paramName, ParameterType pt, Object ... pValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "addMatrixOrQueryToBuilder", new Object[]{ub, paramName, pt, pValue});
        }
        if (pt == ParameterType.MATRIX) {
            ub.matrixParam(paramName, pValue);
        } else {
            ub.queryParam(paramName, pValue);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "addMatrixOrQueryToBuilder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String convertParamValue(Object pValue, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", new Object[]{pValue, anns});
        }
        String string = this.convertParamValue(pValue, pValue == null ? null : pValue.getClass(), anns);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String convertParamValue(Object pValue, Class<?> pClass, Annotation[] anns) {
        Object allowEmptyProp;
        PathParam pp;
        String v;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", new Object[]{pValue, pClass, anns});
        }
        if (pValue == null && pClass == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", string);
            }
            return string;
        }
        ClientProviderFactory pf = ClientProviderFactory.getInstance(this.cfg.getEndpoint());
        if (pf != null) {
            ParamConverter<?> prov;
            MessageImpl m = null;
            if (pf.isParamConverterContextsAvailable()) {
                m = new MessageImpl();
                m.put("org.apache.cxf.client", Boolean.TRUE);
                m.setExchange(new ExchangeImpl());
                m.getExchange().setOutMessage(m);
                m.getExchange().put(Endpoint.class, this.cfg.getEndpoint());
            }
            if ((prov = pf.createParameterHandler(pClass, pClass, anns, m)) != null) {
                String string;
                block12: {
                    String string2 = prov.toString(pValue);
                    string = string2;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
                    string = string;
                    LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", string);
                }
                return string;
                finally {
                    if (m != null) {
                        ((ProviderFactory)pf).clearThreadLocalProxies();
                    }
                }
            }
        }
        String string = v = pValue == null ? null : pValue.toString();
        if (anns != null && StringUtils.isEmpty(v) && null != (pp = AnnotationUtils.getAnnotation(anns, PathParam.class)) && !PropertyUtils.isTrue(allowEmptyProp = this.getConfiguration().getBus().getProperty(ALLOW_EMPTY_PATH_VALUES))) {
            throw new IllegalArgumentException("Value for " + pp.value() + " is not specified");
        }
        String string3 = v;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string3 = string3;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "convertParamValue", string3);
        }
        return string3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "reportMessageHandlerProblem", new Object[]{name, cls, ct, ex});
        }
        String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
        Throwable actualEx = ex instanceof Fault ? ((Fault)ex).getCause() : ex;
        throw new ProcessingException(errorMessage, actualEx);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void setAllHeaders(MultivaluedMap<String, String> headers, HttpURLConnection conn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setAllHeaders", new Object[]{headers, conn});
        }
        for (Map.Entry entry : headers.entrySet()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String value = (String)((List)entry.getValue()).get(i);
                b.append(value);
                if (i + 1 >= ((List)entry.getValue()).size()) continue;
                b.append(',');
            }
            conn.setRequestProperty((String)entry.getKey(), b.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setAllHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String[] parseQuotedHeaderValue(String originalValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "parseQuotedHeaderValue", new Object[]{originalValue});
        }
        ArrayList<String> results = new ArrayList<String>();
        char[] chars = originalValue.toCharArray();
        int lastIndex = chars.length - 1;
        boolean quote = false;
        StringBuilder sb = new StringBuilder();
        block5: for (int pos = 0; pos <= lastIndex; ++pos) {
            char c = chars[pos];
            if (pos == lastIndex) {
                sb.append(c);
                results.add(sb.toString());
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append(c);
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (quote) {
                        if (++pos <= lastIndex) {
                            c = chars[pos];
                            sb.append(c);
                        }
                        if (pos != lastIndex) continue block5;
                        results.add(sb.toString());
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case ',': {
                    if (quote) {
                        sb.append(c);
                        continue block5;
                    }
                    results.add(sb.toString());
                    sb = new StringBuilder();
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String[] stringArray = results.toArray(new String[results.size()]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "parseQuotedHeaderValue", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClientConfiguration getConfiguration() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getConfiguration", new Object[0]);
        }
        ClientConfiguration clientConfiguration = this.cfg;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clientConfiguration = clientConfiguration;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getConfiguration", clientConfiguration);
        }
        return clientConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setConfiguration(ClientConfiguration config) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setConfiguration", new Object[]{config});
        }
        this.cfg = config;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setConfiguration");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void prepareConduitSelector(Message message, URI currentURI, boolean proxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "prepareConduitSelector", new Object[]{message, currentURI, proxy});
        }
        try {
            this.cfg.prepareConduitSelector(message);
        }
        catch (Fault fault) {
            FFDCFilter.processException((Throwable)fault, (String)"org.apache.cxf.jaxrs.client.AbstractClient", (String)"941", (Object)this, (Object[])new Object[]{message, currentURI, proxy});
            LOG.warning("Failure to prepare a message from conduit selector");
        }
        message.getExchange().put(ConduitSelector.class, this.cfg.getConduitSelector());
        message.getExchange().put(Service.class, this.cfg.getConduitSelector().getEndpoint().getService());
        String address = (String)message.get(Message.ENDPOINT_ADDRESS);
        if (address.startsWith(HTTP_SCHEME) && !address.equals(currentURI.toString())) {
            URI baseAddress = URI.create(address);
            currentURI = this.calculateNewRequestURI(baseAddress, currentURI, proxy);
            message.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
            message.put("org.apache.cxf.request.uri", currentURI.toString());
        }
        message.put(Message.BASE_PATH, this.getBaseURI().toString());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "prepareConduitSelector");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static PhaseInterceptorChain setupOutInterceptorChain(ClientConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setupOutInterceptorChain", new Object[]{cfg});
        }
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getOutInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getOutInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getOutInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getOutPhases(), i1, i2, i3);
        chain.add(new ClientRequestFilterInterceptor());
        PhaseInterceptorChain phaseInterceptorChain = chain;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            phaseInterceptorChain = phaseInterceptorChain;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setupOutInterceptorChain", phaseInterceptorChain);
        }
        return phaseInterceptorChain;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static PhaseInterceptorChain setupInInterceptorChain(ClientConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setupInInterceptorChain", new Object[]{cfg});
        }
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getInInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getInInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getInInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getInPhases(), i1, i2, i3);
        chain.add(new ClientResponseFilterInterceptor());
        PhaseInterceptorChain phaseInterceptorChain = chain;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            phaseInterceptorChain = phaseInterceptorChain;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setupInInterceptorChain", phaseInterceptorChain);
        }
        return phaseInterceptorChain;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static MessageObserver setupInFaultObserver(final ClientConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setupInFaultObserver", new Object[]{cfg});
        }
        InFaultChainInitiatorObserver inFaultChainInitiatorObserver = new InFaultChainInitiatorObserver(cfg.getBus()){
            static final long serialVersionUID = 4354542050075830178L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
                chain.add(cfg.getInFaultInterceptors());
                chain.add(new ConnectionFaultInterceptor());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$1", 1.class, null, null);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inFaultChainInitiatorObserver = inFaultChainInitiatorObserver;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setupInFaultObserver", inFaultChainInitiatorObserver);
        }
        return inFaultChainInitiatorObserver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setSupportOnewayResponseProperty(Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setSupportOnewayResponseProperty", new Object[]{outMessage});
        }
        if (!outMessage.getExchange().isOneWay()) {
            outMessage.put("org.apache.cxf.transport.processOneWayResponse", true);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setSupportOnewayResponseProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkClosed() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "checkClosed", new Object[0]);
        }
        if (this.closed.get()) {
            throw new IllegalStateException("Client is closed");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "checkClosed");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Message createMessage(Object body, String httpMethod, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "createMessage", new Object[]{body, httpMethod, headers, currentURI, exchange, invocationContext, proxy});
        }
        this.checkClosed();
        Message m = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage();
        m.put("org.apache.cxf.client", Boolean.TRUE);
        m.put("org.apache.cxf.message.inbound", Boolean.FALSE);
        this.setRequestMethod(m, httpMethod);
        m.put(Message.PROTOCOL_HEADERS, headers);
        if (currentURI.isAbsolute() && currentURI.getScheme().startsWith(HTTP_SCHEME)) {
            m.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
        } else {
            m.put(Message.ENDPOINT_ADDRESS, this.state.getBaseURI().toString());
        }
        Object requestURIProperty = this.cfg.getRequestContext().get("org.apache.cxf.request.uri");
        if (requestURIProperty == null) {
            m.put("org.apache.cxf.request.uri", currentURI.toString());
        } else {
            m.put("org.apache.cxf.request.uri", requestURIProperty.toString());
        }
        String ct = (String)headers.getFirst((Object)"Content-Type");
        m.put("Content-Type", ct);
        body = this.checkIfBodyEmpty(body, ct);
        this.setEmptyRequestPropertyIfNeeded(m, body);
        m.setContent(List.class, this.getContentsList(body));
        m.put("jaxrs.template.parameters", this.getState().getTemplates());
        PhaseInterceptorChain chain = AbstractClient.setupOutInterceptorChain(this.cfg);
        chain.setFaultObserver(AbstractClient.setupInFaultObserver(this.cfg));
        m.setInterceptorChain(chain);
        exchange = this.createExchange(m, exchange);
        exchange.put("org.apache.cxf.rest.message", Boolean.TRUE);
        exchange.setOneWay("true".equals(headers.getFirst((Object)"OnewayRequest")));
        exchange.put(Retryable.class, new RetryableImpl());
        this.setContexts(m, exchange, invocationContext, proxy);
        this.prepareConduitSelector(m, currentURI, proxy);
        Message message = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "createMessage", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setRequestMethod(Message m, String httpMethod) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setRequestMethod", new Object[]{m, httpMethod});
        }
        m.put("org.apache.cxf.request.method", httpMethod);
        if (!KNOWN_METHODS.contains(httpMethod) && !m.containsKey("use.async.http.conduit")) {
            m.put("use.async.http.conduit", true);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setRequestMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setEmptyRequestPropertyIfNeeded(Message outMessage, Object body) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setEmptyRequestPropertyIfNeeded", new Object[]{outMessage, body});
        }
        if (body == null) {
            outMessage.put("org.apache.cxf.empty.request", true);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setEmptyRequestPropertyIfNeeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object checkIfBodyEmpty(Object body, String contentType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "checkIfBodyEmpty", new Object[]{body, contentType});
        }
        if (body != null && (body.getClass() == String.class && ((String)body).length() == 0 || body.getClass() == Form.class && ((Form)body).asMap().isEmpty() || Map.class.isAssignableFrom(body.getClass()) && ((Map)body).isEmpty() && !"application/json".equals(contentType) || body instanceof byte[] && ((byte[])body).length == 0)) {
            body = null;
        }
        Object object = body;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "checkIfBodyEmpty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, Object> getRequestContext(Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getRequestContext", new Object[]{outMessage});
        }
        Map invContext = CastUtils.cast((Map)outMessage.get("org.apache.cxf.invocation.context"));
        Map<String, Object> map = CastUtils.cast((Map)invContext.get(REQUEST_CONTEXT));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getRequestContext", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<?> getContentsList(Object body) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getContentsList", new Object[]{body});
        }
        MessageContentsList messageContentsList = body == null ? new MessageContentsList() : new MessageContentsList(body);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getContentsList", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Exchange createExchange(Message m, Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "createExchange", new Object[]{m, exchange});
        }
        if (exchange == null) {
            exchange = new ExchangeImpl();
        }
        exchange.setSynchronous(true);
        exchange.setOutMessage(m);
        exchange.put(Bus.class, this.cfg.getBus());
        exchange.put(MessageObserver.class, new ClientMessageObserver(this.cfg));
        exchange.put(Endpoint.class, this.cfg.getConduitSelector().getEndpoint());
        exchange.put("org.apache.cxf.transport.no_io_exceptions", true);
        exchange.put(StaxInEndingInterceptor.STAX_IN_NOCLOSE, Boolean.TRUE);
        m.setExchange(exchange);
        Exchange exchange2 = exchange;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            exchange2 = exchange2;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "createExchange", exchange2);
        }
        return exchange2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setAsyncMessageObserverIfNeeded(Exchange exchange) {
        ExecutorService executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setAsyncMessageObserverIfNeeded", new Object[]{exchange});
        }
        if (!exchange.isSynchronous() && (executor = (ExecutorService)this.cfg.getRequestContext().get(EXECUTOR_SERVICE_PROPERTY)) != null) {
            exchange.put(Executor.class, executor);
            final ClientMessageObserver observer = new ClientMessageObserver(this.cfg);
            exchange.put(MessageObserver.class, new MessageObserver(){
                static final long serialVersionUID = 1885472914497000805L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void onMessage(final Message message) {
                    if (!message.getExchange().containsKey(Executor.class.getName() + ".USING_SPECIFIED")) {
                        executor.execute(new Runnable(){
                            static final long serialVersionUID = -9122114672151036966L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public void run() {
                                observer.onMessage(message);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$2$1", 1.class, null, null);
                            }
                        });
                    } else {
                        observer.onMessage(message);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$2", 2.class, null, null);
                }
            });
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setAsyncMessageObserverIfNeeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setContexts(Message message, Exchange exchange, Map<String, Object> context, boolean proxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setContexts", new Object[]{message, exchange, context, proxy});
        }
        Map reqContext = null;
        Map resContext = null;
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
        resContext = CastUtils.cast((Map)context.get(RESPONSE_CONTEXT));
        if (reqContext == null) {
            reqContext = new HashMap<String, Object>(this.cfg.getRequestContext());
            context.put(REQUEST_CONTEXT, reqContext);
        }
        reqContext.put(Message.PROTOCOL_HEADERS, message.get(Message.PROTOCOL_HEADERS));
        reqContext.put("org.apache.cxf.request.uri", message.get("org.apache.cxf.request.uri"));
        reqContext.put(Message.ENDPOINT_ADDRESS, message.get(Message.ENDPOINT_ADDRESS));
        reqContext.put(PROXY_PROPERTY, proxy);
        if (resContext == null) {
            resContext = new HashMap();
            context.put(RESPONSE_CONTEXT, resContext);
        }
        message.put("org.apache.cxf.invocation.context", context);
        message.putAll(reqContext);
        exchange.putAll(reqContext);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setContexts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setPlainOperationNameProperty(Message outMessage, String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "setPlainOperationNameProperty", new Object[]{outMessage, name});
        }
        outMessage.getExchange().put("org.apache.cxf.resource.operation.name", name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "setPlainOperationNameProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static Type getCallbackType(InvocationCallback<?> callback) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getCallbackType", new Object[]{callback});
        }
        Class<?> cls = callback.getClass();
        ParameterizedType pt = AbstractClient.findCallbackType(cls);
        Type actualType = null;
        Type[] typeArray = pt.getActualTypeArguments();
        int n = typeArray.length;
        int n2 = 0;
        if (n2 < n) {
            Type tp;
            actualType = tp = typeArray[n2];
        }
        if (actualType instanceof TypeVariable) {
            actualType = InjectionUtils.getSuperType(cls, (TypeVariable)actualType);
        }
        Type type = actualType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            type = type;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getCallbackType", type);
        }
        return type;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static ParameterizedType findCallbackType(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "findCallbackType", new Object[]{cls});
        }
        if (cls == null || cls == Object.class) {
            ParameterizedType parameterizedType = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameterizedType = parameterizedType;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "findCallbackType", parameterizedType);
            }
            return parameterizedType;
        }
        for (Type c2 : cls.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(c2 instanceof ParameterizedType) || !InvocationCallback.class.equals((Object)(pt = (ParameterizedType)c2).getRawType())) continue;
            ParameterizedType parameterizedType = pt;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameterizedType = parameterizedType;
                LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "findCallbackType", parameterizedType);
            }
            return parameterizedType;
        }
        ParameterizedType parameterizedType = AbstractClient.findCallbackType(cls.getSuperclass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            parameterizedType = parameterizedType;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "findCallbackType", parameterizedType);
        }
        return parameterizedType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static Class<?> getCallbackClass(Type outType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "getCallbackClass", new Object[]{outType});
        }
        Class respClass = null;
        if (outType instanceof Class) {
            respClass = (Class)outType;
        } else if (outType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)outType;
            if (pt.getRawType() instanceof Class) {
                respClass = (Class)pt.getRawType();
            }
        } else if (outType == null) {
            respClass = Response.class;
        }
        Class clazz = respClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "getCallbackClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void resetResponseStateImmediatelyIfNeeded() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.AbstractClient", "resetResponseStateImmediatelyIfNeeded", new Object[0]);
        }
        if (this.state instanceof ThreadLocalClientState && this.cfg.isResetThreadLocalStateImmediately()) {
            this.state.reset();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.AbstractClient", "resetResponseStateImmediatelyIfNeeded");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected abstract class AbstractClientAsyncResponseInterceptor
    extends AbstractPhaseInterceptor<Message> {
        static final long serialVersionUID = 6877195656590836121L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        AbstractClientAsyncResponseInterceptor() {
            super("unmarshal");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) throws Fault {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().put("IN_CHAIN_COMPLETE", Boolean.TRUE);
                message.getExchange().notifyAll();
            }
            if (message.getExchange().isSynchronous()) {
                return;
            }
            this.handleAsyncResponse(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFault(Message message) {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().put("IN_CHAIN_COMPLETE", Boolean.TRUE);
                message.getExchange().notifyAll();
            }
            if (message.getExchange().isSynchronous()) {
                return;
            }
            this.handleAsyncFault(message);
        }

        /*
         * WARNING - void declaration
         */
        private void handleAsyncResponse(Message message) {
            JaxrsClientCallback cb = message.getExchange().get(JaxrsClientCallback.class);
            Response r = null;
            try {
                Object[] results = AbstractClient.this.preProcessResult(message);
                if (results != null && results.length == 1) {
                    r = (Response)results[0];
                }
            }
            catch (Exception results) {
                void ex;
                FFDCFilter.processException((Throwable)results, (String)"org.apache.cxf.jaxrs.client.AbstractClient$AbstractClientAsyncResponseInterceptor", (String)"1333", (Object)this, (Object[])new Object[]{message});
                WebApplicationException t = ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : new ProcessingException((Throwable)ex));
                cb.handleException(message, t);
                return;
            }
            this.doHandleAsyncResponse(message, r, cb);
        }

        protected abstract void doHandleAsyncResponse(Message var1, Response var2, JaxrsClientCallback<?> var3);

        protected void closeAsyncResponseIfPossible(Response r, Message outMessage, JaxrsClientCallback<?> cb) {
            if (AbstractClient.this.responseStreamCanBeClosed(outMessage, cb.getResponseClass())) {
                r.close();
            }
        }

        protected void handleAsyncFault(Message message) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$AbstractClientAsyncResponseInterceptor", AbstractClientAsyncResponseInterceptor.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConnectionFaultInterceptor
    extends AbstractPhaseInterceptor<Message> {
        static final long serialVersionUID = 168387614608169902L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConnectionFaultInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            if (!message.getExchange().isSynchronous()) {
                Throwable ex = message.getContent(Exception.class);
                if (ex == null) {
                    ex = message.getExchange().get(Exception.class);
                }
                if (ex != null) {
                    JaxrsClientCallback cb = message.getExchange().get(JaxrsClientCallback.class);
                    if (ex instanceof Fault) {
                        ex = ex.getCause();
                    }
                    ex = ex instanceof ProcessingException ? ex : new ProcessingException(ex);
                    cb.handleException(message, ex);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$ConnectionFaultInterceptor", ConnectionFaultInterceptor.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class RetryableImpl
    implements Retryable {
        static final long serialVersionUID = 7850792977520783428L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RetryableImpl() {
        }

        @Override
        public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
            return AbstractClient.this.retryInvoke(oi, params, context, exchange);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$RetryableImpl", RetryableImpl.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected abstract class AbstractBodyWriter
    extends AbstractOutDatabindingInterceptor {
        static final long serialVersionUID = -7073195218591655287L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AbstractBodyWriter() {
            super("write");
        }

        @Override
        public void handleMessage(Message outMessage) throws Fault {
            XMLStreamWriter writer;
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            OutputStream os = outMessage.getContent(OutputStream.class);
            if (os == null && (writer = outMessage.getContent(XMLStreamWriter.class)) == null) {
                return;
            }
            Object body = objs.get(0);
            Annotation[] customAnns = (Annotation[])outMessage.get(Annotation.class.getName());
            Type t = outMessage.get(Type.class);
            this.doWriteBody(outMessage, body, t, customAnns, os);
        }

        protected abstract void doWriteBody(Message var1, Object var2, Type var3, Annotation[] var4, OutputStream var5) throws Fault;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.AbstractClient$AbstractBodyWriter", AbstractBodyWriter.class, null, null);
        }
    }
}

