/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.endpoint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cxf.exceptions.InvalidCharsetException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.JaxRsRuntimeException;
import com.ibm.ws.jaxrs20.api.JaxRsProviderFactoryService;
import com.ibm.ws.jaxrs20.endpoint.JaxRsWebEndpoint;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.servlet.BaseUrlHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractJaxRsWebEndpoint
implements JaxRsWebEndpoint {
    private static final TraceComponent tc = Tr.register(AbstractJaxRsWebEndpoint.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    private static final String HTTP_PREFIX = "http";
    private static final String SET_JAXB_VALIDATION_EVENT_HANDLER = "set-jaxb-validation-event-handler";
    protected final com.ibm.ws.jaxrs20.metadata.EndpointInfo endpointInfo;
    protected final JaxRsModuleMetaData jaxRsModuleMetaData;
    protected ServletConfig servletConfig;
    protected AbstractHTTPDestination destination;
    static final long serialVersionUID = -5865334179039344363L;

    public AbstractJaxRsWebEndpoint(com.ibm.ws.jaxrs20.metadata.EndpointInfo endpointInfo, JaxRsModuleMetaData jaxWsModuleMetaData) {
        this.endpointInfo = endpointInfo;
        this.jaxRsModuleMetaData = jaxWsModuleMetaData;
    }

    @Override
    public void init(ServletConfig servletConfig, JaxRsProviderFactoryService jaxRsProviderFactoryService) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public AbstractHTTPDestination getDestination() {
        return this.destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={InvalidCharsetException.class})
    public void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.destination == null) {
            response.setStatus(404);
            return;
        }
        try {
            this.updateDestination(request);
            this.destination.invoke(this.servletConfig, this.servletConfig.getServletContext(), request, response);
        }
        catch (InvalidCharsetException e) {
            response.setStatus(415);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.endpoint.AbstractJaxRsWebEndpoint", (String)"140", (Object)this, (Object[])new Object[]{request, response});
            throw new ServletException((Throwable)e);
        }
        catch (JaxRsRuntimeException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.endpoint.AbstractJaxRsWebEndpoint", (String)"142", (Object)this, (Object[])new Object[]{request, response});
            throw new ServletException(ex.getCause());
        }
    }

    protected void configureEndpointInfoProperties(com.ibm.ws.jaxrs20.metadata.EndpointInfo libertyEndpointInfo, EndpointInfo cxfEndpointInfo) {
        cxfEndpointInfo.setProperty(SET_JAXB_VALIDATION_EVENT_HANDLER, false);
        Map<String, String> endpointProperties = libertyEndpointInfo.getEndpointProperties();
        if (endpointProperties != null && !endpointProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : endpointProperties.entrySet()) {
                cxfEndpointInfo.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestination(HttpServletRequest request) {
        String base = this.getBaseURL(request);
        AbstractHTTPDestination abstractHTTPDestination = this.destination;
        synchronized (abstractHTTPDestination) {
            String ad = null;
            if (this.destination.getAddress() != null && this.destination.getAddress().getAddress() != null && (ad = this.destination.getAddress().getAddress().getValue()) == null) {
                ad = "/";
            }
            if (ad != null && !ad.startsWith(HTTP_PREFIX)) {
                String combined = "";
                combined = !base.endsWith("/") && !ad.startsWith("/") ? base + "/" + ad : base + ad;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("EndpointInfo address = " + this.destination.getEndpointInfo().getAddress()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("Base + address = " + combined), (Object[])new Object[0]);
                }
                BaseUrlHelper.setAddress(this.destination, combined);
            }
        }
    }

    protected String getBaseURL(HttpServletRequest request) {
        String reqPrefix = request.getRequestURL().toString();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            StringBuilder sb = new StringBuilder();
            String[] uri = HttpUtils.parseURI(reqPrefix, true);
            if (uri == null) {
                throw new IllegalArgumentException(reqPrefix + " contains illegal arguments");
            }
            sb.append(uri[0]).append("://").append(uri[1]);
            sb.append(request.getContextPath());
            reqPrefix = sb.toString();
        }
        return reqPrefix;
    }

    @Override
    public void setEndpointInfoAddress(String add) {
        if (add.endsWith("/*")) {
            add = add.substring(0, add.length() - 1);
        }
        if (!add.startsWith("/")) {
            add = "/" + add;
        }
        this.endpointInfo.setAddress(add);
    }
}

