/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.validate.UsernameTokenValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractUsernameTokenAuthenticatingInterceptor
extends WSS4JInInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractUsernameTokenAuthenticatingInterceptor.class);
    private boolean supportDigestPasswords;
    static final long serialVersionUID = 348992507179008143L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractUsernameTokenAuthenticatingInterceptor() {
        this(new HashMap<String, Object>());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractUsernameTokenAuthenticatingInterceptor(Map<String, Object> properties) {
        super(properties);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "<init>", new Object[]{properties});
        }
        this.getAfter().add(PolicyBasedWSS4JInInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSupportDigestPasswords(boolean support) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "setSupportDigestPasswords", new Object[]{support});
        }
        this.supportDigestPasswords = support;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "setSupportDigestPasswords");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getSupportDigestPasswords() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "getSupportDigestPasswords", new Object[0]);
        }
        boolean bl = this.supportDigestPasswords;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "getSupportDigestPasswords", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage msg) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "handleMessage", new Object[]{msg});
        }
        SecurityToken token = (SecurityToken)msg.get(SecurityToken.class);
        SecurityContext context = (SecurityContext)msg.get(SecurityContext.class);
        if (token == null || context == null || context.getUserPrincipal() == null) {
            super.handleMessage(msg);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "handleMessage");
            }
            return;
        }
        UsernameToken ut = (UsernameToken)token;
        Subject subject = this.createSubject(ut.getName(), ut.getPassword(), ut.isHashed(), ut.getNonce(), ut.getCreatedTime());
        SecurityContext sc = this.doCreateSecurityContext(context.getUserPrincipal(), subject);
        msg.put(SecurityContext.class, (Object)sc);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "handleMessage");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SecurityContext createSecurityContext(Principal p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "createSecurityContext", new Object[]{p});
        }
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        SecurityContext securityContext = this.doCreateSecurityContext(p, (Subject)msg.get(Subject.class));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            securityContext = securityContext;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "createSecurityContext", securityContext);
        }
        return securityContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SecurityContext doCreateSecurityContext(Principal p, Subject subject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "doCreateSecurityContext", new Object[]{p, subject});
        }
        DefaultSecurityContext defaultSecurityContext = new DefaultSecurityContext(p, subject);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            defaultSecurityContext = defaultSecurityContext;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "doCreateSecurityContext", defaultSecurityContext);
        }
        return defaultSecurityContext;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setSubject(String name, String password, boolean isDigest, String nonce, String created) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "setSubject", new Object[]{name, password, isDigest, nonce, created});
        }
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        Subject subject = null;
        try {
            subject = this.createSubject(name, password, isDigest, nonce, created);
        }
        catch (Exception exception) {
            void ex;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", (String)"139", (Object)((Object)this), (Object[])new Object[]{name, password, isDigest, nonce, created});
            String errorMessage = "Failed Authentication : Subject has not been created";
            LOG.severe(errorMessage);
            throw new WSSecurityException(errorMessage, (Throwable)ex);
        }
        if (subject == null || subject.getPrincipals().size() == 0 || !subject.getPrincipals().iterator().next().getName().equals(name)) {
            String errorMessage = "Failed Authentication : Invalid Subject";
            LOG.severe(errorMessage);
            throw new WSSecurityException(errorMessage);
        }
        msg.put(Subject.class, (Object)subject);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "setSubject");
        }
    }

    protected abstract Subject createSubject(String var1, String var2, boolean var3, String var4, String var5) throws SecurityException;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected WSSecurityEngine getSecurityEngine(boolean utNoCallbacks) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "getSecurityEngine", new Object[]{utNoCallbacks});
        }
        HashMap<QName, Object> profiles = new HashMap<QName, Object>(1);
        CustomValidator validator = new CustomValidator();
        profiles.put(WSSecurityEngine.USERNAME_TOKEN, (Object)validator);
        WSSecurityEngine wSSecurityEngine = AbstractUsernameTokenAuthenticatingInterceptor.createSecurityEngine(profiles);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wSSecurityEngine = wSSecurityEngine;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor", "getSecurityEngine", wSSecurityEngine);
        }
        return wSSecurityEngine;
    }

    protected class CustomValidator
    extends UsernameTokenValidator {
        protected CustomValidator() {
        }

        protected void verifyCustomPassword(org.apache.ws.security.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(usernameToken.getName(), usernameToken.getPassword(), false, null, null);
        }

        protected void verifyPlaintextPassword(org.apache.ws.security.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(usernameToken.getName(), usernameToken.getPassword(), false, null, null);
        }

        protected void verifyDigestPassword(org.apache.ws.security.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            if (!AbstractUsernameTokenAuthenticatingInterceptor.this.supportDigestPasswords) {
                throw new WSSecurityException(5);
            }
            String user = usernameToken.getName();
            String password = usernameToken.getPassword();
            boolean isHashed = usernameToken.isHashed();
            String nonce = usernameToken.getNonce();
            String createdTime = usernameToken.getCreated();
            AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(user, password, isHashed, nonce, createdTime);
        }

        protected void verifyUnknownPassword(org.apache.ws.security.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(usernameToken.getName(), null, false, null, null);
        }
    }
}

