/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTUpgradeOutputStream31;
import com.ibm.ws.webcontainer31.upgrade.UpgradedWebConnectionImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import java.io.IOException;
import javax.servlet.WriteListener;

public class UpgradeAsyncWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(UpgradeAsyncWriteCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private WriteListener _wl;
    private SRTUpgradeOutputStream31 _upgradeOut;
    private ThreadContextManager _contextManager;
    private UpgradedWebConnectionImpl _upCon = null;

    public UpgradeAsyncWriteCallback(WriteListener _listener, SRTUpgradeOutputStream31 upgradeOut, ThreadContextManager tcm, UpgradedWebConnectionImpl _upConn) {
        this._wl = _listener;
        this._upgradeOut = upgradeOut;
        this._contextManager = tcm;
        this._upCon = _upConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Upgrade Async Callback, current thread -->" + Thread.currentThread().getName()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete called : " + vc + "WriteListener enabled: " + this._wl), (Object[])new Object[0]);
        }
        SRTUpgradeOutputStream31 sRTUpgradeOutputStream31 = this._upgradeOut;
        synchronized (sRTUpgradeOutputStream31) {
            block34: {
                if (null == vc) {
                    return;
                }
                if (this._upgradeOut.getBufferHelper().isOutputStream_closed()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("complete , outputStream closed ignoring complete : " + vc), (Object[])new Object[0]);
                    }
                    return;
                }
                WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
                reqState.init();
                try {
                    this._upgradeOut.getBufferHelper().writeRemainingToBuffers();
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("exception during writeBuffers" + e.toString()), (Object[])new Object[0]);
                    }
                    this.error(vc, e);
                    return;
                }
                if (this._upgradeOut.getBufferHelper().isInternalReady() && this._upgradeOut.getBufferHelper().write_crlf_pending) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("write CRLF bytes  , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
                    }
                    try {
                        reqState.setAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread", (Object)true);
                        reqState.setAttribute("com.ibm.ws.webcontainer.upgrade.CRLFWriteinPorgress", (Object)true);
                        this._upgradeOut.getBufferHelper().writeCRLFIfNeeded();
                    }
                    catch (IOException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(" Exception during write CRLF bytes: " + e), (Object[])new Object[0]);
                        }
                        this._upgradeOut.getBufferHelper().write_crlf_pending = false;
                        this.error(vc, e);
                        return;
                    }
                }
                if (this._upgradeOut.getBufferHelper().isInternalReady()) {
                    WebContainerRequestState.getInstance((boolean)true).setAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread", (Object)true);
                    this._upgradeOut.getBufferHelper().setReadyForApp(true);
                    if (this._upgradeOut.getBufferHelper().isOutputStream_close_initiated_but_not_Flush_ready()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"complete , In process of closing outputStream, no more data is left to write, call close", (Object[])new Object[0]);
                        }
                        try {
                            if (this._upCon.isOutputStream_CloseStartedFromWC()) {
                                this._upCon.closeOutputandConnection();
                                break block34;
                            }
                            this._upgradeOut.close();
                        }
                        catch (Exception e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("complete , stack exception" + e.toString()), (Object[])new Object[0]);
                            }
                            this.error(vc, e);
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " ,status_not_ready_checked -->" + this._upgradeOut.getBufferHelper().status_not_ready_checked), (Object[])new Object[0]);
                        }
                        if (this._upgradeOut.getBufferHelper().status_not_ready_checked) {
                            try {
                                this._upgradeOut.getBufferHelper().status_not_ready_checked = false;
                                this._contextManager.pushContextData();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Calling user's WriteListener onWritePossible", (Object[])new Object[0]);
                                }
                                this._wl.onWritePossible();
                            }
                            catch (Exception e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("stack exception" + e.toString()), (Object[])new Object[0]);
                                }
                                this.error(vc, e);
                            }
                            finally {
                                this._contextManager.popContextData();
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " .onWritePossible will be skipped as isReady has not been checked since write went async."), (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        SRTUpgradeOutputStream31 sRTUpgradeOutputStream31 = this._upgradeOut;
        synchronized (sRTUpgradeOutputStream31) {
            if (null == vc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"error , vc is null , connection must be closed ", (Object[])new Object[0]);
                }
                return;
            }
            if (this._upgradeOut.getBufferHelper().isOutputStream_closed()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("error , outputStream closed ignoring error : " + vc), (Object[])new Object[0]);
                }
                return;
            }
            WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
            reqState.init();
            this._upgradeOut.getBufferHelper().setInternalReady(true);
            this._upgradeOut.getBufferHelper().setReadyForApp(true);
            reqState.setAttribute("com.ibm.ws.webcontainer.upgrade.AllowWriteFromE", (Object)true);
            reqState.setAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread", (Object)true);
            try {
                this._contextManager.pushContextData();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling user's WriteListener onError : " + vc + ", " + t), (Object[])new Object[0]);
                }
                this._wl.onError(t);
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"writeListener.onError.failed", (Object[])new Object[]{this._wl, e.toString()});
            }
            finally {
                this._contextManager.popContextData();
                reqState.removeAttribute("com.ibm.ws.webcontainer.upgrade.AllowWriteFromE");
            }
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error callback called , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
        }
        this.error(vc, ioe);
    }
}

