/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.artifact.proxy.ChunkListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.impl.ChunkHelper;
import com.ibm.jbatch.container.impl.RetryHandler;
import com.ibm.jbatch.container.impl.SkipHandler;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointManager;
import com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.ItemProcessor;
import com.ibm.jbatch.jsl.model.ItemReader;
import com.ibm.jbatch.jsl.model.ItemWriter;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ChunkStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = ChunkStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected static final int DEFAULT_TRAN_TIMEOUT_SECONDS = 180;
    private Chunk chunk;
    private ItemReaderProxy readerProxy;
    private ItemProcessorProxy processorProxy;
    private ItemWriterProxy writerProxy;
    private CheckpointManager checkpointManager;
    private SkipHandler skipHandler;
    List<ChunkListenerProxy> chunkListeners;
    List<SkipProcessListenerProxy> skipProcessListeners;
    List<SkipReadListenerProxy> skipReadListeners;
    List<SkipWriteListenerProxy> skipWriteListeners;
    List<RetryProcessListenerProxy> retryProcessListeners;
    List<RetryReadListenerProxy> retryReadListeners;
    List<RetryWriteListenerProxy> retryWriteListeners;
    List<ItemReadListenerProxy> itemReadListeners;
    List<ItemProcessListenerProxy> itemProcessListeners;
    List<ItemWriteListenerProxy> itemWriteListeners;
    private RetryHandler retryHandler;
    long readCount;
    long writeCount;
    long readSkipCount;
    long processSkipCount;
    long writeSkipCount;
    protected ChunkStatus currentChunkStatus;
    protected SingleItemStatus currentItemStatus;
    protected boolean customCheckpointPolicy;
    protected Integer checkpointAtThisItemCount;
    protected int stepPropertyTranTimeoutSeconds;
    static final long serialVersionUID = 8758389734807363097L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ChunkStepControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, Step step) {
        super(runtimeWorkUnitExecution, step);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, step});
        }
        this.chunk = null;
        this.readerProxy = null;
        this.processorProxy = null;
        this.writerProxy = null;
        this.skipHandler = null;
        this.chunkListeners = null;
        this.skipProcessListeners = null;
        this.skipReadListeners = null;
        this.skipWriteListeners = null;
        this.retryProcessListeners = null;
        this.retryReadListeners = null;
        this.retryWriteListeners = null;
        this.itemReadListeners = null;
        this.itemProcessListeners = null;
        this.itemWriteListeners = null;
        this.readCount = 0L;
        this.writeCount = 0L;
        this.readSkipCount = 0L;
        this.processSkipCount = 0L;
        this.writeSkipCount = 0L;
        this.customCheckpointPolicy = false;
        this.checkpointAtThisItemCount = null;
        this.stepPropertyTranTimeoutSeconds = 180;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<Object> readAndProcess() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "readAndProcess", new Object[0]);
        }
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        Object itemRead = null;
        Object itemProcessed = null;
        do {
            this.currentItemStatus = new SingleItemStatus();
            itemRead = this.readItem();
            if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) break;
            if (!this.currentItemStatus.isSkipped() && !this.currentChunkStatus.hasReadNull()) {
                itemProcessed = this.processItem(itemRead);
                if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) break;
                if (!this.currentItemStatus.isSkipped() && !this.currentItemStatus.isFiltered()) {
                    chunkToWrite.add(itemProcessed);
                }
            }
            if (this.currentChunkStatus.isRetryingAfterRollback()) break;
            if (this.runtimeStepExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.currentChunkStatus.markStopping();
            } else {
                BatchStatus status = this.getBatchKernelService().getBatchStatus(this.runtimeWorkUnitExecution.getTopLevelExecutionId());
                if (null == status) {
                    logger.finer("Local BatchStatus not found, querying DB");
                    JobExecutionEntity jobExecution = this.getPersistenceManagerService().getJobExecution(this.runtimeWorkUnitExecution.getTopLevelExecutionId());
                    status = jobExecution.getBatchStatus();
                }
                if (!status.equals((Object)BatchStatus.STOPPING) && !status.equals((Object)BatchStatus.STOPPED)) continue;
                this.currentChunkStatus.markStopping();
                this.markStepStopping();
            }
            break;
        } while (!this.checkpointManager.isReadyToCheckpoint() && !this.currentChunkStatus.hasReadNull());
        ArrayList<Object> arrayList = chunkToWrite;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "readAndProcess", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object readItem() {
        Object itemRead = null;
        try {
            this.currentChunkStatus.incrementItemsTouchedInCurrentChunk();
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.beforeRead();
            }
            itemRead = this.readerProxy.readItem();
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.afterRead(itemRead);
            }
            if (itemRead == null) {
                this.currentChunkStatus.markReadNull();
                this.currentChunkStatus.decrementItemsTouchedInCurrentChunk();
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"342", (Object)this, (Object[])new Object[0]);
            this.runtimeStepExecution.setException((Exception)e);
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.onReadError((Exception)e);
            }
            if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                if (this.retryReadException((Exception)e)) {
                    if (!this.retryHandler.isRollbackException((Exception)e)) {
                        itemRead = this.readItem();
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                    }
                }
                if (this.skipReadException((Exception)e)) {
                    this.currentItemStatus.setSkipped(true);
                    this.runtimeStepExecution.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            if (this.skipReadException((Exception)e)) {
                this.currentItemStatus.setSkipped(true);
                this.runtimeStepExecution.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
            }
            if (this.retryReadException((Exception)e)) {
                if (!this.retryHandler.isRollbackException((Exception)e)) {
                    itemRead = this.readItem();
                } else {
                    this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                }
            }
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"381", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "readItem", itemRead == null ? "<null>" : itemRead);
        return itemRead;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object processItem(Object itemRead) {
        logger.entering(sourceClass, "processItem", itemRead);
        Object processedItem = null;
        if (this.processorProxy == null) {
            return itemRead;
        }
        try {
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.beforeProcess(itemRead);
            }
            processedItem = this.processorProxy.processItem(itemRead);
            if (processedItem == null) {
                this.currentItemStatus.setFiltered(true);
            }
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.afterProcess(itemRead, processedItem);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"421", (Object)this, (Object[])new Object[]{itemRead});
            this.runtimeStepExecution.setException((Exception)e);
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.onProcessError(itemRead, (Exception)e);
            }
            if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                if (this.retryProcessException((Exception)e, itemRead)) {
                    if (!this.retryHandler.isRollbackException((Exception)e)) {
                        processedItem = this.processItem(itemRead);
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                    }
                }
                if (this.skipProcessException((Exception)e, itemRead)) {
                    this.currentItemStatus.setSkipped(true);
                    this.runtimeStepExecution.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            if (this.skipProcessException((Exception)e, itemRead)) {
                this.currentItemStatus.setSkipped(true);
                this.runtimeStepExecution.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
            }
            if (this.retryProcessException((Exception)e, itemRead)) {
                if (!this.retryHandler.isRollbackException((Exception)e)) {
                    processedItem = this.processItem(itemRead);
                } else {
                    this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                }
            }
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"457", (Object)this, (Object[])new Object[]{itemRead});
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "processItem", processedItem == null ? "<null>" : processedItem);
        return processedItem;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeChunk(List<Object> theChunk) {
        logger.entering(sourceClass, "writeChunk", theChunk);
        if (!theChunk.isEmpty()) {
            try {
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.beforeWrite(theChunk);
                }
                this.writerProxy.writeItems(theChunk);
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.afterWrite(theChunk);
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"486", (Object)this, (Object[])new Object[]{theChunk});
                this.runtimeStepExecution.setException((Exception)e);
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.onWriteError(theChunk, (Exception)e);
                }
                if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                    if (this.retryWriteException((Exception)e, theChunk)) {
                        if (!this.retryHandler.isRollbackException((Exception)e)) {
                            this.writeChunk(theChunk);
                        } else {
                            this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                        }
                    }
                    if (this.skipWriteException((Exception)e, theChunk)) {
                        this.runtimeStepExecution.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                    }
                    throw new BatchContainerRuntimeException((Throwable)e);
                }
                if (this.skipWriteException((Exception)e, theChunk)) {
                    this.runtimeStepExecution.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                }
                if (this.retryWriteException((Exception)e, theChunk)) {
                    if (!this.retryHandler.isRollbackException((Exception)e)) {
                        this.writeChunk(theChunk);
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry((Exception)e);
                    }
                }
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"522", (Object)this, (Object[])new Object[]{theChunk});
                throw new BatchContainerRuntimeException(e);
            }
        }
        logger.exiting(sourceClass, "writeChunk");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ChunkStatus getNextChunkStatusBasedOnPrevious() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "getNextChunkStatusBasedOnPrevious", new Object[0]);
        }
        if (this.currentChunkStatus == null) {
            ChunkStatus chunkStatus = new ChunkStatus();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                chunkStatus = chunkStatus;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "getNextChunkStatusBasedOnPrevious", chunkStatus);
            }
            return chunkStatus;
        }
        ChunkStatus nextChunkStatus = null;
        if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
            this.getTransactionManager().begin();
            this.positionReaderAtCheckpoint();
            this.positionWriterAtCheckpoint();
            this.getTransactionManager().commit();
            nextChunkStatus = new ChunkStatus(ChunkStatusType.RETRY_AFTER_ROLLBACK);
            int numToProcessOneByOne = this.currentChunkStatus.getItemsToProcessOneByOneAfterRollback();
            if (numToProcessOneByOne > 0) {
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(numToProcessOneByOne);
            } else {
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(this.currentChunkStatus.getItemsTouchedInCurrentChunk());
            }
        } else if (this.currentChunkStatus.isRetryingAfterRollback()) {
            int numToProcessOneByOne = this.currentChunkStatus.getItemsToProcessOneByOneAfterRollback();
            if (numToProcessOneByOne == 1) {
                nextChunkStatus = new ChunkStatus();
            } else {
                nextChunkStatus = new ChunkStatus(ChunkStatusType.RETRY_AFTER_ROLLBACK);
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(numToProcessOneByOne - 1);
            }
        } else {
            nextChunkStatus = new ChunkStatus();
        }
        ChunkStatus chunkStatus = nextChunkStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            chunkStatus = chunkStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "getNextChunkStatusBasedOnPrevious", chunkStatus);
        }
        return chunkStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void invokeChunk() {
        logger.entering(sourceClass, "invokeChunk");
        List<Object> chunkToWrite = new ArrayList();
        try {
            this.getTransactionManager().begin();
            this.openReaderAndWriter();
            this.getTransactionManager().commit();
            int currentChunk = 1;
            while (true) {
                this.currentChunkStatus = this.getNextChunkStatusBasedOnPrevious();
                this.setNextChunkTransactionTimeout();
                this.checkpointManager.beginCheckpoint();
                this.getTransactionManager().begin();
                for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                    chunkProxy.beforeChunk();
                }
                JoblogUtil.logToJobLogAndTraceOnly(Level.FINEST, "chunk.started", new Object[]{this.runtimeStepExecution.getStepName(), this.getJobInstanceId(), this.getJobExecutionId(), this.runtimeStepExecution.getMetrics()}, logger);
                chunkToWrite = this.readAndProcess();
                if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
                    this.rollbackAfterRetryableException(currentChunk);
                } else {
                    if (chunkToWrite.size() > 0) {
                        this.writeChunk(chunkToWrite);
                    }
                    if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
                        this.rollbackAfterRetryableException(currentChunk);
                    } else {
                        for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                            chunkProxy.afterChunk();
                        }
                        this.checkpointManager.checkpoint();
                        this.updateNormalMetrics(chunkToWrite.size());
                        this.runtimeStepExecution.setLastUpdatedTime(new Date());
                        this.updateStepExecution();
                        this.getPersistenceManagerService().updateStepThreadInstanceWithCheckpointData(this.getStepThreadInstance());
                        this.getTransactionManager().commit();
                        JoblogUtil.logToJobLogAndTraceOnly(Level.FINEST, "chunk.ended", new Object[]{this.runtimeStepExecution.getStepName(), this.getJobInstanceId(), this.getJobExecutionId(), this.runtimeStepExecution.getMetrics()}, logger);
                        this.checkpointManager.endCheckpoint();
                        this.publishCheckpointEvent(this.runtimeStepExecution.getStepName(), this.getJobInstanceId(), this.getJobExecutionId(), this.runtimeStepExecution.getTopLevelStepExecutionId());
                        this.invokeCollectorIfPresent();
                        if (this.currentChunkStatus.hasReadNull() || this.currentChunkStatus.isStopping()) {
                            this.getTransactionManager().begin();
                            this.writerProxy.close();
                            this.readerProxy.close();
                            this.getTransactionManager().commit();
                            break;
                        }
                    }
                }
                ++currentChunk;
            }
        }
        catch (Throwable currentChunk) {
            void t;
            FFDCFilter.processException((Throwable)currentChunk, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"681", (Object)this, (Object[])new Object[0]);
            try {
                JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "chunk.rollback", new Object[]{this.runtimeStepExecution.getStepName(), this.getJobInstanceId(), this.getJobExecutionId(), this.runtimeStepExecution.getMetrics()}, logger);
                this.callReaderAndWriterCloseOnThrowable((Throwable)t);
                if (t instanceof Exception) {
                    this.callChunkListenerOnError((Exception)t);
                }
                this.runtimeStepExecution.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
            }
            finally {
                this.getTransactionManager().rollback();
            }
            logger.exiting(sourceClass, "invokeChunk");
            throw new BatchContainerRuntimeException("Failure in Read-Process-Write Loop", (Throwable)t);
        }
        logger.finest("Exiting normally");
        logger.exiting(sourceClass, "invokeChunk");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishCheckpointEvent(String stepName, long jobInstanceId, long jobExecutionId, long stepExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "publishCheckpointEvent", new Object[]{stepName, jobInstanceId, jobExecutionId, stepExecutionId});
        }
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        if (publisher != null) {
            String correlationId = this.runtimeWorkUnitExecution.getCorrelationId();
            publisher.publishCheckpointEvent(stepName, jobInstanceId, jobExecutionId, stepExecutionId, correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "publishCheckpointEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void updateNormalMetrics(int writeCount) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "updateNormalMetrics", new Object[]{writeCount});
        }
        int readCount = this.currentChunkStatus.getItemsTouchedInCurrentChunk();
        int filterCount = readCount - writeCount;
        if (readCount < 0 || filterCount < 0 || writeCount < 0) {
            throw new IllegalStateException("Somehow one of the metrics was zero.  Read count: " + readCount + ", Filter count: " + filterCount + ", Write count: " + writeCount);
        }
        this.runtimeStepExecution.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
        this.runtimeStepExecution.getMetric(Metric.MetricType.READ_COUNT).incValueBy(readCount);
        this.runtimeStepExecution.getMetric(Metric.MetricType.FILTER_COUNT).incValueBy(filterCount);
        this.runtimeStepExecution.getMetric(Metric.MetricType.WRITE_COUNT).incValueBy(writeCount);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "updateNormalMetrics");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void callChunkListenerOnError(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "callChunkListenerOnError", new Object[]{e});
        }
        logger.fine("Caught exception in chunk processing. Attempting to call onError() for chunk listeners.");
        for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
            try {
                chunkProxy.onError(e);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"749", (Object)this, (Object[])new Object[]{e});
                throw new BatchContainerRuntimeException("Caught secondary throwable when calling chunk listener onError().", (Throwable)t);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "callChunkListenerOnError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void rollbackAfterRetryableException(int currentChunk) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "rollbackAfterRetryableException", new Object[]{currentChunk});
        }
        JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "chunk.rollback.and.retry", new Object[]{this.runtimeStepExecution.getStepName(), this.getJobInstanceId(), this.getJobExecutionId(), this.runtimeStepExecution.getMetrics()}, logger);
        this.writerProxy.close();
        this.readerProxy.close();
        this.callChunkListenerOnError(this.currentChunkStatus.getRetryableException());
        this.getTransactionManager().rollback();
        this.runtimeStepExecution.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "rollbackAfterRetryableException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void callReaderAndWriterCloseOnThrowable(Throwable t) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "callReaderAndWriterCloseOnThrowable", new Object[]{t});
        }
        logger.fine("Caught throwable in chunk processing. Attempting to close all readers and writers.");
        try {
            this.writerProxy.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"775", (Object)this, (Object[])new Object[]{t});
        }
        try {
            this.readerProxy.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"781", (Object)this, (Object[])new Object[]{t});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "callReaderAndWriterCloseOnThrowable");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokeCoreStep() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "invokeCoreStep", new Object[0]);
        }
        this.chunk = this.getStep().getChunk();
        this.initializeChunkArtifacts();
        this.initializeCheckpointManager();
        this.invokeChunk();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "invokeCoreStep");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initializeCheckpointManager() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "initializeCheckpointManager", new Object[0]);
        }
        Object checkpointAlgorithm = null;
        this.checkpointAtThisItemCount = ChunkHelper.getItemCount(this.chunk);
        int timeLimitSeconds = ChunkHelper.getTimeLimit(this.chunk);
        this.customCheckpointPolicy = ChunkHelper.isCustomCheckpointPolicy(this.chunk);
        if (!this.customCheckpointPolicy) {
            ItemCheckpointAlgorithm ica = new ItemCheckpointAlgorithm();
            ica.setItemCount(this.checkpointAtThisItemCount);
            ica.setTimeLimitSeconds(timeLimitSeconds);
            logger.fine("Initialize checkpoint manager with item-count=" + this.checkpointAtThisItemCount + ", and time limit = " + timeLimitSeconds + " seconds.");
            checkpointAlgorithm = ica;
        } else {
            if (this.chunk.getCheckpointAlgorithm() == null) {
                throw new IllegalArgumentException("Configured checkpoint-policy of 'custom' but without a corresponding <checkpoint-algorithm> element.");
            }
            try {
                List<Property> propList = this.chunk.getCheckpointAlgorithm().getProperties() == null ? null : this.chunk.getCheckpointAlgorithm().getProperties().getPropertyList();
                InjectionReferences injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propList);
                checkpointAlgorithm = ProxyFactory.createCheckpointAlgorithmProxy(this.chunk.getCheckpointAlgorithm().getRef(), injectionRef, this.runtimeStepExecution);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created CheckpointAlgorithmProxy for custom checkpoint algorithm [" + checkpointAlgorithm + "]");
                }
            }
            catch (ArtifactValidationException propList) {
                void e;
                FFDCFilter.processException((Throwable)propList, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"831", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot create the CheckpointAlgorithm for policy [" + this.chunk.getCheckpointPolicy() + "]", (Throwable)e);
            }
        }
        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, (CheckpointAlgorithm)checkpointAlgorithm, this.getStepThreadInstance(), this.getPersistenceManagerService());
        this.stepPropertyTranTimeoutSeconds = this.initStepTransactionTimeout();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "initializeCheckpointManager");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initializeChunkArtifacts() {
        InjectionReferences injectionRef4;
        ItemWriter itemWriter;
        ItemReader itemReader;
        String sourceMethod = "initializeChunkArtifacts";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        List<Property> itemReaderProps = (itemReader = this.chunk.getReader()).getProperties() == null ? null : itemReader.getProperties().getPropertyList();
        try {
            InjectionReferences injectionRef2 = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, itemReaderProps);
            this.readerProxy = ProxyFactory.createItemReaderProxy(itemReader.getRef(), injectionRef2, this.runtimeStepExecution);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemReaderProxy for " + itemReader.getRef());
            }
        }
        catch (ArtifactValidationException injectionRef2) {
            void e;
            FFDCFilter.processException((Throwable)injectionRef2, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"864", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Cannot create the ItemReader [" + itemReader.getRef() + "]", (Throwable)e);
        }
        ItemProcessor itemProcessor = this.chunk.getProcessor();
        if (itemProcessor != null) {
            List<Property> itemProcessorProps = itemProcessor.getProperties() == null ? null : itemProcessor.getProperties().getPropertyList();
            try {
                InjectionReferences injectionRef3 = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, itemProcessorProps);
                this.processorProxy = ProxyFactory.createItemProcessorProxy(itemProcessor.getRef(), injectionRef3, this.runtimeStepExecution);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created ItemProcessorProxy for " + itemProcessor.getRef());
                }
            }
            catch (ArtifactValidationException injectionRef3) {
                void e;
                FFDCFilter.processException((Throwable)injectionRef3, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"879", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot create the ItemProcessor [" + itemProcessor.getRef() + "]", (Throwable)e);
            }
        }
        List<Property> itemWriterProps = (itemWriter = this.chunk.getWriter()).getProperties() == null ? null : itemWriter.getProperties().getPropertyList();
        try {
            injectionRef4 = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, itemWriterProps);
            this.writerProxy = ProxyFactory.createItemWriterProxy(itemWriter.getRef(), injectionRef4, this.runtimeStepExecution);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemWriterProxy for " + itemWriter.getRef());
            }
        }
        catch (ArtifactValidationException injectionRef4) {
            void e;
            FFDCFilter.processException((Throwable)injectionRef4, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"893", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Cannot create the ItemWriter [" + itemWriter.getRef() + "]", (Throwable)e);
        }
        injectionRef4 = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, null);
        this.chunkListeners = this.runtimeWorkUnitExecution.getListenerFactory().getChunkListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.skipProcessListeners = this.runtimeWorkUnitExecution.getListenerFactory().getSkipProcessListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.skipReadListeners = this.runtimeWorkUnitExecution.getListenerFactory().getSkipReadListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.skipWriteListeners = this.runtimeWorkUnitExecution.getListenerFactory().getSkipWriteListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.retryProcessListeners = this.runtimeWorkUnitExecution.getListenerFactory().getRetryProcessListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.retryReadListeners = this.runtimeWorkUnitExecution.getListenerFactory().getRetryReadListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.retryWriteListeners = this.runtimeWorkUnitExecution.getListenerFactory().getRetryWriteListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.itemReadListeners = this.runtimeWorkUnitExecution.getListenerFactory().getItemReadListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.itemProcessListeners = this.runtimeWorkUnitExecution.getListenerFactory().getItemProcessListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        this.itemWriteListeners = this.runtimeWorkUnitExecution.getListenerFactory().getItemWriteListeners(this.getStep(), injectionRef4, this.runtimeStepExecution);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Setting contexts for chunk artifacts");
        }
        this.skipHandler = new SkipHandler(this.chunk, this.runtimeStepExecution);
        this.skipHandler.addSkipProcessListener(this.skipProcessListeners);
        this.skipHandler.addSkipReadListener(this.skipReadListeners);
        this.skipHandler.addSkipWriteListener(this.skipWriteListeners);
        this.retryHandler = new RetryHandler(this.chunk, this.runtimeStepExecution);
        this.retryHandler.addRetryProcessListener(this.retryProcessListeners);
        this.retryHandler.addRetryReadListener(this.retryReadListeners);
        this.retryHandler.addRetryWriteListener(this.retryWriteListeners);
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void openReaderAndWriter() {
        CheckpointData checkpointData;
        String sourceMethod = "openReaderAndWriter";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        if ((checkpointData = this.getStepThreadInstance().getCheckpointData()) != null) {
            Serializable readerChkpt = checkpointData.getReaderCheckpoint();
            this.readerProxy.open(readerChkpt);
            Serializable writerChkpt = checkpointData.getWriterCheckpoint();
            this.writerProxy.open(writerChkpt);
        } else {
            try {
                checkpointData = new CheckpointData();
                checkpointData.setReaderCheckpoint(null);
                checkpointData.setWriterCheckpoint(null);
                this.getStepThreadInstance().setCheckpointData(checkpointData);
            }
            catch (Exception readerChkpt) {
                FFDCFilter.processException((Throwable)readerChkpt, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"949", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot persist the checkpoint data for " + this.getStepThreadInstance());
            }
            this.readerProxy.open(null);
            this.writerProxy.open(null);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "stop", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            if (this.isStepStartingOrStarted()) {
                this.markStepStopping();
            } else {
                logger.fine("Ignoring stop, since step not in a state which has a valid status (might not be far enough along to have a state yet)");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean skipReadException(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipReadException", new Object[]{e});
        }
        try {
            this.skipHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"982", (Object)this, (Object[])new Object[]{e});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipReadException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipReadException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean retryReadException(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryReadException", new Object[]{e});
        }
        try {
            this.retryHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"994", (Object)this, (Object[])new Object[]{e});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryReadException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryReadException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean skipProcessException(Exception e, Object record) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipProcessException", new Object[]{e, record});
        }
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"1006", (Object)this, (Object[])new Object[]{e, record});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipProcessException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipProcessException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean retryProcessException(Exception e, Object record) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryProcessException", new Object[]{e, record});
        }
        try {
            this.retryHandler.handleExceptionProcess(e, record);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"1018", (Object)this, (Object[])new Object[]{e, record});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryProcessException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryProcessException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipWriteException", new Object[]{e, chunkToWrite});
        }
        try {
            this.skipHandler.handleExceptionWithRecordListWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"1030", (Object)this, (Object[])new Object[]{e, chunkToWrite});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipWriteException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "skipWriteException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryWriteException", new Object[]{e, chunkToWrite});
        }
        try {
            this.retryHandler.handleExceptionWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException batchContainerRuntimeException) {
            FFDCFilter.processException((Throwable)batchContainerRuntimeException, (String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", (String)"1042", (Object)this, (Object[])new Object[]{e, chunkToWrite});
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryWriteException", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "retryWriteException", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setNextChunkTransactionTimeout() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "setNextChunkTransactionTimeout", new Object[0]);
        }
        int nextTimeout = 0;
        nextTimeout = this.customCheckpointPolicy ? this.checkpointManager.checkpointTimeout() : this.stepPropertyTranTimeoutSeconds;
        this.getTransactionManager().setTransactionTimeout(nextTimeout);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "setNextChunkTransactionTimeout");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int initStepTransactionTimeout() {
        logger.entering(sourceClass, "initStepTransactionTimeout");
        Properties p = this.runtimeStepExecution.getProperties();
        int timeout = 180;
        if (p != null && !p.isEmpty()) {
            String propertyTimeOut = p.getProperty("javax.transaction.global.timeout");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "javax.transaction.global.timeout = {0}", propertyTimeOut == null ? "<null>" : propertyTimeOut);
            }
            if (propertyTimeOut != null && !propertyTimeOut.isEmpty()) {
                timeout = Integer.parseInt(propertyTimeOut, 10);
            }
        }
        logger.exiting(sourceClass, "initStepTransactionTimeout", timeout);
        return timeout;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void positionReaderAtCheckpoint() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "positionReaderAtCheckpoint", new Object[0]);
        }
        CheckpointData checkpointData = this.getStepThreadInstance().getCheckpointData();
        if (checkpointData == null) {
            String msg = "Didn't find checkpoint data for stepThreadInstance = " + this.getStepThreadInstance();
            throw new IllegalStateException(msg);
        }
        Serializable checkpointInfo = checkpointData.getReaderCheckpoint();
        this.readerProxy.open(checkpointInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "positionReaderAtCheckpoint");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void positionWriterAtCheckpoint() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "positionWriterAtCheckpoint", new Object[0]);
        }
        CheckpointData checkpointData = this.getStepThreadInstance().getCheckpointData();
        if (checkpointData == null) {
            String msg = "Didn't find checkpoint data for key = " + this.getStepThreadInstance();
            throw new IllegalStateException(msg);
        }
        Serializable checkpointInfo = checkpointData.getWriterCheckpoint();
        this.writerProxy.open(checkpointInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl", "positionWriterAtCheckpoint");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ChunkStatus {
        ChunkStatusType type;
        private boolean readNull = false;
        private boolean stopping = false;
        private Exception retryableException = null;
        private boolean markedForRollbackWithRetry = false;
        private int itemsTouchedInCurrentChunk = 0;
        private int itemsToProcessOneByOneAfterRollback = 0;
        static final long serialVersionUID = 1705563088568799597L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ChunkStatus() {
            this.type = ChunkStatusType.NORMAL;
        }

        ChunkStatus(ChunkStatusType type) {
            this.type = type;
        }

        public boolean isStopping() {
            return this.stopping;
        }

        public void markStopping() {
            this.stopping = true;
        }

        public boolean hasReadNull() {
            return this.readNull;
        }

        public void markReadNull() {
            this.readNull = true;
        }

        public boolean isRetryingAfterRollback() {
            return this.type == ChunkStatusType.RETRY_AFTER_ROLLBACK;
        }

        public boolean wasMarkedForRollbackWithRetry() {
            return this.markedForRollbackWithRetry;
        }

        public Exception getRetryableException() {
            return this.retryableException;
        }

        public void markForRollbackWithRetry(Exception retryableException) {
            this.markedForRollbackWithRetry = true;
            this.retryableException = retryableException;
        }

        public int getItemsTouchedInCurrentChunk() {
            return this.itemsTouchedInCurrentChunk;
        }

        public void decrementItemsTouchedInCurrentChunk() {
            --this.itemsTouchedInCurrentChunk;
        }

        public void incrementItemsTouchedInCurrentChunk() {
            ++this.itemsTouchedInCurrentChunk;
        }

        public int getItemsToProcessOneByOneAfterRollback() {
            return this.itemsToProcessOneByOneAfterRollback;
        }

        public void setItemsToProcessOneByOneAfterRollback(int itemsToProcessOneByOneAfterRollback) {
            this.itemsToProcessOneByOneAfterRollback = itemsToProcessOneByOneAfterRollback;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl$ChunkStatus", ChunkStatus.class, (String)"wsbatch", null);
        }
    }

    private static enum ChunkStatusType {
        NORMAL,
        RETRY_AFTER_ROLLBACK;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class SingleItemStatus {
        private boolean skipped = false;
        private boolean filtered = false;
        static final long serialVersionUID = -162324464937856931L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SingleItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.ChunkStepControllerImpl$SingleItemStatus", SingleItemStatus.class, (String)"wsbatch", null);
        }
    }
}

