/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.extensions.SupportedHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.stack.util.AmbiguousUriException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;

public class SipStackUtil {
    private static final LogMgr c_logger = Log.get(SipStackUtil.class);
    public static final String STRICT_ROUTING_PARAM = "ibmsr";
    public static final String DESTINATION_URI = "IBM-Destination";
    public static final String SIP_SCHEME = "sip";
    public static final String SIPS_SCHEME = "sips";
    public static final String TLS_TRANSPORT = "tls";
    public static final int DEFAULT_TLS_PORT = 5061;
    public static final String OB_PARAM = "ob";
    public static final String IBM_OB_PARAM = "ibm-ob";
    public static final String IBM_PROXY_HOST_PARAM = "ibm-proxyhost";
    public static final String IBM_PROXY_PORT_PARAM = "ibm-proxyport";
    public static final String IBM_TAMPERED_PARAM = "ibm-tampered";

    public static void setDestinationHeader(SipURL targetAddressUri, Message message) throws SipParseException {
        NameAddressHeader ibmDestination;
        String scheme = targetAddressUri.getScheme();
        if (scheme != null) {
            String transport = targetAddressUri.getTransport();
            int port = targetAddressUri.getPort();
            if (scheme.equals(SIP_SCHEME)) {
                if (transport == null) {
                    targetAddressUri.setTransport("udp");
                    transport = "udp";
                }
                if (port < 0) {
                    if (transport.equalsIgnoreCase(TLS_TRANSPORT)) {
                        targetAddressUri.setPort(5061);
                    } else {
                        targetAddressUri.setPort(5060);
                    }
                }
            } else if (scheme.equals(SIPS_SCHEME)) {
                if (transport == null || !transport.equalsIgnoreCase(TLS_TRANSPORT)) {
                    targetAddressUri.setTransport(TLS_TRANSPORT);
                }
                if (port < 0) {
                    targetAddressUri.setPort(5061);
                }
            }
        }
        if ((ibmDestination = (NameAddressHeader)message.getHeader(DESTINATION_URI, true)) == null) {
            AddressFactory addressFactory = SipJainFactories.getInstance().getAddressFactory();
            NameAddress address = addressFactory.createNameAddress(targetAddressUri);
            ibmDestination = new GenericNameAddressHeaderImpl(DESTINATION_URI);
            ibmDestination.setNameAddress(address);
            message.setHeader(ibmDestination, true);
        } else {
            NameAddress address = ibmDestination.getNameAddress();
            address.setAddress(targetAddressUri);
        }
        if (SipStackUtil.isOutOfDialogRequest(message)) {
            SipStackUtil.fixHeaders(message);
        }
    }

    private static SipURL createTargetFromRequest(Request message) throws IOException {
        SipURL sipUrlToSend = null;
        try {
            URI uriToSend;
            NameAddressHeader destination = (NameAddressHeader)message.getHeader(DESTINATION_URI, true);
            if (destination == null) {
                NameAddressHeader topRoute = (NameAddressHeader)message.getHeader("Route", true);
                if (topRoute == null) {
                    uriToSend = message.getRequestURI();
                } else {
                    uriToSend = topRoute.getNameAddress().getAddress();
                    if (!(uriToSend instanceof SipURL)) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("Error: getTargetSipUri - top route uri is not a SipURL");
                        }
                        throw new IOException("top Route URI is not a SIP URI");
                    }
                    sipUrlToSend = (SipURL)uriToSend;
                    boolean strictRouting = sipUrlToSend.hasParameter(STRICT_ROUTING_PARAM);
                    if (strictRouting) {
                        uriToSend = message.getRequestURI();
                    }
                }
            } else {
                uriToSend = destination.getNameAddress().getAddress();
            }
            if (!(uriToSend instanceof SipURL)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Error: getTargetSipUri - top route uri is not a SipURL");
                }
                throw new IOException("URI is not a SIP URI");
            }
            sipUrlToSend = (SipURL)uriToSend;
        }
        catch (SipParseException e2) {
            throw new IOException(e2.getMessage());
        }
        String scheme = sipUrlToSend.getScheme();
        if (scheme != null) {
            String transport = sipUrlToSend.getTransport();
            if (scheme.equalsIgnoreCase(SIPS_SCHEME) && transport != null) {
                if (transport.equalsIgnoreCase("udp")) {
                    throw new AmbiguousUriException(sipUrlToSend.toString());
                }
                if (!transport.equalsIgnoreCase("tcp")) {
                    try {
                        sipUrlToSend.setTransport("tcp");
                    }
                    catch (SipParseException e3) {
                        throw new IOException(e3.getMessage());
                    }
                }
            }
        }
        return sipUrlToSend;
    }

    public static String transportToScheme(String transport) {
        if (transport.equalsIgnoreCase("udp")) {
            return SIP_SCHEME;
        }
        if (transport.equalsIgnoreCase("tcp")) {
            return SIP_SCHEME;
        }
        if (transport.equalsIgnoreCase(TLS_TRANSPORT)) {
            return SIPS_SCHEME;
        }
        return null;
    }

    public static SipURL createTargetFromMessage(Message message) throws IllegalArgumentException, IOException {
        block4: {
            try {
                if (message instanceof Response) {
                    Response response = (Response)message;
                    return SipStackUtil.createTargetFromResponse(response);
                }
                if (message instanceof Request) {
                    Request request = (Request)message;
                    return SipStackUtil.createTargetFromRequest(request);
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug("Error: createTargetFromMessage - could not create target due to exception: " + e2.getMessage());
            }
        }
        return null;
    }

    private static SipURL createTargetFromResponse(Response response) throws IllegalArgumentException, SipParseException {
        ViaHeader topVia = (ViaHeader)response.getHeader("Via", true);
        AddressFactory addressFactory = SipJainFactories.getInstance().getAddressFactory();
        String host = topVia.getHost();
        String transport = topVia.getTransport();
        String scheme = SipStackUtil.transportToScheme(transport);
        int port = SipStackUtil.isHostName(host) ? topVia.getPort() : SipStackUtil.getPortFromTopVia(topVia, false);
        SipURL resultUrl = addressFactory.createSipURL(host);
        if (port > 0) {
            resultUrl.setPort(port);
        }
        resultUrl.setTransport(topVia.getTransport());
        resultUrl.setScheme(scheme);
        return resultUrl;
    }

    public static int getPortFromTopVia(ViaHeader topVia, boolean mindRport) {
        int aliasPort;
        int rport = mindRport ? topVia.getRPort() : 0;
        int n = aliasPort = rport > 0 ? rport : topVia.getPort();
        if (aliasPort < 0) {
            String transport = topVia.getTransport();
            aliasPort = transport != null && transport.equalsIgnoreCase(TLS_TRANSPORT) ? 5061 : 5060;
        }
        return aliasPort;
    }

    public static boolean topViaHasReceivedTag(Message message) {
        try {
            ViaHeader topVia = (ViaHeader)message.getHeader("Via", true);
            return topVia.hasReceived();
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean isHostName(String address) {
        char hint = address.charAt(0);
        switch (hint) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return false;
            }
            case ':': 
            case '[': {
                return false;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return address.indexOf(58) == -1;
            }
        }
        return true;
    }

    public static void fixHeaders(Message message) throws IllegalArgumentException, SipParseException {
        Request req;
        URI uriToSend;
        RouteHeader topRoute = (RouteHeader)message.getHeader("Route", true);
        if (topRoute != null && (uriToSend = topRoute.getNameAddress().getAddress()) != null) {
            SipStackUtil.fixTargetSipUri(uriToSend);
        }
        if (message instanceof Request && (uriToSend = (req = (Request)message).getRequestURI()) != null) {
            SipStackUtil.fixTargetSipUri(uriToSend);
        }
    }

    public static SipURL fixTargetSipUri(URI uriToSend) {
        SipURL sipUrlToSend;
        block6: {
            sipUrlToSend = null;
            if (!(uriToSend instanceof SipURL)) {
                return null;
            }
            sipUrlToSend = (SipURL)uriToSend;
            try {
                String scheme = sipUrlToSend.getScheme();
                if (scheme == null) break block6;
                String transport = sipUrlToSend.getTransport();
                if (!scheme.equalsIgnoreCase(SIPS_SCHEME) || transport == null) break block6;
                if (transport.equalsIgnoreCase("udp")) {
                    throw new AmbiguousUriException(sipUrlToSend.toString());
                }
                if (transport.equalsIgnoreCase("tcp")) break block6;
                try {
                    sipUrlToSend.setTransport("tcp");
                }
                catch (SipParseException e2) {
                    throw new IOException(e2.getMessage());
                }
            }
            catch (Exception e3) {
                if (!c_logger.isTraceDebugEnabled()) break block6;
                c_logger.traceDebug("Exception ocurred while trying to fix uri: " + uriToSend);
            }
        }
        return sipUrlToSend;
    }

    public static boolean isOutOfDialogRequest(Message message) {
        boolean hasTag;
        try {
            hasTag = message.getToHeader().hasTag();
        }
        catch (Exception e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(c_logger.getClass(), "isOutOfDialogRequest", "error in To header", e2);
            }
            hasTag = false;
        }
        return !hasTag;
    }

    public static boolean isSlspStartup(Request request) {
        try {
            MaxForwardsHeader maxForwardsHeader;
            ViaHeader botVia;
            String method = request.getMethod();
            if (!method.equals("STARTUP")) {
                return false;
            }
            URI uri = request.getRequestURI();
            if (!(uri instanceof SipURL)) {
                return false;
            }
            SipURL url = (SipURL)uri;
            if (url.hasUserName()) {
                return false;
            }
            ViaHeader topVia = (ViaHeader)request.getHeader("Via", true);
            if (topVia != (botVia = (ViaHeader)request.getHeader("Via", false))) {
                return false;
            }
            try {
                maxForwardsHeader = request.getMaxForwardsHeader();
            }
            catch (HeaderParseException e2) {
                return false;
            }
            return maxForwardsHeader != null && maxForwardsHeader.getMaxForwards() == 0;
        }
        catch (SipParseException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)SipStackUtil.class.getName(), "isSlspStartup", "parse error", e3);
            }
            return false;
        }
    }

    public static boolean isSupported(MessageImpl message, String optionTag) {
        HeaderIterator i = message.getHeaders("Supported");
        if (i == null) {
            return false;
        }
        while (i.hasNext()) {
            try {
                SupportedHeader supported = (SupportedHeader)i.next();
                String supportedOptionTag = supported.getOptionTag();
                if (!supportedOptionTag.equalsIgnoreCase(optionTag)) continue;
                return true;
            }
            catch (Exception e2) {
                if (!c_logger.isTraceFailureEnabled()) continue;
                c_logger.traceFailure(SipStackUtil.class, "isSupported", "", e2);
            }
        }
        return false;
    }

    public static void addToTag(Response response) {
        block12: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(SipStackUtil.class, "addToTag");
            }
            ToHeader toHeader = response.getToHeader();
            String toTag = null;
            if (toHeader != null) {
                toTag = toHeader.getTag();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(SipStackUtil.class, "addToTag", "To-header is not found on the response");
            }
            if (toHeader != null && (toTag == null || toTag.length() == 0)) {
                String tag = null;
                StringBuilder builder = new StringBuilder();
                builder.append(Math.random());
                tag = builder.substring(2);
                try {
                    toHeader.setTag(tag);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipStackUtil.class, "addToTag", "To-Tag was added to an error initial request, tag:" + tag);
                    }
                    break block12;
                }
                catch (IllegalArgumentException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipStackUtil.class, "Exception in addToTag", e2.getMessage());
                    }
                    break block12;
                }
                catch (SipParseException e3) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipStackUtil.class, "Exception in addToTag", e3.getMessage());
                    }
                    break block12;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(SipStackUtil.class, "addToTag", "To-Tag was found, no need to add to-tag, tag:" + toTag);
            }
        }
    }
}

